/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.textfield;

import java.awt.ComponentOrientation;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;

public class ReadOnlyTextPane
extends JTextPane {
    public ReadOnlyTextPane() {
        this("");
    }

    public ReadOnlyTextPane(String text) {
        this.setOpaque(false);
        this.setBorder(null);
        this.setEditable(false);
        this.setText(text);
        this.setFocusable(false);
        this.setForeground(UIManager.getColor("Label.foreground"));
    }

    @Override
    public void setText(String t) {
        ComponentOrientation oldComponentOrientation = this.getComponentOrientation();
        ComponentOrientation newComponentOrientation = this.isRTL(t) ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT;
        if (newComponentOrientation != oldComponentOrientation) {
            this.setComponentOrientation(newComponentOrientation);
        }
        super.setText(t);
    }

    private boolean isRTL(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            byte d = Character.getDirectionality(s.charAt(i));
            if (d != 1 && d != 2 && d != 16 && d != 17) continue;
            return true;
        }
        return false;
    }
}

