/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.button.SquareIconButton;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextPane;
import org.tinymediamanager.ui.dialogs.SettingsDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class ExchangeDatasourceDialog
extends TmmDialog {
    private JLabel lblNewDatasource;

    public ExchangeDatasourceDialog(String datasource) {
        super(SettingsDialog.getInstance(), TmmResourceBundle.getString("Settings.exchangedatasource"), "exchangeDatasource");
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[20lp!][400lp,grow]", "[][10lp!][][][10lp!][][][20lp!]"));
        ReadOnlyTextPane tpDescription = new ReadOnlyTextPane(TmmResourceBundle.getString("Settings.exchangedatasource.desc"));
        panelContent.add((Component)tpDescription, "cell 0 0 2 1,grow");
        TmmLabel lblOldDatasourceT = new TmmLabel(TmmResourceBundle.getString("Settings.exchangedatasource.old"));
        panelContent.add((Component)lblOldDatasourceT, "cell 0 2 2 1");
        JLabel lblOldDatasource = new JLabel(datasource);
        panelContent.add((Component)lblOldDatasource, "cell 1 3,growx");
        TmmLabel lblNewDatasourceT = new TmmLabel(TmmResourceBundle.getString("Settings.exchangedatasource.new"));
        panelContent.add((Component)lblNewDatasourceT, "flowx,cell 0 5");
        SquareIconButton btnChooseNewDatasource = new SquareIconButton(IconManager.FILE_OPEN_INV);
        btnChooseNewDatasource.addActionListener(e -> {
            Path file = TmmUIHelper.selectDirectory(TmmResourceBundle.getString("Settings.datasource.folderchooser"), datasource);
            if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                this.lblNewDatasource.setText(file.toString());
            }
        });
        Component horizontalStrut = Box.createHorizontalStrut(30);
        panelContent.add(horizontalStrut, "cell 0 5");
        panelContent.add((Component)btnChooseNewDatasource, "cell 0 5");
        this.lblNewDatasource = new JLabel("");
        panelContent.add((Component)this.lblNewDatasource, "cell 1 6");
        JButton cancelButton = new JButton(TmmResourceBundle.getString("Button.cancel"));
        cancelButton.setIcon(IconManager.CANCEL_INV);
        cancelButton.addActionListener(e -> {
            this.lblNewDatasource.setText("");
            this.setVisible(false);
        });
        this.addButton(cancelButton);
        JButton okButton = new JButton(TmmResourceBundle.getString("Button.ok"));
        okButton.addActionListener(e -> {
            if (StringUtils.isBlank((CharSequence)this.lblNewDatasource.getText())) {
                JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("Settings.exchangedatasource.error"), TmmResourceBundle.getString("Settings.exchangedatasource"), 0);
                return;
            }
            this.setVisible(false);
        });
        okButton.setIcon(IconManager.APPLY_INV);
        this.addButton(okButton);
    }

    public String getNewDatasource() {
        return this.lblNewDatasource.getText();
    }
}

