/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.WolDevice;
import org.tinymediamanager.ui.panels.AbstractModalInputPanel;

public class WolDevicePanel
extends AbstractModalInputPanel {
    private final WolDevice device;
    private final JTextField tfName;
    private final JTextField tfMacAddress;

    public WolDevicePanel(WolDevice device) {
        this.device = device;
        this.setLayout((LayoutManager)new MigLayout("", "[][]", "[][]"));
        JLabel lblDeviceName = new JLabel(TmmResourceBundle.getString("Settings.devicename"));
        this.add((Component)lblDeviceName, "cell 0 0,alignx right");
        this.tfName = new JTextField();
        this.tfName.setColumns(20);
        this.add((Component)this.tfName, "cell 1 0");
        JLabel lblMacAddress = new JLabel(TmmResourceBundle.getString("Settings.macaddress"));
        this.add((Component)lblMacAddress, "cell 0 1,alignx right");
        this.tfMacAddress = new JTextField();
        this.tfMacAddress.setColumns(20);
        this.add((Component)this.tfMacAddress, "cell 1 1");
        this.tfName.setText(device.getName());
        this.tfMacAddress.setText(device.getMacAddress());
    }

    @Override
    protected void onClose() {
        if (StringUtils.isBlank((CharSequence)this.tfName.getText()) || StringUtils.isBlank((CharSequence)this.tfMacAddress.getText())) {
            JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("message.missingitems"));
            return;
        }
        Pattern pattern = Pattern.compile("^([0-9a-fA-F]{2}[:-]){5}([0-9a-fA-F]{2})$");
        Matcher matcher = pattern.matcher(this.tfMacAddress.getText());
        if (!matcher.matches()) {
            JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("message.invalidmac"));
            return;
        }
        this.device.setName(this.tfName.getText());
        this.device.setMacAddress(this.tfMacAddress.getText());
        this.setVisible(false);
    }
}

