/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowEpisodePostProcessExecutor;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowPostProcessExecutor;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.license.License;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.ui.AbstractTmmUIModule;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.MenuScroller;
import org.tinymediamanager.ui.components.tabbedpane.MainTabbedPane;
import org.tinymediamanager.ui.settings.TmmSettingsNode;
import org.tinymediamanager.ui.thirdparty.KodiRPCMenu;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowSeasonSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.actions.DebugDumpShowAction;
import org.tinymediamanager.ui.tvshows.actions.DebugDumpShowActionWithChilds;
import org.tinymediamanager.ui.tvshows.actions.TvShowAddDatasourceAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowAspectRatioDetectAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowBulkEditAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowChangeDatasourceAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowChangeSeasonArtworkAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowChangeToAbsoluteAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowCleanUpFilesAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowClearImageCacheAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowCopyToAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowDeleteAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowDownloadActorImagesAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowDownloadMissingArtworkAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowDownloadThemeAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowEditAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowExportAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowFetchImdbTop250;
import org.tinymediamanager.ui.tvshows.actions.TvShowFetchRatingsAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowLockAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowMediaInformationAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowMissingEpisodeListAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowOpenFolderAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowReadEpisodeNfoAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowReadNfoAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowRebuildImageCacheAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowRebuildMediainfoXmlAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowRemoveAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowRenameAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowRenamePreviewAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowResetNewFlagAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowRewriteEpisodeNfoAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowRewriteNfoAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowRewriteSeasonNfoAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowScrapeEpisodesAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowScrapeMissingEpisodesAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowScrapeNewItemsAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSelectedScrapeAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSelectedScrapeMetadataAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSingleScrapeAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSubtitleDownloadAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSubtitleSearchAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSyncSelectedCollectionTraktTvAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSyncSelectedRatingTraktTvAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSyncSelectedTraktTvAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSyncSelectedWatchedTraktTvAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowSyncTraktTvAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowTitleToEntityMatcher;
import org.tinymediamanager.ui.tvshows.actions.TvShowToggleWatchedFlagAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowTrailerDownloadAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowTraktTvRemoveFromCollectionAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowTraktTvRemoveFromWatchedAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowUndoRenameAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowUnlockAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowUpdateAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowUpdateDatasourcesAction;
import org.tinymediamanager.ui.tvshows.actions.TvShowUpdateSingleDatasourceAction;
import org.tinymediamanager.ui.tvshows.actions.TvshowChecksumsAction;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowFilterDialog;
import org.tinymediamanager.ui.tvshows.panels.TvShowTreePanel;
import org.tinymediamanager.ui.tvshows.panels.episode.TvShowEpisodeCastPanel;
import org.tinymediamanager.ui.tvshows.panels.episode.TvShowEpisodeInformationPanel;
import org.tinymediamanager.ui.tvshows.panels.episode.TvShowEpisodeMediaInformationPanel;
import org.tinymediamanager.ui.tvshows.panels.season.TvShowSeasonInformationPanel;
import org.tinymediamanager.ui.tvshows.panels.season.TvShowSeasonMediaFilesPanel;
import org.tinymediamanager.ui.tvshows.panels.tvshow.TvShowArtworkPanel;
import org.tinymediamanager.ui.tvshows.panels.tvshow.TvShowCastPanel;
import org.tinymediamanager.ui.tvshows.panels.tvshow.TvShowInformationPanel;
import org.tinymediamanager.ui.tvshows.panels.tvshow.TvShowMediaInformationPanel;
import org.tinymediamanager.ui.tvshows.panels.tvshow.TvShowTrailerPanel;
import org.tinymediamanager.ui.tvshows.settings.TvShowSettingsNode;

public class TvShowUIModule
extends AbstractTmmUIModule {
    private static final String ID = "tvShows";
    private static TvShowUIModule instance = null;
    final TvShowSelectionModel tvShowSelectionModel = new TvShowSelectionModel();
    final TvShowSeasonSelectionModel tvShowSeasonSelectionModel = new TvShowSeasonSelectionModel();
    final TvShowEpisodeSelectionModel tvShowEpisodeSelectionModel = new TvShowEpisodeSelectionModel();
    private final TvShowTreePanel listPanel = new TvShowTreePanel(this.tvShowSelectionModel);
    private final JPanel detailPanel = new JPanel();
    private final JPanel dataPanel;
    private final TvShowFilterDialog tvShowFilterDialog;
    private final TmmSettingsNode settingsNode;

    private TvShowUIModule() {
        this.detailPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[grow]", "[grow]"));
        this.dataPanel = new JPanel();
        this.dataPanel.setLayout(new CardLayout());
        this.detailPanel.add((Component)this.dataPanel, "cell 0 0, grow");
        MainTabbedPane tvShowDetailPanel = new MainTabbedPane(){

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                this.putClientProperty("roundEdge", Boolean.FALSE);
                super.updateUI();
            }
        };
        tvShowDetailPanel.add(TmmResourceBundle.getString("metatag.details"), new TvShowInformationPanel(this.tvShowSelectionModel));
        tvShowDetailPanel.add(TmmResourceBundle.getString("metatag.cast"), new TvShowCastPanel(this.tvShowSelectionModel));
        tvShowDetailPanel.add(TmmResourceBundle.getString("metatag.mediafiles"), new TvShowMediaInformationPanel(this.tvShowSelectionModel));
        tvShowDetailPanel.add(TmmResourceBundle.getString("metatag.artwork"), new TvShowArtworkPanel(this.tvShowSelectionModel));
        tvShowDetailPanel.add(TmmResourceBundle.getString("metatag.trailer"), new TvShowTrailerPanel(this.tvShowSelectionModel));
        this.dataPanel.add((Component)tvShowDetailPanel, "tvShow");
        MainTabbedPane tvShowSeasonDetailPanel = new MainTabbedPane(){

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        tvShowSeasonDetailPanel.add(TmmResourceBundle.getString("metatag.details"), new TvShowSeasonInformationPanel(this.tvShowSeasonSelectionModel));
        tvShowSeasonDetailPanel.add(TmmResourceBundle.getString("metatag.mediafiles"), new TvShowSeasonMediaFilesPanel(this.tvShowSeasonSelectionModel));
        this.dataPanel.add((Component)tvShowSeasonDetailPanel, "tvShowSeason");
        MainTabbedPane tvShowEpisodeDetailPanel = new MainTabbedPane(){

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        tvShowEpisodeDetailPanel.add(TmmResourceBundle.getString("metatag.details"), new TvShowEpisodeInformationPanel(this.tvShowEpisodeSelectionModel));
        tvShowEpisodeDetailPanel.add(TmmResourceBundle.getString("metatag.cast"), new TvShowEpisodeCastPanel(this.tvShowEpisodeSelectionModel));
        tvShowEpisodeDetailPanel.add(TmmResourceBundle.getString("metatag.mediafiles"), new TvShowEpisodeMediaInformationPanel(this.tvShowEpisodeSelectionModel));
        this.dataPanel.add((Component)tvShowEpisodeDetailPanel, "tvShowEpisode");
        this.tvShowFilterDialog = new TvShowFilterDialog(this.listPanel.getTreeTable());
        this.createActions();
        this.createMenus();
        this.createPopupMenu();
        this.registerAccelerators();
        this.settingsNode = new TvShowSettingsNode();
        this.init();
    }

    private void init() {
        if (TvShowModuleManager.getInstance().getSettings().isStoreUiFilters()) {
            SwingUtilities.invokeLater(() -> {
                TvShowModuleManager.getInstance().getTvShowList().searchDuplicateEpisodes();
                this.listPanel.getTreeTable().setFilterValues(TvShowModuleManager.getInstance().getSettings().getUiFilters());
            });
        }
    }

    public static TvShowUIModule getInstance() {
        if (instance == null) {
            instance = new TvShowUIModule();
        }
        return instance;
    }

    public void setFilterDialogVisible(boolean selected) {
        this.tvShowFilterDialog.setVisible(selected);
    }

    @Override
    public String getModuleId() {
        return ID;
    }

    @Override
    public JPanel getTabPanel() {
        return this.listPanel;
    }

    @Override
    public String getTabTitle() {
        return TmmResourceBundle.getString("tmm.tvshows");
    }

    @Override
    public ImageIcon getMenuIcon() {
        return IconManager.MENU_TV_SHOWS;
    }

    @Override
    public ImageIcon getMenuActiveIcon() {
        return IconManager.MENU_TV_SHOWS_ACTIVE;
    }

    @Override
    public JPanel getDetailPanel() {
        return this.detailPanel;
    }

    public TvShowSelectionModel getSelectionModel() {
        return this.tvShowSelectionModel;
    }

    @Override
    public TmmSettingsNode getSettingsNode() {
        return this.settingsNode;
    }

    private void createActions() {
        this.searchAction = this.createAndRegisterAction(TvShowSingleScrapeAction.class);
        this.editAction = this.createAndRegisterAction(TvShowEditAction.class);
        this.updateAction = this.createAndRegisterAction(TvShowUpdateDatasourcesAction.class);
        this.renameAction = this.createAndRegisterAction(TvShowRenameAction.class);
    }

    private void createMenus() {
        this.updatePopupMenu = new JPopupMenu(TmmResourceBundle.getString("Toolbar.update"));
        this.updatePopupMenu.setToolTipText(TmmResourceBundle.getString("Toolbar.update"));
        this.updatePopupMenu.add(this.createAndRegisterAction(TvShowUpdateDatasourcesAction.class));
        final JMenu datasourcesMenu = new JMenu(TmmResourceBundle.getString("metatag.datasource"));
        datasourcesMenu.setIcon(IconManager.MENU);
        MenuScroller.setScrollerFor(datasourcesMenu, 20, 50, 0, 0);
        datasourcesMenu.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                datasourcesMenu.removeAll();
                for (String ds : TvShowModuleManager.getInstance().getSettings().getTvShowDataSource()) {
                    datasourcesMenu.add(new TvShowUpdateSingleDatasourceAction(ds));
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.updatePopupMenu.add(datasourcesMenu);
        this.updatePopupMenu.addSeparator();
        this.updatePopupMenu.add(new TvShowUpdateAction());
        this.updatePopupMenu.addSeparator();
        this.updatePopupMenu.add(this.createAndRegisterAction(TvShowAddDatasourceAction.class));
        this.searchPopupMenu = new JPopupMenu(TmmResourceBundle.getString("Toolbar.search"));
        this.searchPopupMenu.setToolTipText(TmmResourceBundle.getString("Toolbar.search"));
        this.searchPopupMenu.add(this.createAndRegisterAction(TvShowSingleScrapeAction.class));
        this.searchPopupMenu.add(this.createAndRegisterAction(TvShowSelectedScrapeAction.class));
        this.searchPopupMenu.add(this.createAndRegisterAction(TvShowSelectedScrapeMetadataAction.class));
        this.searchPopupMenu.add(this.createAndRegisterAction(TvShowScrapeEpisodesAction.class));
        this.searchPopupMenu.add(this.createAndRegisterAction(TvShowScrapeNewItemsAction.class));
        this.searchPopupMenu.add(this.createAndRegisterAction(TvShowScrapeMissingEpisodesAction.class));
        this.searchPopupMenu.add(this.createAndRegisterAction(TvShowMissingEpisodeListAction.class));
        this.editPopupMenu = new JPopupMenu(TmmResourceBundle.getString("Toolbar.edit"));
        this.editPopupMenu.setToolTipText(TmmResourceBundle.getString("Toolbar.edit"));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowEditAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowBulkEditAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowLockAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowUnlockAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowFetchRatingsAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowFetchImdbTop250.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowChangeDatasourceAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowChangeSeasonArtworkAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowToggleWatchedFlagAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowRewriteNfoAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowReadNfoAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowRewriteSeasonNfoAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowRewriteEpisodeNfoAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowReadEpisodeNfoAction.class));
        this.editPopupMenu.addSeparator();
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowMediaInformationAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowRebuildMediainfoXmlAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowAspectRatioDetectAction.class));
        this.editPopupMenu.addSeparator();
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowRebuildImageCacheAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowResetNewFlagAction.class));
        this.editPopupMenu.addSeparator();
        JMenu traktMenu = new JMenu("Trakt.tv");
        traktMenu.setIcon(IconManager.MENU);
        traktMenu.add(this.createAndRegisterAction(TvShowSyncTraktTvAction.class));
        traktMenu.addSeparator();
        traktMenu.add(this.createAndRegisterAction(TvShowSyncSelectedTraktTvAction.class));
        traktMenu.add(this.createAndRegisterAction(TvShowSyncSelectedCollectionTraktTvAction.class));
        traktMenu.add(this.createAndRegisterAction(TvShowSyncSelectedWatchedTraktTvAction.class));
        traktMenu.add(this.createAndRegisterAction(TvShowSyncSelectedRatingTraktTvAction.class));
        traktMenu.addSeparator();
        traktMenu.add(this.createAndRegisterAction(TvShowTraktTvRemoveFromCollectionAction.class));
        traktMenu.add(this.createAndRegisterAction(TvShowTraktTvRemoveFromWatchedAction.class));
        this.editPopupMenu.add(traktMenu);
        this.editPopupMenu.addSeparator();
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowExportAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(TvShowCopyToAction.class));
        this.renamePopupMenu = new JPopupMenu(TmmResourceBundle.getString("Toolbar.rename"));
        this.renamePopupMenu.setToolTipText(TmmResourceBundle.getString("Toolbar.rename"));
        this.renamePopupMenu.add(this.createAndRegisterAction(TvShowRenameAction.class));
        this.renamePopupMenu.add(this.createAndRegisterAction(TvShowRenamePreviewAction.class));
        this.renamePopupMenu.addSeparator();
        this.renamePopupMenu.add(this.createAndRegisterAction(TvShowUndoRenameAction.class));
        this.renamePopupMenu.addSeparator();
        this.renamePopupMenu.add(this.createAndRegisterAction(TvShowCleanUpFilesAction.class));
        this.renamePopupMenu.add(this.createAndRegisterAction(TvShowClearImageCacheAction.class));
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.createAndRegisterAction(TvShowSingleScrapeAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowSelectedScrapeAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowSelectedScrapeMetadataAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowScrapeEpisodesAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowScrapeNewItemsAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowScrapeMissingEpisodesAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowMissingEpisodeListAction.class));
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(TvShowUpdateAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowReadNfoAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowReadEpisodeNfoAction.class));
        JMenu updateDatasourcesMenu = new JMenu(TmmResourceBundle.getString("Toolbar.update"));
        updateDatasourcesMenu.setIcon(IconManager.MENU);
        updateDatasourcesMenu.add(this.createAndRegisterAction(TvShowUpdateDatasourcesAction.class));
        final JMenu datasourcesMenu = new JMenu(TmmResourceBundle.getString("metatag.datasource"));
        datasourcesMenu.setIcon(IconManager.MENU);
        MenuScroller.setScrollerFor(datasourcesMenu, 20, 50, 2, 5);
        datasourcesMenu.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                datasourcesMenu.removeAll();
                for (String ds : TvShowModuleManager.getInstance().getSettings().getTvShowDataSource()) {
                    datasourcesMenu.add(new TvShowUpdateSingleDatasourceAction(ds));
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        updateDatasourcesMenu.add(datasourcesMenu);
        updateDatasourcesMenu.addSeparator();
        updateDatasourcesMenu.add(this.createAndRegisterAction(TvShowAddDatasourceAction.class));
        this.popupMenu.add(updateDatasourcesMenu);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(TvShowEditAction.class));
        JMenu enhancededitPopupMenu = new JMenu(TmmResourceBundle.getString("edit.enhanced"));
        enhancededitPopupMenu.setIcon(IconManager.MENU);
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowBulkEditAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowLockAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowUnlockAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowToggleWatchedFlagAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowFetchRatingsAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowFetchImdbTop250.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowChangeDatasourceAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowChangeSeasonArtworkAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowRewriteNfoAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowRewriteSeasonNfoAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowRewriteEpisodeNfoAction.class));
        enhancededitPopupMenu.addSeparator();
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowMediaInformationAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowRebuildMediainfoXmlAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowAspectRatioDetectAction.class));
        enhancededitPopupMenu.addSeparator();
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowRebuildImageCacheAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowResetNewFlagAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowTitleToEntityMatcher.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvShowChangeToAbsoluteAction.class));
        enhancededitPopupMenu.add(this.createAndRegisterAction(TvshowChecksumsAction.class));
        this.popupMenu.add(enhancededitPopupMenu);
        JMenu downloadMenu = new JMenu(TmmResourceBundle.getString("tmm.download"));
        downloadMenu.setIcon(IconManager.MENU);
        downloadMenu.add(this.createAndRegisterAction(TvShowDownloadMissingArtworkAction.class));
        downloadMenu.add(this.createAndRegisterAction(TvShowDownloadActorImagesAction.class));
        downloadMenu.add(this.createAndRegisterAction(TvShowTrailerDownloadAction.class));
        downloadMenu.add(this.createAndRegisterAction(TvShowSubtitleSearchAction.class));
        downloadMenu.add(this.createAndRegisterAction(TvShowSubtitleDownloadAction.class));
        downloadMenu.add(this.createAndRegisterAction(TvShowDownloadThemeAction.class));
        this.popupMenu.add(downloadMenu);
        JMenu renamePopupMenu = new JMenu(TmmResourceBundle.getString("Toolbar.rename"));
        renamePopupMenu.setIcon(IconManager.MENU);
        renamePopupMenu.add(this.createAndRegisterAction(TvShowRenameAction.class));
        renamePopupMenu.add(this.createAndRegisterAction(TvShowRenamePreviewAction.class));
        renamePopupMenu.addSeparator();
        renamePopupMenu.add(this.createAndRegisterAction(TvShowUndoRenameAction.class));
        renamePopupMenu.addSeparator();
        renamePopupMenu.add(this.createAndRegisterAction(TvShowCleanUpFilesAction.class));
        renamePopupMenu.add(this.createAndRegisterAction(TvShowClearImageCacheAction.class));
        this.popupMenu.add(renamePopupMenu);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(TvShowExportAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowCopyToAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowOpenFolderAction.class));
        this.popupMenu.addSeparator();
        final JMenu traktMenu = new JMenu("Trakt.tv");
        traktMenu.setIcon(IconManager.MENU);
        traktMenu.add(this.createAndRegisterAction(TvShowSyncSelectedTraktTvAction.class));
        traktMenu.add(this.createAndRegisterAction(TvShowSyncSelectedCollectionTraktTvAction.class));
        traktMenu.add(this.createAndRegisterAction(TvShowSyncSelectedWatchedTraktTvAction.class));
        traktMenu.add(this.createAndRegisterAction(TvShowSyncSelectedRatingTraktTvAction.class));
        traktMenu.addSeparator();
        traktMenu.add(this.createAndRegisterAction(TvShowTraktTvRemoveFromCollectionAction.class));
        traktMenu.add(this.createAndRegisterAction(TvShowTraktTvRemoveFromWatchedAction.class));
        this.popupMenu.add(traktMenu);
        final JMenu kodiRPCMenu = KodiRPCMenu.createMenuKodiMenuRightClickTvShows();
        this.popupMenu.add(kodiRPCMenu);
        final JMenu postProcessingMenu = new JMenu(TmmResourceBundle.getString("Settings.postprocessing"));
        postProcessingMenu.setIcon(IconManager.MENU);
        this.popupMenu.add(postProcessingMenu);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(TvShowRemoveAction.class));
        this.popupMenu.add(this.createAndRegisterAction(TvShowDeleteAction.class));
        if (Globals.isDebug()) {
            JMenu debugMenu = new JMenu("Debug");
            debugMenu.add(new DebugDumpShowAction());
            debugMenu.add(new DebugDumpShowActionWithChilds());
            this.popupMenu.addSeparator();
            this.popupMenu.add(debugMenu);
        }
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (StringUtils.isNotBlank((CharSequence)Settings.getInstance().getKodiHost())) {
                    kodiRPCMenu.setText(KodiRPC.getInstance().getVersion());
                    kodiRPCMenu.setEnabled(true);
                } else {
                    kodiRPCMenu.setText("Kodi");
                    kodiRPCMenu.setEnabled(false);
                }
                if (License.getInstance().isValidLicense() && StringUtils.isNotBlank((CharSequence)Settings.getInstance().getTraktAccessToken())) {
                    traktMenu.setEnabled(true);
                } else {
                    traktMenu.setEnabled(false);
                }
                postProcessingMenu.removeAll();
                if (TvShowModuleManager.getInstance().getSettings().getPostProcessTvShow().isEmpty() && TvShowModuleManager.getInstance().getSettings().getPostProcessEpisode().isEmpty()) {
                    postProcessingMenu.setEnabled(false);
                } else {
                    JMenuItem menuItem;
                    for (PostProcess process : new ArrayList<PostProcess>(TvShowModuleManager.getInstance().getSettings().getPostProcessTvShow())) {
                        menuItem = new JMenuItem(TmmResourceBundle.getString("metatag.tvshow") + " - " + process.getName(), IconManager.APPLY_INV);
                        menuItem.addActionListener(pp -> new TvShowPostProcessExecutor(process).execute());
                        postProcessingMenu.add(menuItem);
                    }
                    if (postProcessingMenu.getItemCount() != 0) {
                        postProcessingMenu.addSeparator();
                    }
                    for (PostProcess process : new ArrayList<PostProcess>(TvShowModuleManager.getInstance().getSettings().getPostProcessEpisode())) {
                        menuItem = new JMenuItem(TmmResourceBundle.getString("metatag.episode") + " - " + process.getName(), IconManager.APPLY_INV);
                        menuItem.addActionListener(pp -> new TvShowEpisodePostProcessExecutor(process).execute());
                        postProcessingMenu.add(menuItem);
                    }
                    postProcessingMenu.setEnabled(true);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.listPanel.setPopupMenu(this.popupMenu);
    }

    public void setSelectedTvShow(TvShow tvShow) {
        this.tvShowSelectionModel.setSelectedTvShow(tvShow);
        CardLayout cl = (CardLayout)this.dataPanel.getLayout();
        cl.show(this.dataPanel, "tvShow");
    }

    public void setSelectedTvShowSeason(TvShowSeason tvShowSeason) {
        this.tvShowSeasonSelectionModel.setSelectedTvShowSeason(tvShowSeason);
        CardLayout cl = (CardLayout)this.dataPanel.getLayout();
        cl.show(this.dataPanel, "tvShowSeason");
    }

    public void setSelectedTvShowEpisode(TvShowEpisode tvShowEpisode) {
        this.tvShowEpisodeSelectionModel.setSelectedTvShowEpisode(tvShowEpisode);
        CardLayout cl = (CardLayout)this.dataPanel.getLayout();
        cl.show(this.dataPanel, "tvShowEpisode");
    }
}

