/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowUndoRenameAction
extends TmmAction {
    public TvShowUndoRenameAction() {
        this.putValue("SmallIcon", IconManager.UNDO);
        this.putValue("Name", TmmResourceBundle.getString("tvshow.rename.undo"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.rename.undo.desc"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isLockedFound()) {
            TvShowSelectionModel.showLockedInformation();
        }
        if (selectedObjects.isEmpty()) {
            return;
        }
        for (TvShow tvShow : selectedObjects.getTvShows()) {
            TvShowRenamer.undoRename(tvShow);
        }
        for (TvShowEpisode episode : selectedObjects.getEpisodesRecursive()) {
            TvShowRenamer.undoRename(episode);
        }
    }
}

