/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model;

import org.fourthline.cling.model.types.ServiceId;
import org.fourthline.cling.model.types.UDN;

public class ServiceReference {
    public static final String DELIMITER = "/";
    private final UDN udn;
    private final ServiceId serviceId;

    public ServiceReference(String s) {
        String[] split = s.split(DELIMITER);
        if (split.length == 2) {
            this.udn = UDN.valueOf(split[0]);
            this.serviceId = ServiceId.valueOf(split[1]);
        } else {
            this.udn = null;
            this.serviceId = null;
        }
    }

    public ServiceReference(UDN udn, ServiceId serviceId) {
        this.udn = udn;
        this.serviceId = serviceId;
    }

    public UDN getUdn() {
        return this.udn;
    }

    public ServiceId getServiceId() {
        return this.serviceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceReference that = (ServiceReference)o;
        if (!this.serviceId.equals(that.serviceId)) {
            return false;
        }
        return this.udn.equals(that.udn);
    }

    public int hashCode() {
        int result = this.udn.hashCode();
        result = 31 * result + this.serviceId.hashCode();
        return result;
    }

    public String toString() {
        return this.udn == null || this.serviceId == null ? "" : this.udn.toString() + DELIMITER + this.serviceId.toString();
    }
}

