/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf;

import com.github.stephenc.javaisotools.loopfs.api.FileEntry;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileSystem;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.ExtendedFileEntryDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.FileEntryDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.FileIdentifierDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DescriptorTag;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtentAD;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class UDFFileEntry
implements FileEntry {
    private UDFFileSystem fs;
    private FileEntryDescriptor icb;
    private String parentPath;
    private String entryName;
    private Boolean isRoot;

    public UDFFileEntry(UDFFileSystem uDFFileSystem, FileEntryDescriptor fileEntryDescriptor, String string, String string2) {
        this(uDFFileSystem, fileEntryDescriptor, string, string2, false);
    }

    public UDFFileEntry(UDFFileSystem uDFFileSystem, FileEntryDescriptor fileEntryDescriptor, String string, String string2, Boolean bl) {
        this.fs = uDFFileSystem;
        this.parentPath = string;
        this.icb = fileEntryDescriptor;
        this.entryName = string2;
        this.isRoot = bl;
    }

    public String getName() {
        if (this.isRoot.booleanValue()) {
            return "/";
        }
        return this.entryName;
    }

    public String getPath() {
        if (this.isRoot.booleanValue()) {
            return "/";
        }
        Path path = Paths.get(this.parentPath, new String[0]).resolve(this.entryName);
        return path.toString();
    }

    public long getLastModifiedTime() {
        return 0L;
    }

    public boolean isLink() {
        return this.icb.icbTag.fileType == 12;
    }

    public boolean isSymlink() {
        return false;
    }

    public boolean isDirectory() {
        return this.icb.icbTag.fileType == 4;
    }

    public long getSize() {
        return this.icb.infoLength.longValue();
    }

    public List<ExtentAD> getADs() {
        return this.icb.allocDescriptors;
    }

    public void loadFiles() throws IOException {
        if (this.isDirectory()) {
            this.icb.loadChildren(this.fs);
        }
    }

    public List<UDFFileEntry> getFiles() throws IOException {
        if (!this.isDirectory()) {
            return new ArrayList<UDFFileEntry>();
        }
        String string = this.getPath();
        ArrayList<UDFFileEntry> arrayList = new ArrayList<UDFFileEntry>();
        for (FileIdentifierDescriptor fileIdentifierDescriptor : this.icb.fids) {
            FileEntryDescriptor fileEntryDescriptor;
            Object object;
            Long l = fileIdentifierDescriptor.icb.location.blockNumber;
            Long l2 = l + this.fs.getFSDloc();
            byte[] byArray = new byte[2048];
            this.fs.readBlock(l2, byArray);
            try {
                object = new DescriptorTag(byArray);
                fileEntryDescriptor = ((DescriptorTag)object).identifier == 266 ? new ExtendedFileEntryDescriptor(byArray) : new FileEntryDescriptor(byArray);
            }
            catch (InvalidDescriptor invalidDescriptor) {
                throw new IOException("Invalid descriptor found at sector " + l2.toString());
            }
            object = fileIdentifierDescriptor.fileId.toString();
            if (((String)object).equals("")) continue;
            UDFFileEntry uDFFileEntry = new UDFFileEntry(this.fs, fileEntryDescriptor, string, (String)object);
            arrayList.add(uDFFileEntry);
        }
        return arrayList;
    }
}

