/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.util;

import com.hdcookbook.grin.util.AssetFinder;
import com.hdcookbook.grin.util.Debug;
import com.hdcookbook.grin.util.ManagedFullImage;
import com.hdcookbook.grin.util.ManagedImage;
import com.hdcookbook.grin.util.ManagedSubImage;
import com.hdcookbook.grin.util.MosaicTile;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;

public class ImageManager {
    private static Hashtable images = new Hashtable();
    private static Hashtable imageMap = null;
    private static Object lock = new Object();

    private ImageManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManagedImage getImage(String string) {
        Object object = lock;
        synchronized (object) {
            ManagedImage managedImage = (ManagedImage)images.get(string);
            if (managedImage == null) {
                if (imageMap != null) {
                    MosaicTile mosaicTile = (MosaicTile)imageMap.get(string);
                    if (mosaicTile != null) {
                        managedImage = new ManagedSubImage(string, mosaicTile.mosaicName, mosaicTile.placement);
                    } else {
                        Debug.println(string + " not found in image map.");
                    }
                }
                if (managedImage == null) {
                    managedImage = new ManagedFullImage(string);
                }
                images.put(string, managedImage);
            }
            managedImage.addReference();
            return managedImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ManagedImage getImage(URL uRL) {
        String string = uRL.toExternalForm();
        Object object = lock;
        synchronized (object) {
            ManagedImage managedImage = (ManagedImage)images.get(string);
            if (managedImage == null) {
                managedImage = new ManagedFullImage(string, uRL);
                images.put(string, managedImage);
            }
            managedImage.addReference();
            return managedImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getImage(ManagedImage managedImage) {
        Object object = lock;
        synchronized (object) {
            if (!managedImage.isReferenced()) {
                throw new IllegalStateException();
            }
            managedImage.addReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ungetImage(ManagedImage managedImage) {
        Object object = lock;
        synchronized (object) {
            managedImage.removeReference();
            if (!managedImage.isReferenced()) {
                images.remove(managedImage.getName());
                managedImage.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readImageMap(String string, Hashtable hashtable) throws IOException {
        FilterInputStream filterInputStream = null;
        try {
            int n;
            URL uRL = AssetFinder.getURL(string);
            if (uRL == null) {
                throw new IOException("No image map " + string);
            }
            filterInputStream = new DataInputStream(new BufferedInputStream(uRL.openStream()));
            int n2 = ((DataInputStream)filterInputStream).readInt();
            String[] stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = ((DataInputStream)filterInputStream).readUTF();
            }
            n2 = ((DataInputStream)filterInputStream).readInt();
            for (n = 0; n < n2; ++n) {
                String string2 = ((DataInputStream)filterInputStream).readUTF();
                MosaicTile mosaicTile = new MosaicTile();
                mosaicTile.mosaicName = stringArray[((DataInputStream)filterInputStream).readInt()];
                mosaicTile.placement = new Rectangle();
                mosaicTile.placement.x = ((DataInputStream)filterInputStream).readInt();
                mosaicTile.placement.y = ((DataInputStream)filterInputStream).readInt();
                mosaicTile.placement.width = ((DataInputStream)filterInputStream).readInt();
                mosaicTile.placement.height = ((DataInputStream)filterInputStream).readInt();
                hashtable.put(string2, mosaicTile);
            }
            if (filterInputStream.read() != -1) {
                Debug.assertFail();
            }
        }
        catch (IOException iOException) {
            Debug.printStackTrace(iOException);
            Debug.assertFail();
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setImageMap(Hashtable hashtable) {
        Object object = lock;
        synchronized (object) {
            imageMap = hashtable;
        }
    }
}

