/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thetvdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.thetvdb.TheTvDbArtworkProvider;
import org.tinymediamanager.scraper.thetvdb.TheTvDbTvShowMetadataProvider;
import org.tinymediamanager.scraper.thetvdb.entities.ArtworkBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.SeasonBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.SeriesExtendedResponse;
import org.tinymediamanager.scraper.util.ListUtils;
import retrofit2.Response;

public class TheTvDbTvShowArtworkProvider
extends TheTvDbArtworkProvider
implements ITvShowArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TheTvDbTvShowArtworkProvider.class);

    @Override
    protected String getSubId() {
        return "tvshow_artwork";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected List<ArtworkBaseRecord> fetchArtwork(int id) throws ScrapeException {
        ArrayList<ArtworkBaseRecord> images;
        block8: {
            images = new ArrayList<ArtworkBaseRecord>();
            try {
                Response response = this.tvdb.getSeriesService().getSeriesExtended(id).execute();
                if (!response.isSuccessful()) {
                    if (response.code() == 404) {
                        throw new NothingFoundException();
                    }
                    throw new HttpException(response.code(), response.message());
                }
                if (response.body() == null || ((SeriesExtendedResponse)response.body()).data == null) break block8;
                for (ArtworkBaseRecord image : ListUtils.nullSafe(((SeriesExtendedResponse)response.body()).data.artworks)) {
                    if (image.season != null) {
                        try {
                            SeasonBaseRecord season = ((SeriesExtendedResponse)response.body()).data.seasons.stream().filter(seasonBaseRecord -> seasonBaseRecord.id.equals(image.season)).findFirst().orElse(null);
                            image.season = season != null ? season.number : null;
                        }
                        catch (Exception e) {
                            image.season = null;
                        }
                    }
                    images.add(image);
                }
            }
            catch (Exception e) {
                LOGGER.debug("failed to get artwork: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        return images;
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        this.initAPI();
        if (options.getMediaType() == MediaType.TV_EPISODE) {
            LOGGER.debug("getting artwork: {}", (Object)options);
            try {
                TvShowEpisodeSearchAndScrapeOptions episodeSearchAndScrapeOptions = new TvShowEpisodeSearchAndScrapeOptions();
                episodeSearchAndScrapeOptions.setDataFromOtherOptions(options);
                if (options.getIds().get("tvShowIds") instanceof Map) {
                    Map tvShowIds = (Map)options.getIds().get("tvShowIds");
                    episodeSearchAndScrapeOptions.setTvShowIds(tvShowIds);
                }
                MediaMetadata md = new TheTvDbTvShowMetadataProvider().getMetadata(episodeSearchAndScrapeOptions);
                return md.getMediaArt();
            }
            catch (MissingIdException | NothingFoundException e) {
                return Collections.emptyList();
            }
            catch (ScrapeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ScrapeException(e);
            }
        }
        return super.getArtwork(options);
    }
}

