/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieSubtitleSearchAndDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieDownloadSubtitleDialog;

public class MovieSubtitleDownloadAction
extends TmmAction {
    public MovieSubtitleDownloadAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.download.subtitle"));
        this.putValue("SmallIcon", IconManager.SUBTITLE);
        this.putValue("SwingLargeIconKey", IconManager.SUBTITLE);
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.download.subtitle"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() + 512));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        MovieDownloadSubtitleDialog dialog = new MovieDownloadSubtitleDialog(TmmResourceBundle.getString("movie.download.subtitle"));
        dialog.setLocationRelativeTo(MainWindow.getInstance());
        dialog.setVisible(true);
        if (dialog.shouldStartDownload()) {
            for (MediaLanguages language : dialog.getLanguages()) {
                MovieSubtitleSearchAndDownloadTask task = new MovieSubtitleSearchAndDownloadTask(selectedMovies, dialog.getSubtitleScrapers(), language);
                task.setForceBestMatch(dialog.isForceBestMatch());
                TmmTaskManager.getInstance().addMainTask(task);
            }
        }
    }
}

