/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.ui.panels.AbstractModalInputPanel;

public class TrailerEditorPanel
extends AbstractModalInputPanel {
    private final MediaTrailer mediaTrailer;
    private final JTextField tfName;
    private final JTextField tfSource;
    private final JTextField tfQuality;
    private final JTextField tfUrl;
    private final JTextField tfId;

    public TrailerEditorPanel(MediaTrailer mediaTrailer) {
        this.mediaTrailer = mediaTrailer;
        this.setLayout((LayoutManager)new MigLayout("", "[][800lp,grow]", "[][][][]"));
        JLabel nameT = new JLabel(TmmResourceBundle.getString("metatag.name"));
        this.add((Component)nameT, "cell 0 0,alignx trailing");
        this.tfName = new JTextField();
        this.add((Component)this.tfName, "cell 1 0,growx,wmin 0");
        JLabel sourceT = new JLabel(TmmResourceBundle.getString("metatag.source"));
        this.add((Component)sourceT, "cell 0 1,alignx trailing");
        this.tfSource = new JTextField();
        this.add((Component)this.tfSource, "cell 1 1,growx");
        JLabel lblQualityT = new JLabel(TmmResourceBundle.getString("metatag.quality"));
        this.add((Component)lblQualityT, "cell 0 2,alignx trailing");
        this.tfQuality = new JTextField();
        this.tfQuality.setColumns(10);
        this.add((Component)this.tfQuality, "cell 1 2");
        JLabel lblUrlT = new JLabel(TmmResourceBundle.getString("metatag.url"));
        this.add((Component)lblUrlT, "cell 0 3");
        this.tfUrl = new JTextField();
        this.tfUrl.setColumns(10);
        this.add((Component)this.tfUrl, "cell 1 3,growx,wmin 0");
        JLabel lblIdT = new JLabel(TmmResourceBundle.getString("metatag.id"));
        this.add((Component)lblIdT, "cell 0 4");
        this.tfId = new JTextField();
        this.tfId.setColumns(10);
        this.add((Component)this.tfId, "cell 1 4,growx,wmin 0");
        this.tfName.setText(mediaTrailer.getName());
        this.tfSource.setText(mediaTrailer.getProvider());
        this.tfQuality.setText(mediaTrailer.getQuality());
        this.tfUrl.setText(mediaTrailer.getUrl());
        this.tfId.setText(mediaTrailer.getId());
        SwingUtilities.invokeLater(this.tfName::requestFocus);
    }

    @Override
    protected void onClose() {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.tfId.getText(), this.tfUrl.getText()})) {
            JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("message.missingitems"));
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.tfName.getText())) {
            JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("message.missingitems"));
            return;
        }
        this.mediaTrailer.setName(this.tfName.getText());
        this.mediaTrailer.setProvider(this.tfSource.getText());
        this.mediaTrailer.setQuality(this.tfQuality.getText());
        this.mediaTrailer.setUrl(this.tfUrl.getText());
        this.mediaTrailer.setId(this.tfId.getText());
        this.mediaTrailer.setDate(new Date());
        this.setVisible(false);
    }
}

