/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.tinymediamanager.ui.components.button.SplitButton;
import org.tinymediamanager.ui.plaf.TmmPanelUI;

public class TmmSplitButtonUI
extends TmmPanelUI {
    protected boolean isIntelliJTheme;
    protected int minimumWidth;
    protected Color buttonBackground;
    protected Color borderColor;
    private SplitButton splitButton;
    private FocusListener focusListener;

    public static ComponentUI createUI(JComponent c) {
        return FlatUIUtils.canUseSharedUI((JComponent)c) ? FlatUIUtils.createSharedUI(TmmSplitButtonUI.class, () -> new TmmSplitButtonUI(true)) : new TmmSplitButtonUI(false);
    }

    protected TmmSplitButtonUI(boolean shared) {
        super(shared);
    }

    protected String getPropertyPrefix() {
        return "SplitButton";
    }

    public void installUI(JComponent c) {
        Insets insets;
        this.splitButton = (SplitButton)c;
        super.installUI((JComponent)this.splitButton);
        this.installDefaults(this.splitButton);
        if (this.splitButton.getActionButton() != null) {
            insets = this.splitButton.getActionButton().getInsets();
            this.splitButton.getActionButton().setBorder(BorderFactory.createEmptyBorder(insets.top - 1, insets.left, insets.bottom / 2 + 1, insets.right));
            this.splitButton.getActionButton().setContentAreaFilled(false);
            this.splitButton.getActionButton().setOpaque(false);
            this.splitButton.getActionButton().setBorderPainted(false);
        }
        if (this.splitButton.getMenuButton() != null) {
            insets = this.splitButton.getMenuButton().getInsets();
            this.splitButton.getMenuButton().setBorder(BorderFactory.createEmptyBorder(insets.top - 1, insets.left + 3, insets.bottom / 2 + 1, insets.right + 2));
            this.splitButton.getMenuButton().setContentAreaFilled(false);
            this.splitButton.getMenuButton().setOpaque(false);
            this.splitButton.getMenuButton().setBorderPainted(false);
        }
    }

    protected void installDefaults(JPanel p) {
        Border b;
        super.installDefaults(p);
        String prefix = this.getPropertyPrefix();
        this.buttonBackground = UIManager.getColor(prefix + ".buttonBackground");
        this.minimumWidth = UIManager.getInt("Component.minimumWidth");
        this.borderColor = UIManager.getColor("Component.borderColor");
        this.isIntelliJTheme = UIManager.getBoolean("Component.isIntelliJTheme");
        Color bg = p.getBackground();
        if (bg == null || bg instanceof UIResource) {
            p.setBackground(UIManager.getColor(prefix + ".background"));
        }
        if ((b = p.getBorder()) == null || b instanceof UIResource) {
            p.setBorder(UIManager.getBorder(prefix + ".border"));
        }
    }

    public void uninstallUI(JComponent c) {
        SplitButton p = (SplitButton)c;
        this.uninstallDefaults(p);
        super.uninstallUI(c);
        c.removeFocusListener(this.focusListener);
        this.focusListener = null;
    }

    public void paint(Graphics g, JComponent c) {
        this.paintBackground(g, c);
        super.paint(g, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintBackground(Graphics g, JComponent c) {
        if (c.isOpaque() || FlatUIUtils.getOutsideFlatBorder((JComponent)c) != null || !FlatUIUtils.hasOpaqueBeenExplicitlySet((JComponent)c)) {
            float focusWidth = FlatUIUtils.getBorderFocusWidth((JComponent)this.splitButton);
            float arc = FlatUIUtils.getBorderArc((JComponent)c);
            if (c.isOpaque() && (focusWidth > 0.0f || arc > 0.0f)) {
                FlatUIUtils.paintParentBackground((Graphics)g, (JComponent)c);
            }
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                int width = c.getWidth();
                int height = c.getHeight();
                FlatUIUtils.setRenderingHints((Graphics)g2);
                Color background = c.getBackground();
                g2.setColor(!(background instanceof UIResource) ? background : (this.isIntelliJTheme && (!c.isEnabled() || !c.isEnabled()) ? FlatUIUtils.getParentBackground((JComponent)c) : background));
                FlatUIUtils.paintComponentBackground((Graphics2D)g2, (int)0, (int)0, (int)width, (int)height, (float)focusWidth, (float)arc);
                int arrowX = width - this.splitButton.getMenuButton().getWidth() - (int)focusWidth;
                g2.setColor(this.buttonBackground);
                Shape oldClip = g2.getClip();
                g2.clipRect(arrowX, 0, width - arrowX, height);
                FlatUIUtils.paintComponentBackground((Graphics2D)g2, (int)0, (int)0, (int)width, (int)height, (float)focusWidth, (float)arc);
                g2.setClip(oldClip);
                g2.setColor(this.borderColor);
                float lw = UIScale.scale((float)1.0f);
                float lx = arrowX;
                g2.fill(new Rectangle2D.Float(lx, focusWidth, lw, (float)(height - 1) - focusWidth * 2.0f));
            }
            finally {
                g2.dispose();
            }
        }
    }
}

