/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.filenaming;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.tvshow.ITvShowSeasonFileNaming;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TvShowSeasonPosterNaming implements ITvShowSeasonFileNaming
{
    SEASON_POSTER{

        @Override
        public String getFilename(TvShowSeason tvShowSeason, String extension, boolean forRenamer) {
            Object filename = tvShowSeason.getSeason() == -1 ? "season-all-poster." + extension : (tvShowSeason.getSeason() == 0 && TvShowModuleManager.getInstance().getSettings().isSpecialSeason() ? "season-specials-poster." + extension : (tvShowSeason.getSeason() > -1 ? String.format("season%02d-poster.%s", tvShowSeason.getSeason(), extension) : ""));
            return filename;
        }
    }
    ,
    SEASON_FOLDER{

        @Override
        public String getFilename(TvShowSeason tvShowSeason, String extension, boolean forRenamer) {
            TvShow tvShow = tvShowSeason.getTvShow();
            if (tvShow == null) {
                return "";
            }
            String seasonFoldername = this.getSeasonFolder(tvShowSeason, forRenamer);
            if (StringUtils.isBlank((CharSequence)seasonFoldername)) {
                return SEASON_POSTER.getFilename(tvShowSeason, extension, forRenamer);
            }
            Object filename = String.format("season%02d-poster.%s", tvShowSeason.getSeason(), extension);
            if (tvShowSeason.getSeason() == 0 && TvShowModuleManager.getInstance().getSettings().isSpecialSeason()) {
                filename = "season-specials-poster." + extension;
            }
            return seasonFoldername + File.separator + (String)filename;
        }
    }
    ,
    SEASON_FOLDER2{

        @Override
        public String getFilename(TvShowSeason tvShowSeason, String extension, boolean forRenamer) {
            TvShow tvShow = tvShowSeason.getTvShow();
            if (tvShow == null) {
                return "";
            }
            String seasonFoldername = this.getSeasonFolder(tvShowSeason, forRenamer);
            if (StringUtils.isBlank((CharSequence)seasonFoldername)) {
                return SEASON_POSTER.getFilename(tvShowSeason, extension, forRenamer);
            }
            Object filename = String.format("season%02d.%s", tvShowSeason.getSeason(), extension);
            if (tvShowSeason.getSeason() == 0 && TvShowModuleManager.getInstance().getSettings().isSpecialSeason()) {
                filename = "season-specials." + extension;
            }
            return seasonFoldername + File.separator + (String)filename;
        }
    }
    ,
    FOLDER{

        @Override
        public String getFilename(TvShowSeason tvShowSeason, String extension, boolean forRenamer) {
            TvShow tvShow = tvShowSeason.getTvShow();
            if (tvShow == null) {
                return "";
            }
            String seasonFoldername = this.getSeasonFolder(tvShowSeason, forRenamer);
            if (StringUtils.isBlank((CharSequence)seasonFoldername)) {
                return SEASON_POSTER.getFilename(tvShowSeason, extension, forRenamer);
            }
            return seasonFoldername + File.separator + "folder." + extension;
        }
    }
    ,
    POSTER{

        @Override
        public String getFilename(TvShowSeason tvShowSeason, String extension, boolean forRenamer) {
            TvShow tvShow = tvShowSeason.getTvShow();
            if (tvShow == null) {
                return "";
            }
            String seasonFoldername = this.getSeasonFolder(tvShowSeason, forRenamer);
            if (StringUtils.isBlank((CharSequence)seasonFoldername)) {
                return SEASON_POSTER.getFilename(tvShowSeason, extension, forRenamer);
            }
            return seasonFoldername + File.separator + "poster." + extension;
        }
    }
    ,
    COVER{

        @Override
        public String getFilename(TvShowSeason tvShowSeason, String extension, boolean forRenamer) {
            TvShow tvShow = tvShowSeason.getTvShow();
            if (tvShow == null) {
                return "";
            }
            String seasonFoldername = this.getSeasonFolder(tvShowSeason, forRenamer);
            if (StringUtils.isBlank((CharSequence)seasonFoldername)) {
                return SEASON_POSTER.getFilename(tvShowSeason, extension, forRenamer);
            }
            return seasonFoldername + File.separator + "cover." + extension;
        }
    };

}

