/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieAudioCodecFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();

    public MovieAudioCodecFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallCodecArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallCodecArray();
        this.movieList.addPropertyChangeListener("audioCodec", propertyChangeListener);
    }

    @Override
    public String getId() {
        return "movieAudioCodec";
    }

    @Override
    public boolean accept(Movie movie) {
        List audioCodecs = this.checkComboBox.getSelectedItems();
        for (MediaFile mf : movie.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO)) {
            for (String audioCodec : mf.getAudioCodecList()) {
                if (!audioCodecs.contains(audioCodec)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.audiocodec"));
    }

    private void buildAndInstallCodecArray() {
        ArrayList<String> audioCodecs = new ArrayList<String>(this.movieList.getAudioCodecsInMovies());
        Collections.sort(audioCodecs);
        this.setValues(audioCodecs);
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

