/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.data.X;
import com.ubnt.model.api.HistoricalScore;
import com.ubnt.model.api.ImmutableHistoricalSatisfactionDto;
import com.ubnt.return.Object;
import java.util.Optional;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Value.Immutable
@Object
public interface HistoricalSatisfactionDto
extends HistoricalScore {
    @Override
    @JsonProperty(value="timestamp")
    public long timestamp();

    @JsonProperty(value="satisfaction")
    public Optional<Integer> satisfaction();

    @Override
    @JsonProperty(value="not_reported")
    public Optional<Boolean> notReported();

    public static HistoricalSatisfactionDto of(long l2, int n2) {
        return ImmutableHistoricalSatisfactionDto.builder().timestamp(l2).satisfaction(n2).build();
    }

    public static HistoricalSatisfactionDto missingInterval(long l2) {
        return ImmutableHistoricalSatisfactionDto.builder().timestamp(l2).notReported(true).build();
    }

    public static HistoricalSatisfactionDto ofLegacy(X x2) {
        long l2 = x2.getLong("time");
        return x2.getOptionalInt("satisfaction").map(n2 -> HistoricalSatisfactionDto.of(l2, n2)).orElseGet(() -> HistoricalSatisfactionDto.missingInterval(l2));
    }
}

