/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.alert;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.alert.AlertDto;
import com.ubnt.model.api.alert.AlertListDto;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Schema(name="Alert list with paging info")
@Generated(from="AlertListDto", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableAlertListDto
extends AlertListDto {
    private final List<AlertDto> data;
    private final long totalElementCount;
    private final int totalPageCount;
    private final int pageNumber;
    @Nullable
    private final Boolean orMore;
    @Nullable
    private final Boolean hasNext;

    private ImmutableAlertListDto(Builder builder) {
        this.data = ImmutableAlertListDto.oo0000(true, builder.data);
        this.totalElementCount = builder.totalElementCount;
        this.totalPageCount = builder.totalPageCount;
        this.pageNumber = builder.pageNumber;
        this.orMore = builder.orMore;
        this.hasNext = builder.hasNext;
    }

    @Override
    @JsonProperty(value="data")
    public List<AlertDto> data() {
        return this.data;
    }

    @Override
    @JsonProperty(value="total_element_count")
    @Schema(description="Number of total matched elements searching by the given criteria", example="1")
    public long totalElementCount() {
        return this.totalElementCount;
    }

    @Override
    @JsonProperty(value="total_page_count")
    public int totalPageCount() {
        return this.totalPageCount;
    }

    @Override
    @JsonProperty(value="page_number")
    public int pageNumber() {
        return this.pageNumber;
    }

    @Override
    @JsonProperty(value="or_more")
    @Schema(description="True if there can be more elements than based on the total number of page")
    public Optional<Boolean> orMore() {
        return Optional.ofNullable(this.orMore);
    }

    @Override
    @JsonProperty(value="has_next")
    public Optional<Boolean> hasNext() {
        return Optional.ofNullable(this.hasNext);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableAlertListDto && this.ifsuper(0, (ImmutableAlertListDto)object);
    }

    private boolean ifsuper(int n2, ImmutableAlertListDto immutableAlertListDto) {
        return this.data.equals(immutableAlertListDto.data) && this.totalElementCount == immutableAlertListDto.totalElementCount && this.totalPageCount == immutableAlertListDto.totalPageCount && this.pageNumber == immutableAlertListDto.pageNumber && Objects.equals(this.orMore, immutableAlertListDto.orMore) && Objects.equals(this.hasNext, immutableAlertListDto.hasNext);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + this.data.hashCode();
        n2 += (n2 << 5) + Long.hashCode(this.totalElementCount);
        n2 += (n2 << 5) + this.totalPageCount;
        n2 += (n2 << 5) + this.pageNumber;
        n2 += (n2 << 5) + Objects.hashCode(this.orMore);
        n2 += (n2 << 5) + Objects.hashCode(this.hasNext);
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("AlertListDto{");
        stringBuilder.append("data=").append(this.data);
        stringBuilder.append(", ");
        stringBuilder.append("totalElementCount=").append(this.totalElementCount);
        stringBuilder.append(", ");
        stringBuilder.append("totalPageCount=").append(this.totalPageCount);
        stringBuilder.append(", ");
        stringBuilder.append("pageNumber=").append(this.pageNumber);
        if (this.orMore != null) {
            stringBuilder.append(", ");
            stringBuilder.append("orMore=").append(this.orMore);
        }
        if (this.hasNext != null) {
            stringBuilder.append(", ");
            stringBuilder.append("hasNext=").append(this.hasNext);
        }
        return stringBuilder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAlertListDto \u00d3o0000(_o _o2) {
        Builder builder = ImmutableAlertListDto.builder();
        if (_o2.\u00d4O0000 != null) {
            builder.addAllData(_o2.\u00d4O0000);
        }
        if (_o2.\u00f4O0000) {
            builder.totalElementCount(_o2.\u00d6O0000);
        }
        if (_o2.public) {
            builder.totalPageCount(_o2.\u00d5O0000);
        }
        if (_o2.\u00d2O0000) {
            builder.pageNumber(_o2.supersuper);
        }
        if (_o2.oO0000 != null) {
            builder.orMore(_o2.oO0000);
        }
        if (_o2.OO0000 != null) {
            builder.hasNext(_o2.OO0000);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> \u00d2o0000(Iterable<? extends T> iterable, boolean bl, boolean bl2) {
        ArrayList<T> arrayList;
        if (iterable instanceof Collection) {
            int n2 = ((Collection)iterable).size();
            if (n2 == 0) {
                return Collections.emptyList();
            }
            arrayList = new ArrayList(n2);
        } else {
            arrayList = new ArrayList<T>();
        }
        for (T t2 : iterable) {
            if (bl2 && t2 == null) continue;
            if (bl) {
                Objects.requireNonNull(t2, "element");
            }
            arrayList.add(t2);
        }
        return arrayList;
    }

    private static <T> List<T> oo0000(boolean bl, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (bl) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AlertListDto", generator="Immutables")
    public static final class Builder {
        private List<AlertDto> data = new ArrayList<AlertDto>();
        private long totalElementCount;
        private int totalPageCount;
        private int pageNumber;
        @Nullable
        private Boolean orMore;
        @Nullable
        private Boolean hasNext;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AlertListDto alertListDto) {
            Optional<Boolean> optional;
            Objects.requireNonNull(alertListDto, "instance");
            this.addAllData(alertListDto.data());
            this.totalElementCount(alertListDto.totalElementCount());
            this.totalPageCount(alertListDto.totalPageCount());
            this.pageNumber(alertListDto.pageNumber());
            Optional<Boolean> optional2 = alertListDto.orMore();
            if (optional2.isPresent()) {
                this.orMore(optional2);
            }
            if ((optional = alertListDto.hasNext()).isPresent()) {
                this.hasNext(optional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addData(@Nullable AlertDto alertDto) {
            this.data.add(alertDto);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addData(AlertDto ... alertDtoArray) {
            for (AlertDto alertDto : alertDtoArray) {
                this.data.add(alertDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder data(Iterable<? extends AlertDto> iterable) {
            this.data.clear();
            return this.addAllData(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllData(Iterable<? extends AlertDto> iterable) {
            for (AlertDto alertDto : iterable) {
                this.data.add(alertDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder totalElementCount(long l2) {
            this.totalElementCount = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder totalPageCount(int n2) {
            this.totalPageCount = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pageNumber(int n2) {
            this.pageNumber = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder orMore(@Nullable Boolean bl) {
            this.orMore = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder orMore(Optional<Boolean> optional) {
            this.orMore = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hasNext(@Nullable Boolean bl) {
            this.hasNext = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hasNext(Optional<Boolean> optional) {
            this.hasNext = optional.orElse(null);
            return this;
        }

        public ImmutableAlertListDto build() {
            return new ImmutableAlertListDto(this);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AlertListDto", generator="Immutables")
    static final class _o
    extends AlertListDto {
        @Nullable
        List<AlertDto> \u00d4O0000 = Collections.emptyList();
        long \u00d6O0000;
        boolean \u00f4O0000;
        int \u00d5O0000;
        boolean public;
        int supersuper;
        boolean \u00d2O0000;
        @Nullable
        Optional<Boolean> oO0000 = Optional.empty();
        @Nullable
        Optional<Boolean> OO0000 = Optional.empty();

        _o() {
        }

        @JsonProperty(value="data")
        public void \u00f8O0000(List<AlertDto> list) {
            this.\u00d4O0000 = list;
        }

        @JsonProperty(value="total_element_count")
        @Schema(description="Number of total matched elements searching by the given criteria", example="1")
        public void \u00f5O0000(long l2) {
            this.\u00d6O0000 = l2;
            this.\u00f4O0000 = true;
        }

        @JsonProperty(value="total_page_count")
        public void newsuper(int n2) {
            this.\u00d5O0000 = n2;
            this.public = true;
        }

        @JsonProperty(value="page_number")
        public void \u00f6O0000(int n2) {
            this.supersuper = n2;
            this.\u00d2O0000 = true;
        }

        @JsonProperty(value="or_more")
        @Schema(description="True if there can be more elements than based on the total number of page")
        public void returnsuper(Optional<Boolean> optional) {
            this.oO0000 = optional;
        }

        @JsonProperty(value="has_next")
        public void \u00d8O0000(Optional<Boolean> optional) {
            this.OO0000 = optional;
        }

        @Override
        public List<AlertDto> data() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long totalElementCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int totalPageCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int pageNumber() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> orMore() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> hasNext() {
            throw new UnsupportedOperationException();
        }
    }
}

