/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.trafficrule;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.model.api.trafficrule.ImmutableTrafficRuleBandwidthLimitDto;
import com.ubnt.return.F;
import com.ubnt.service.trafficrule.TrafficRuleBandwidthLimitDocumentPart;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(as=ImmutableTrafficRuleBandwidthLimitDto.class)
@JsonDeserialize(builder=ImmutableTrafficRuleBandwidthLimitDto.Builder.class)
@Value.Immutable
@F
public interface TrafficRuleBandwidthLimitDto {
    @JsonProperty(value="enabled")
    public boolean enabled();

    @JsonProperty(value="download_limit_kbps")
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    public @Min(value=0L) @Max(value=0x7FFFFFFFL) int downloadLimitKbps();

    @JsonProperty(value="upload_limit_kbps")
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    public @Min(value=0L) @Max(value=0x7FFFFFFFL) int uploadLimitKbps();

    default public TrafficRuleBandwidthLimitDocumentPart toDocument() {
        return TrafficRuleBandwidthLimitDocumentPart.builder().\u00d300000(this.enabled()).\u00d400000(this.downloadLimitKbps()).super(this.uploadLimitKbps()).\u00d200000();
    }

    public static TrafficRuleBandwidthLimitDto fromDocument(TrafficRuleBandwidthLimitDocumentPart trafficRuleBandwidthLimitDocumentPart) {
        return ImmutableTrafficRuleBandwidthLimitDto.builder().enabled(trafficRuleBandwidthLimitDocumentPart.isEnabled()).downloadLimitKbps(trafficRuleBandwidthLimitDocumentPart.getDownloadLimitKbps()).uploadLimitKbps(trafficRuleBandwidthLimitDocumentPart.getUploadLimitKbps()).build();
    }
}

