/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.wlan;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.ubnt.data.SettingPreference;
import com.ubnt.data.WlanConf;
import com.ubnt.model.api.wlan.ApGroupMode;
import com.ubnt.model.api.wlan.DtimMode;
import com.ubnt.model.api.wlan.Hotspot2ConfigDto;
import com.ubnt.model.api.wlan.MacAddressFormat;
import com.ubnt.model.api.wlan.MacFilterPolicy;
import com.ubnt.model.api.wlan.NasIdentifierType;
import com.ubnt.model.api.wlan.PmfCipher;
import com.ubnt.model.api.wlan.PmfMode;
import com.ubnt.model.api.wlan.PrivatePreSharedKeyDto;
import com.ubnt.model.api.wlan.Security;
import com.ubnt.model.api.wlan.WlanBand;
import com.ubnt.model.api.wlan.WlanPskEntry;
import com.ubnt.model.api.wlan.WlanScheduleConfigurationEntry;
import com.ubnt.model.api.wlan.WpaEncryption;
import com.ubnt.model.api.wlan.WpaMode;
import com.ubnt.model.api.wlan.WpaPskRadius;
import com.ubnt.model.api.wlan.super;
import com.ubnt.model.oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.oOOO;
import com.ubnt.net.v2.config.security.View;
import com.ubnt.net.v2.validation.constraints.MacAddress;
import com.ubnt.net.v2.validation.constraints.OneOf;
import com.ubnt.service.sso.messagebox.S;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Schema(name="WLAN Configuration", description="WLAN Configuration")
public class WlanConfiguration
implements S {
    public static final String UID_HIDDEN_ID = "Uid";
    public static final String UID_IOT_HIDDEN_ID = "UidIot";
    public static final String UID_ONBOARDING_HIDDEN_ID = "UidOnboarding";
    public static final String UID_PORTAL_HIDDEN_ID = "UidPortal";
    public static final String[] UID_HIDDEN_IDS = new String[]{"Uid", "UidIot", "UidOnboarding", "UidPortal"};
    @JsonProperty(value="_id")
    @Schema(example="5e6285ec05938c3d128aaf07", accessMode=Schema.AccessMode.READ_ONLY)
    private String id;
    @JsonProperty(value="attr_hidden_id")
    @OneOf(text={"Uid", "UidIot", "UidOnboarding", "UidPortal"})
    @Schema(required=true, allowableValues={"Uid,UidIot,UidOnboarding,UidPortal"})
    private @OneOf(text={"Uid", "UidIot", "UidOnboarding", "UidPortal"}) String hiddenId;
    @JsonProperty(value="enabled")
    private boolean enabled;
    @JsonProperty(value="setting_preference")
    private SettingPreference settingPreference;
    @JsonProperty(value="enhanced_iot")
    private boolean enhancedIot;
    @JsonProperty(value="iapp_enabled")
    private boolean iappEnabled;
    @JsonProperty(value="x_iapp_key")
    @JsonView(value={View.SiteAdmin.class})
    private String iappKey;
    @JsonProperty(value="hide_ssid")
    private boolean hideSsid;
    @JsonProperty(value="priority")
    private oOOO priority;
    @JsonProperty(value="security")
    @NotNull
    @Schema(required=true)
    private Security security;
    @JsonProperty(value="name")
    @NotEmpty
    @Schema(required=true)
    private String name;
    @JsonProperty(value="wlan_band")
    @NotNull
    private WlanBand wlanBand;
    @JsonProperty(value="wlan_bands")
    private List<WlanBand> wlanBands;
    @JsonProperty(value="is_guest")
    private boolean guestPolicyEnabled;
    @JsonProperty(value="wpa_mode")
    private WpaMode wpaMode;
    @JsonProperty(value="wpa_enc")
    private WpaEncryption wpaEncryption;
    @JsonProperty(value="p2p")
    private Boolean p2p;
    @JsonProperty(value="p2p_cross_connect")
    private Boolean p2pCrossConnect;
    @JsonProperty(value="proxy_arp")
    private boolean proxyArp;
    @JsonProperty(value="l2_isolation")
    private Boolean l2Isolation;
    @JsonProperty(value="tdls_prohibit")
    private Boolean tdlsProhibit;
    @JsonProperty(value="bss_transition")
    private boolean bssTransition;
    @JsonProperty(value="auth_cache")
    private Boolean authCache;
    @JsonProperty(value="radiusprofile_id")
    @Schema(name="used for WPA EAP and PPSK", example="5e66097d05938c4218b013a9")
    private String radiusProfileId;
    @JsonProperty(value="vlan_enabled")
    private Boolean vlanEnabled;
    @Min(value=2L)
    @Max(value=4009L)
    @Schema(name="between 2 and 4009", example="21")
    private @Min(value=2L) @Max(value=4009L) Integer vlan;
    @JsonProperty(value="mac_filter_enabled")
    private boolean macFilterEnabled;
    @JsonProperty(value="mac_filter_policy")
    private MacFilterPolicy macFilterPolicy;
    @JsonProperty(value="mac_filter_list")
    @MacAddress
    @Schema(example="[\"aa:bb:cc:dd:ee:ff\"]")
    private List<String> macFilterList;
    @JsonProperty(value="bc_filter_enabled")
    private Boolean bcFilterEnabled;
    @MacAddress
    @JsonProperty(value="bc_filter_list")
    @Schema(example="[\"aa:bb:cc:dd:ee:ff\"]")
    private List<String> bcFilterList;
    @JsonProperty(value="country_beacon")
    private Boolean countryBeacon;
    @JsonProperty(value="optimize_iot_wifi_connectivity")
    private boolean optimizeIotWifiConnectivity;
    @JsonProperty(value="dtim_mode")
    private DtimMode dtimMode;
    @JsonProperty(value="dtim_na")
    @Min(value=1L)
    @Max(value=255L)
    @Schema(name="DTIM 5G Period", allowableValues={"range[1, 255]"}, example="1")
    private @Min(value=1L) @Max(value=255L) Integer dtimNa;
    @JsonProperty(value="dtim_ng")
    @Min(value=1L)
    @Max(value=255L)
    @Schema(name="DTIM 2G Period", allowableValues={"range[1, 255]"}, example="1")
    private @Min(value=1L) @Max(value=255L) Integer dtimNg;
    @JsonProperty(value="dtim_6e")
    @Min(value=1L)
    @Max(value=255L)
    @Schema(name="DTIM 6G Period", allowableValues={"range[1, 255]"}, example="1")
    private @Min(value=1L) @Max(value=255L) Integer dtim6e;
    @JsonProperty(value="group_rekey")
    @Schema(name="Period of GTK rekeying, in seconds. 0 is disabled.", example="0")
    private Integer groupRekeyPeriod;
    @JsonProperty(value="fast_roaming_enabled")
    @Schema(name="Enable 802.11r fast roaming")
    private boolean fastRoamingEnabled;
    @JsonProperty(value="wpa3_fast_roaming")
    @Schema(name="Enable 802.11r fast roaming for SAE/WPA3")
    private boolean wpa3FastRoamingEnabled;
    @JsonProperty(value="rrm_enabled")
    private Boolean rrmEnabled;
    @JsonProperty(value="hotspot2conf_enabled")
    @Schema(name="Enable HotSpot 2.0")
    private Boolean hotspot2confEnabled;
    @JsonProperty(value="hotspot2conf_id")
    @Schema(name="The ID of the HotSpot 2.0 profile to use for this wireless network")
    private String hotspot2confId;
    @JsonProperty(value="mcastenhance_enabled")
    @Schema(name="Enable multicast enhancement (IGMPv3)")
    private boolean multicastEnhanceEnabled;
    @JsonProperty(value="minrate_setting_preference")
    @Schema(name="Data Rate Control Preference")
    private SettingPreference minRateSettingPreference;
    @JsonProperty(value="minrate_na_advertising_rates")
    @Schema(description="By setting this to true, the AP will only advertise rates greater or equal to given data_rate_kbps")
    private Boolean minRateNaAdvertisingRates;
    @JsonProperty(value="minrate_na_data_rate_kbps")
    @OneOf(integer={6000, 9000, 12000, 18000, 24000, 36000, 48000, 54000})
    @Schema(allowableValues={"6000, 9000, 12000, 18000, 24000, 36000, 48000, 54000"}, example="36000")
    private @OneOf(integer={6000, 9000, 12000, 18000, 24000, 36000, 48000, 54000}) Integer minRateNaDataRateKbps;
    @JsonProperty(value="minrate_na_enabled")
    @Schema(name="Enable minrate on 5GHz network")
    private boolean minRateNaEnabled;
    @JsonProperty(value="minrate_ng_advertising_rates")
    @Schema(description="By setting this to true, the AP will only advertise rates greater or equal to given data_rate_kbps")
    private Boolean minRateNgAdvertisingRates;
    @JsonProperty(value="minrate_ng_data_rate_kbps")
    @OneOf(integer={1000, 2000, 5500, 6000, 9000, 11000, 12000, 18000, 24000, 36000, 48000, 54000})
    @Schema(allowableValues={"1000, 2000, 5500, 6000, 9000, 11000, 12000, 18000, 24000, 36000, 48000, 54000"}, example="36000")
    private @OneOf(integer={1000, 2000, 5500, 6000, 9000, 11000, 12000, 18000, 24000, 36000, 48000, 54000}) Integer minRateNgDataRateKbps;
    @JsonProperty(value="minrate_ng_enabled")
    private boolean minRateNgEnabled;
    @JsonProperty(value="no2ghz_oui")
    @Schema(name="Enable Blocking clients from the 2G band")
    private boolean no2ghzOui;
    @JsonProperty(value="pmf_mode")
    private PmfMode pmfMode;
    @JsonProperty(value="element_adopt")
    private Boolean elementAdopt;
    @JsonProperty(value="radius_das_enabled")
    @Schema(name="Enable RFC 5176 RADIUS DAS/DAC (CoA)")
    private boolean radiusDasEnabled;
    @JsonProperty(value="radius_mac_auth_enabled")
    private boolean radiusMacAuthEnabled;
    @JsonProperty(value="radius_macacl_empty_password")
    @Schema(name="Allow empty password")
    private Boolean radiusMacAclEmptyPassword;
    @JsonProperty(value="radius_macacl_format")
    private MacAddressFormat radiusMacAclFormat;
    @JsonProperty(value="schedule")
    @Schema(example="[\"mon-fri|0800-1900\",\"sat|1000-1500\"]")
    private List<String> schedule;
    @JsonProperty(value="schedule_with_duration")
    private List<WlanScheduleConfigurationEntry> scheduleWithDuration;
    @JsonProperty(value="schedule_enabled")
    private Boolean scheduleEnabled;
    @JsonProperty(value="schedule_reversed")
    private Boolean scheduleReversed;
    @JsonProperty(value="uapsd_enabled")
    @Schema(name="Enabled Unscheduled Automatic Power Save Delivery")
    private Boolean uapsdEnabled;
    @JsonProperty(value="dpi_enabled")
    @Schema(name="Enabled Deep Packed Inspection")
    private Boolean dpiEnabled;
    @JsonProperty(value="dpigroup_id")
    private String dpiGroupId;
    @JsonProperty(value="usergroup_id", required=true)
    private String userGroupId;
    @JsonProperty(value="networkconf_id")
    private String networkConfigurationId;
    @JsonProperty(value="roam_cluster_id")
    private Integer roamClusterId;
    @JsonProperty(value="wep_idx")
    @Min(value=1L)
    @Max(value=4L)
    @Schema(allowableValues={"range[1, 4]"}, example="2")
    private @Min(value=1L) @Max(value=4L) Integer wepIndex;
    @JsonProperty(value="ap_group_ids")
    @NotEmpty
    private List<String> apGroupIds;
    @JsonProperty(value="ap_group_mode")
    @Schema(name="AP Group Mode. \"groups\" if not present", example="groups")
    private ApGroupMode apGroupMode;
    @JsonProperty(value="x_passphrase")
    @Schema(name="WPA-PSK")
    @JsonView(value={View.SiteAdmin.class})
    private String wpaPreSharedKey;
    @JsonProperty(value="x_wep")
    @Schema(name="WEP key")
    @JsonView(value={View.SiteAdmin.class})
    private String wepKey;
    @JsonProperty(value="wpa_psk_radius")
    @Schema(name="PSK RADIUS mode for WPA-PPSK networks")
    private WpaPskRadius wpaPskRadius;
    @JsonProperty(value="pmf_cipher")
    @Schema(name="PMF Cipher Encryption")
    private PmfCipher pmfCipher;
    @JsonProperty(value="wpa3_support")
    @Schema(name="WPA3 support")
    private boolean wpa3Support;
    @JsonProperty(value="wpa3_transition")
    @Schema(name="WPA2 legacy mode support")
    private boolean wpa3Transition;
    @JsonProperty(value="wpa3_enhanced_192")
    @Schema(name="WPA3 EAP Enhanced Security 192bit")
    private boolean wpa3Enhanced192;
    @JsonProperty(value="sae_psk_vlan_required")
    @Schema(name="SAE PSK is VLAN required?")
    private Boolean saePskVlanRequired;
    @JsonProperty(value="sae_anti_clogging")
    @Schema(description="SAE anti-clogging threshold in seconds, typically 5?", example="5")
    private Integer saeAntiClogging;
    @JsonProperty(value="sae_sync")
    @Schema(description="SAE sync error threshold - how many sync errors a station can have before being disconnected; typically 5", example="5")
    private Integer saeSync;
    @JsonProperty(value="sae_groups")
    @Schema(description="List of encryption groups; each protocol will have a default eg 19 for SAE")
    private List<Integer> encryptionGroups;
    @JsonProperty(value="log_level")
    @Min(value=0L)
    @Max(value=4L)
    @Schema(name="per-SSID log level", allowableValues={"range[0, 4]"}, example="1")
    private @Min(value=0L) @Max(value=4L) Integer perSsidLogLevel;
    @JsonProperty(value="sae_psk")
    private List<WlanPskEntry> pskStationList;
    @JsonProperty(value="uid_workspace_url")
    private String uidWorkspaceUrl;
    @JsonProperty(value="private_preshared_keys_enabled")
    @Schema(name="Private Pre-Shared Keys enabled")
    private boolean privatePreSharedKeysEnabled;
    @JsonProperty(value="private_preshared_keys")
    @Schema(name="Private Pre-Shared Keys")
    private List<PrivatePreSharedKeyDto> privatePreSharedKeys;
    @JsonProperty(value="hotspot2")
    @Schema(name="Hotspot2 Configuration")
    private Hotspot2ConfigDto hotspot2Config;
    @JsonProperty(value="nas_identifier_type")
    @Schema(name="NAS Identifier Type")
    private NasIdentifierType nasIdentifierType;
    @JsonProperty(value="nas_identifier")
    @Schema(name="NAS Identifier")
    private String nasIdentifier;

    public String getId() {
        return this.id;
    }

    public String getHiddenId() {
        return this.hiddenId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isHideSsid() {
        return this.hideSsid;
    }

    public Security getSecurity() {
        return this.security;
    }

    public String getName() {
        return this.name;
    }

    public WlanBand getWlanBand() {
        return this.wlanBand;
    }

    public List<WlanBand> getWlanBands() {
        return this.wlanBands;
    }

    public boolean isGuestPolicyEnabled() {
        return this.guestPolicyEnabled;
    }

    public Optional<PmfMode> getPmfMode() {
        return Optional.ofNullable(this.pmfMode);
    }

    public Optional<WpaMode> getWpaMode() {
        return Optional.ofNullable(this.wpaMode);
    }

    public Optional<WpaEncryption> getWpaEncryption() {
        return Optional.ofNullable(this.wpaEncryption);
    }

    public Optional<String> getRadiusProfileId() {
        return Optional.ofNullable(this.radiusProfileId);
    }

    public Optional<Boolean> isVlanEnabled() {
        return Optional.ofNullable(this.vlanEnabled);
    }

    public Optional<Integer> getVlan() {
        return Optional.ofNullable(this.vlan);
    }

    public boolean isMacFilterEnabled() {
        return this.macFilterEnabled;
    }

    public MacFilterPolicy getMacFilterPolicy() {
        return Optional.ofNullable(this.macFilterPolicy).orElse(MacFilterPolicy.ALLOW);
    }

    public List<String> getMacFilterList() {
        return Optional.ofNullable(this.macFilterList).orElse(Collections.emptyList());
    }

    public WlanConfiguration setHiddenId(String string) {
        this.hiddenId = string;
        return this;
    }

    public WlanConfiguration setId(String string) {
        this.id = string;
        return this;
    }

    public WlanConfiguration setEnabled(boolean bl) {
        this.enabled = bl;
        return this;
    }

    public WlanConfiguration setSettingPreference(SettingPreference settingPreference) {
        this.settingPreference = settingPreference;
        return this;
    }

    public SettingPreference getSettingPreference() {
        return this.settingPreference;
    }

    public WlanConfiguration setEnhancedIot(boolean bl) {
        this.enhancedIot = bl;
        return this;
    }

    public boolean isEnhancedIot() {
        return this.enhancedIot;
    }

    public WlanConfiguration setHideSsid(boolean bl) {
        this.hideSsid = bl;
        return this;
    }

    public WlanConfiguration setSecurity(Security security) {
        this.security = security;
        return this;
    }

    public WlanConfiguration setName(String string) {
        this.name = string;
        return this;
    }

    public WlanConfiguration setWlanBand(WlanBand wlanBand) {
        this.wlanBand = wlanBand;
        return this;
    }

    public WlanConfiguration setWlanBands(List<WlanBand> list) {
        this.wlanBands = list;
        return this;
    }

    public WlanConfiguration setGuestPolicyEnabled(boolean bl) {
        this.guestPolicyEnabled = bl;
        return this;
    }

    public WlanConfiguration setPmfMode(PmfMode pmfMode) {
        this.pmfMode = pmfMode;
        return this;
    }

    public WlanConfiguration setWpaMode(WpaMode wpaMode) {
        this.wpaMode = wpaMode;
        return this;
    }

    public WlanConfiguration setWpaEncryption(WpaEncryption wpaEncryption) {
        this.wpaEncryption = wpaEncryption;
        return this;
    }

    public WlanConfiguration setRadiusProfileId(String string) {
        this.radiusProfileId = string;
        return this;
    }

    public WlanConfiguration setVlanEnabled(Boolean bl) {
        this.vlanEnabled = bl;
        return this;
    }

    public WlanConfiguration setVlan(Integer n2) {
        this.vlan = n2;
        return this;
    }

    public WlanConfiguration setMacFilterEnabled(boolean bl) {
        this.macFilterEnabled = bl;
        return this;
    }

    public WlanConfiguration setMacFilterPolicy(MacFilterPolicy macFilterPolicy) {
        this.macFilterPolicy = macFilterPolicy;
        return this;
    }

    public WlanConfiguration setMacFilterList(List<String> list) {
        this.macFilterList = list;
        return this;
    }

    public Optional<Boolean> isBcFilterEnabled() {
        return Optional.ofNullable(this.bcFilterEnabled);
    }

    public WlanConfiguration setBcFilterEnabled(Boolean bl) {
        this.bcFilterEnabled = bl;
        return this;
    }

    public List<String> getBcFilterList() {
        return Optional.ofNullable(this.bcFilterList).orElse(Collections.emptyList());
    }

    public WlanConfiguration setBcFilterList(List<String> list) {
        this.bcFilterList = list;
        return this;
    }

    public Optional<Boolean> isCountryBeacon() {
        return Optional.ofNullable(this.countryBeacon);
    }

    public WlanConfiguration setCountryBeacon(Boolean bl) {
        this.countryBeacon = bl;
        return this;
    }

    public boolean isOptimizeIotWifiConnectivity() {
        return this.optimizeIotWifiConnectivity;
    }

    public WlanConfiguration setOptimizeIotWifiConnectivity(boolean bl) {
        this.optimizeIotWifiConnectivity = bl;
        return this;
    }

    public Optional<DtimMode> getDtimMode() {
        return Optional.ofNullable(this.dtimMode);
    }

    public WlanConfiguration setDtimMode(DtimMode dtimMode) {
        this.dtimMode = dtimMode;
        return this;
    }

    public Optional<Integer> getDtimNa() {
        return Optional.ofNullable(this.dtimNa);
    }

    public WlanConfiguration setDtimNa(Integer n2) {
        this.dtimNa = n2;
        return this;
    }

    public Optional<Integer> getDtimNg() {
        return Optional.ofNullable(this.dtimNg);
    }

    public WlanConfiguration setDtimNg(Integer n2) {
        this.dtimNg = n2;
        return this;
    }

    public Optional<Integer> getDtim6e() {
        return Optional.ofNullable(this.dtim6e);
    }

    public WlanConfiguration setDtim6e(Integer n2) {
        this.dtim6e = n2;
        return this;
    }

    public Optional<Integer> getGroupRekeyPeriod() {
        return Optional.ofNullable(this.groupRekeyPeriod);
    }

    public WlanConfiguration setGroupRekeyPeriod(Integer n2) {
        this.groupRekeyPeriod = n2;
        return this;
    }

    public boolean isFastRoamingEnabled() {
        return this.fastRoamingEnabled;
    }

    public WlanConfiguration setFastRoamingEnabled(boolean bl) {
        this.fastRoamingEnabled = bl;
        return this;
    }

    public boolean isWpa3FastRoamingEnabled() {
        return this.wpa3FastRoamingEnabled;
    }

    public WlanConfiguration setWpa3FastRoamingEnabled(boolean bl) {
        this.wpa3FastRoamingEnabled = bl;
        return this;
    }

    public Optional<Boolean> isHotspot2confEnabled() {
        return Optional.ofNullable(this.hotspot2confEnabled);
    }

    public WlanConfiguration setHotspot2confEnabled(Boolean bl) {
        this.hotspot2confEnabled = bl;
        return this;
    }

    public Optional<String> getHotspot2confId() {
        return Optional.ofNullable(this.hotspot2confId);
    }

    public WlanConfiguration setHotspot2confId(String string) {
        this.hotspot2confId = string;
        return this;
    }

    public boolean isMulticastEnhanceEnabled() {
        return this.multicastEnhanceEnabled;
    }

    public WlanConfiguration setMulticastEnhanceEnabled(boolean bl) {
        this.multicastEnhanceEnabled = bl;
        return this;
    }

    public SettingPreference getMinRateSettingPreference() {
        return this.minRateSettingPreference;
    }

    public void setMinRateSettingPreference(SettingPreference settingPreference) {
        this.minRateSettingPreference = settingPreference;
    }

    public Optional<Boolean> isMinRateNaAdvertisingRates() {
        return Optional.ofNullable(this.minRateNaAdvertisingRates);
    }

    public WlanConfiguration setMinRateNaAdvertisingRates(Boolean bl) {
        this.minRateNaAdvertisingRates = bl;
        return this;
    }

    public Optional<Integer> getMinRateNaDataRateKbps() {
        return Optional.ofNullable(this.minRateNaDataRateKbps);
    }

    public WlanConfiguration setMinRateNaDataRateKbps(Integer n2) {
        this.minRateNaDataRateKbps = n2;
        return this;
    }

    public boolean isMinRateNaEnabled() {
        return this.minRateNaEnabled;
    }

    public WlanConfiguration setMinRateNaEnabled(boolean bl) {
        this.minRateNaEnabled = bl;
        return this;
    }

    public Optional<Boolean> isMinRateNgAdvertisingRates() {
        return Optional.ofNullable(this.minRateNgAdvertisingRates);
    }

    public WlanConfiguration setMinRateNgAdvertisingRates(Boolean bl) {
        this.minRateNgAdvertisingRates = bl;
        return this;
    }

    public Optional<Integer> getMinRateNgDataRateKbps() {
        return Optional.ofNullable(this.minRateNgDataRateKbps);
    }

    public WlanConfiguration setMinRateNgDataRateKbps(Integer n2) {
        this.minRateNgDataRateKbps = n2;
        return this;
    }

    public boolean isMinRateNgEnabled() {
        return this.minRateNgEnabled;
    }

    public WlanConfiguration setMinRateNgEnabled(boolean bl) {
        this.minRateNgEnabled = bl;
        return this;
    }

    public boolean isNo2ghzOui() {
        return this.no2ghzOui;
    }

    public WlanConfiguration setNo2ghzOui(boolean bl) {
        this.no2ghzOui = bl;
        return this;
    }

    public boolean isRadiusDasEnabled() {
        return this.radiusDasEnabled;
    }

    public WlanConfiguration setRadiusDasEnabled(boolean bl) {
        this.radiusDasEnabled = bl;
        return this;
    }

    public boolean isRadiusMacAuthEnabled() {
        return this.radiusMacAuthEnabled;
    }

    public WlanConfiguration setRadiusMacAuthEnabled(boolean bl) {
        this.radiusMacAuthEnabled = bl;
        return this;
    }

    public Optional<Boolean> isRadiusMacAclEmptyPassword() {
        return Optional.ofNullable(this.radiusMacAclEmptyPassword);
    }

    public WlanConfiguration setRadiusMacAclEmptyPassword(Boolean bl) {
        this.radiusMacAclEmptyPassword = bl;
        return this;
    }

    public Optional<MacAddressFormat> getRadiusMacAclFormat() {
        return Optional.ofNullable(this.radiusMacAclFormat);
    }

    public WlanConfiguration setRadiusMacAclFormat(MacAddressFormat macAddressFormat) {
        this.radiusMacAclFormat = macAddressFormat;
        return this;
    }

    public List<String> getSchedule() {
        return Optional.ofNullable(this.schedule).orElse(Collections.emptyList());
    }

    public WlanConfiguration setSchedule(List<String> list) {
        this.schedule = list;
        return this;
    }

    public List<WlanScheduleConfigurationEntry> getScheduleWithDuration() {
        return Optional.ofNullable(this.scheduleWithDuration).orElse(Collections.emptyList());
    }

    public WlanConfiguration setScheduleWithDuration(List<WlanScheduleConfigurationEntry> list) {
        this.scheduleWithDuration = list;
        return this;
    }

    public Optional<Boolean> isScheduleEnabled() {
        return Optional.ofNullable(this.scheduleEnabled);
    }

    public WlanConfiguration setScheduleEnabled(Boolean bl) {
        this.scheduleEnabled = bl;
        return this;
    }

    public Optional<Boolean> isScheduleReversed() {
        return Optional.ofNullable(this.scheduleReversed);
    }

    public WlanConfiguration setScheduleReversed(Boolean bl) {
        this.scheduleReversed = bl;
        return this;
    }

    public Optional<Boolean> isUapsdEnabled() {
        return Optional.ofNullable(this.uapsdEnabled);
    }

    public WlanConfiguration setUapsdEnabled(Boolean bl) {
        this.uapsdEnabled = bl;
        return this;
    }

    public Optional<String> getUserGroupId() {
        return Optional.ofNullable(this.userGroupId);
    }

    public WlanConfiguration setUserGroupId(String string) {
        this.userGroupId = string;
        return this;
    }

    public Optional<Integer> getWepIndex() {
        return Optional.ofNullable(this.wepIndex);
    }

    public WlanConfiguration setWepIndex(Integer n2) {
        this.wepIndex = n2;
        return this;
    }

    public List<String> getApGroupIds() {
        return this.apGroupIds;
    }

    public WlanConfiguration setApGroupIds(List<String> list) {
        this.apGroupIds = list;
        return this;
    }

    public ApGroupMode getApGroupMode() {
        return Optional.ofNullable(this.apGroupMode).orElse(ApGroupMode.GROUPS);
    }

    public WlanConfiguration setApGroupMode(ApGroupMode apGroupMode) {
        this.apGroupMode = apGroupMode;
        return this;
    }

    public Optional<String> getWpaPreSharedKey() {
        return Optional.ofNullable(this.wpaPreSharedKey);
    }

    public WlanConfiguration setWpaPreSharedKey(String string) {
        this.wpaPreSharedKey = string;
        return this;
    }

    public Optional<String> getWepKey() {
        return Optional.ofNullable(this.wepKey);
    }

    public WlanConfiguration setWepKey(String string) {
        this.wepKey = string;
        return this;
    }

    public Optional<PmfCipher> getPmfCipher() {
        return Optional.ofNullable(this.pmfCipher);
    }

    public WlanConfiguration setPmfCipher(PmfCipher pmfCipher) {
        this.pmfCipher = pmfCipher;
        return this;
    }

    public boolean isWpa3Support() {
        return this.wpa3Support;
    }

    public WlanConfiguration setWpa3Support(boolean bl) {
        this.wpa3Support = bl;
        return this;
    }

    public boolean isWpa3Transition() {
        return this.wpa3Transition;
    }

    public WlanConfiguration setWpa3Transition(boolean bl) {
        this.wpa3Transition = bl;
        return this;
    }

    public boolean isWpa3Enhanced192() {
        return this.wpa3Enhanced192;
    }

    public WlanConfiguration setWpa3Enhanced192(boolean bl) {
        this.wpa3Enhanced192 = bl;
        return this;
    }

    public Optional<Boolean> isSaePskVlanRequired() {
        return Optional.ofNullable(this.saePskVlanRequired);
    }

    public WlanConfiguration setSaePskVlanRequired(Boolean bl) {
        this.saePskVlanRequired = bl;
        return this;
    }

    public Optional<Integer> getSaeAntiClogging() {
        return Optional.ofNullable(this.saeAntiClogging);
    }

    public WlanConfiguration setSaeAntiClogging(Integer n2) {
        this.saeAntiClogging = n2;
        return this;
    }

    public Optional<Integer> getSaeSync() {
        return Optional.ofNullable(this.saeSync);
    }

    public WlanConfiguration setSaeSync(Integer n2) {
        this.saeSync = n2;
        return this;
    }

    public List<Integer> getEncryptionGroups() {
        return Optional.ofNullable(this.encryptionGroups).orElse(Collections.emptyList());
    }

    public WlanConfiguration setEncryptionGroups(List<Integer> list) {
        this.encryptionGroups = list;
        return this;
    }

    public Optional<Integer> getPerSsidLogLevel() {
        return Optional.ofNullable(this.perSsidLogLevel);
    }

    public WlanConfiguration setPerSsidLogLevel(Integer n2) {
        this.perSsidLogLevel = n2;
        return this;
    }

    public List<WlanPskEntry> getPskStationList() {
        return Optional.ofNullable(this.pskStationList).orElse(Collections.emptyList());
    }

    public WlanConfiguration setPskStationList(List<WlanPskEntry> list) {
        this.pskStationList = list;
        return this;
    }

    public boolean isIappEnabled() {
        return this.iappEnabled;
    }

    public WlanConfiguration setIappEnabled(boolean bl) {
        this.iappEnabled = bl;
        return this;
    }

    public Optional<String> getIappKey() {
        return Optional.ofNullable(this.iappKey);
    }

    public WlanConfiguration setIappKey(String string) {
        this.iappKey = string;
        return this;
    }

    public Optional<oOOO> getPriority() {
        return Optional.ofNullable(this.priority);
    }

    public WlanConfiguration setPriority(oOOO oOOO2) {
        this.priority = oOOO2;
        return this;
    }

    public Optional<Boolean> isP2p() {
        return Optional.ofNullable(this.p2p);
    }

    public WlanConfiguration setP2p(Boolean bl) {
        this.p2p = bl;
        return this;
    }

    public Optional<Boolean> isP2pCrossConnect() {
        return Optional.ofNullable(this.p2pCrossConnect);
    }

    public WlanConfiguration setP2pCrossConnect(Boolean bl) {
        this.p2pCrossConnect = bl;
        return this;
    }

    public boolean isProxyArp() {
        return this.proxyArp;
    }

    public WlanConfiguration setProxyArp(boolean bl) {
        this.proxyArp = bl;
        return this;
    }

    public Optional<Boolean> isL2Isolation() {
        return Optional.ofNullable(this.l2Isolation);
    }

    public WlanConfiguration setL2Isolation(Boolean bl) {
        this.l2Isolation = bl;
        return this;
    }

    public Optional<Boolean> isTdlsProhibit() {
        return Optional.ofNullable(this.tdlsProhibit);
    }

    public WlanConfiguration setTdlsProhibit(Boolean bl) {
        this.tdlsProhibit = bl;
        return this;
    }

    public boolean isBssTransition() {
        return this.bssTransition;
    }

    public WlanConfiguration setBssTransition(boolean bl) {
        this.bssTransition = bl;
        return this;
    }

    public Optional<Boolean> isAuthCache() {
        return Optional.ofNullable(this.authCache);
    }

    public WlanConfiguration setAuthCache(Boolean bl) {
        this.authCache = bl;
        return this;
    }

    public Optional<Boolean> isRrmEnabled() {
        return Optional.ofNullable(this.rrmEnabled);
    }

    public WlanConfiguration setRrmEnabled(Boolean bl) {
        this.rrmEnabled = bl;
        return this;
    }

    public Optional<Boolean> isElementAdopt() {
        return Optional.ofNullable(this.elementAdopt);
    }

    public WlanConfiguration setElementAdopt(Boolean bl) {
        this.elementAdopt = bl;
        return this;
    }

    public Optional<Boolean> isDpiEnabled() {
        return Optional.ofNullable(this.dpiEnabled);
    }

    public WlanConfiguration setDpiEnabled(Boolean bl) {
        this.dpiEnabled = bl;
        return this;
    }

    public Optional<String> getDpiGroupId() {
        return Optional.ofNullable(this.dpiGroupId);
    }

    public WlanConfiguration setDpiGroupId(String string) {
        this.dpiGroupId = string;
        return this;
    }

    public Optional<String> getNetworkConfigurationId() {
        return Optional.ofNullable(this.networkConfigurationId);
    }

    public WlanConfiguration setNetworkConfigurationId(String string) {
        this.networkConfigurationId = string;
        return this;
    }

    public Optional<Integer> getRoamClusterId() {
        return Optional.ofNullable(this.roamClusterId);
    }

    public WlanConfiguration setRoamClusterId(Integer n2) {
        this.roamClusterId = n2;
        return this;
    }

    public Optional<WpaPskRadius> getWpaPskRadius() {
        return Optional.ofNullable(this.wpaPskRadius);
    }

    public WlanConfiguration setWpaPskRadius(WpaPskRadius wpaPskRadius) {
        this.wpaPskRadius = wpaPskRadius;
        return this;
    }

    public Optional<String> getUidWorkspaceUrl() {
        return Optional.ofNullable(this.uidWorkspaceUrl);
    }

    public WlanConfiguration setUidWorkspaceUrl(String string) {
        this.uidWorkspaceUrl = string;
        return this;
    }

    public boolean isPrivatePreSharedKeysEnabled() {
        return this.privatePreSharedKeysEnabled;
    }

    public void setPrivatePreSharedKeysEnabled(boolean bl) {
        this.privatePreSharedKeysEnabled = bl;
    }

    public List<PrivatePreSharedKeyDto> getPrivatePreSharedKeys() {
        return this.privatePreSharedKeys;
    }

    public void setPrivatePreSharedKeys(List<PrivatePreSharedKeyDto> list) {
        this.privatePreSharedKeys = list;
    }

    public void setHotspot2Config(Hotspot2ConfigDto hotspot2ConfigDto) {
        this.hotspot2Config = hotspot2ConfigDto;
    }

    public Hotspot2ConfigDto getHotspot2Config() {
        return this.hotspot2Config;
    }

    public Optional<NasIdentifierType> getNasIdentifierType() {
        return Optional.ofNullable(this.nasIdentifierType);
    }

    public void setNasIdentifierType(NasIdentifierType nasIdentifierType) {
        this.nasIdentifierType = nasIdentifierType;
    }

    public Optional<String> getNasIdentifier() {
        return Optional.ofNullable(this.nasIdentifier);
    }

    public void setNasIdentifier(String string) {
        this.nasIdentifier = string;
    }

    public WlanConf toWlanConf(String string) {
        return super.\u00f400000(this, string);
    }

    public static WlanConfiguration fromWlanConf(WlanConf wlanConf) {
        return super.super(wlanConf);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WlanConfiguration wlanConfiguration = (WlanConfiguration)object;
        return this.enabled == wlanConfiguration.enabled && this.iappEnabled == wlanConfiguration.iappEnabled && this.hideSsid == wlanConfiguration.hideSsid && this.proxyArp == wlanConfiguration.proxyArp && this.bssTransition == wlanConfiguration.bssTransition && this.macFilterEnabled == wlanConfiguration.macFilterEnabled && this.optimizeIotWifiConnectivity == wlanConfiguration.optimizeIotWifiConnectivity && this.fastRoamingEnabled == wlanConfiguration.fastRoamingEnabled && this.wpa3FastRoamingEnabled == wlanConfiguration.wpa3FastRoamingEnabled && this.multicastEnhanceEnabled == wlanConfiguration.multicastEnhanceEnabled && this.minRateNaEnabled == wlanConfiguration.minRateNaEnabled && this.minRateNgEnabled == wlanConfiguration.minRateNgEnabled && this.no2ghzOui == wlanConfiguration.no2ghzOui && this.radiusDasEnabled == wlanConfiguration.radiusDasEnabled && this.radiusMacAuthEnabled == wlanConfiguration.radiusMacAuthEnabled && this.wpa3Support == wlanConfiguration.wpa3Support && this.wpa3Transition == wlanConfiguration.wpa3Transition && this.wpa3Enhanced192 == wlanConfiguration.wpa3Enhanced192 && this.enhancedIot == wlanConfiguration.enhancedIot && Objects.equals(this.id, wlanConfiguration.id) && Objects.equals(this.hiddenId, wlanConfiguration.hiddenId) && this.settingPreference == wlanConfiguration.settingPreference && Objects.equals(this.iappKey, wlanConfiguration.iappKey) && this.priority == wlanConfiguration.priority && this.security == wlanConfiguration.security && Objects.equals(this.name, wlanConfiguration.name) && this.wlanBand == wlanConfiguration.wlanBand && Objects.equals(this.wlanBands, wlanConfiguration.wlanBands) && Objects.equals(this.guestPolicyEnabled, wlanConfiguration.guestPolicyEnabled) && this.wpaMode == wlanConfiguration.wpaMode && this.wpaEncryption == wlanConfiguration.wpaEncryption && Objects.equals(this.p2p, wlanConfiguration.p2p) && Objects.equals(this.p2pCrossConnect, wlanConfiguration.p2pCrossConnect) && Objects.equals(this.l2Isolation, wlanConfiguration.l2Isolation) && Objects.equals(this.tdlsProhibit, wlanConfiguration.tdlsProhibit) && Objects.equals(this.authCache, wlanConfiguration.authCache) && Objects.equals(this.radiusProfileId, wlanConfiguration.radiusProfileId) && Objects.equals(this.vlanEnabled, wlanConfiguration.vlanEnabled) && Objects.equals(this.vlan, wlanConfiguration.vlan) && this.macFilterPolicy == wlanConfiguration.macFilterPolicy && Objects.equals(this.macFilterList, wlanConfiguration.macFilterList) && Objects.equals(this.bcFilterEnabled, wlanConfiguration.bcFilterEnabled) && Objects.equals(this.bcFilterList, wlanConfiguration.bcFilterList) && Objects.equals(this.countryBeacon, wlanConfiguration.countryBeacon) && this.dtimMode == wlanConfiguration.dtimMode && Objects.equals(this.dtimNa, wlanConfiguration.dtimNa) && Objects.equals(this.dtimNg, wlanConfiguration.dtimNg) && Objects.equals(this.dtim6e, wlanConfiguration.dtim6e) && Objects.equals(this.groupRekeyPeriod, wlanConfiguration.groupRekeyPeriod) && Objects.equals(this.rrmEnabled, wlanConfiguration.rrmEnabled) && Objects.equals(this.hotspot2confEnabled, wlanConfiguration.hotspot2confEnabled) && Objects.equals(this.hotspot2confId, wlanConfiguration.hotspot2confId) && Objects.equals(this.minRateNaAdvertisingRates, wlanConfiguration.minRateNaAdvertisingRates) && Objects.equals(this.minRateNaDataRateKbps, wlanConfiguration.minRateNaDataRateKbps) && Objects.equals(this.minRateNgAdvertisingRates, wlanConfiguration.minRateNgAdvertisingRates) && Objects.equals(this.minRateNgDataRateKbps, wlanConfiguration.minRateNgDataRateKbps) && this.pmfMode == wlanConfiguration.pmfMode && Objects.equals(this.elementAdopt, wlanConfiguration.elementAdopt) && Objects.equals(this.radiusMacAclEmptyPassword, wlanConfiguration.radiusMacAclEmptyPassword) && this.radiusMacAclFormat == wlanConfiguration.radiusMacAclFormat && Objects.equals(this.schedule, wlanConfiguration.schedule) && Objects.equals(this.scheduleWithDuration, wlanConfiguration.scheduleWithDuration) && Objects.equals(this.scheduleEnabled, wlanConfiguration.scheduleEnabled) && Objects.equals(this.scheduleReversed, wlanConfiguration.scheduleReversed) && Objects.equals(this.uapsdEnabled, wlanConfiguration.uapsdEnabled) && Objects.equals(this.dpiEnabled, wlanConfiguration.dpiEnabled) && Objects.equals(this.dpiGroupId, wlanConfiguration.dpiGroupId) && Objects.equals(this.userGroupId, wlanConfiguration.userGroupId) && Objects.equals(this.networkConfigurationId, wlanConfiguration.networkConfigurationId) && Objects.equals(this.roamClusterId, wlanConfiguration.roamClusterId) && Objects.equals(this.wepIndex, wlanConfiguration.wepIndex) && Objects.equals(this.apGroupIds, wlanConfiguration.apGroupIds) && Objects.equals(this.wpaPreSharedKey, wlanConfiguration.wpaPreSharedKey) && Objects.equals(this.wepKey, wlanConfiguration.wepKey) && this.wpaPskRadius == wlanConfiguration.wpaPskRadius && this.pmfCipher == wlanConfiguration.pmfCipher && Objects.equals(this.saePskVlanRequired, wlanConfiguration.saePskVlanRequired) && Objects.equals(this.saeAntiClogging, wlanConfiguration.saeAntiClogging) && Objects.equals(this.saeSync, wlanConfiguration.saeSync) && Objects.equals(this.encryptionGroups, wlanConfiguration.encryptionGroups) && Objects.equals(this.perSsidLogLevel, wlanConfiguration.perSsidLogLevel) && Objects.equals(this.pskStationList, wlanConfiguration.pskStationList) && Objects.equals(this.privatePreSharedKeysEnabled, wlanConfiguration.privatePreSharedKeysEnabled) && Objects.equals(this.privatePreSharedKeys, wlanConfiguration.privatePreSharedKeys) && Objects.equals(this.hotspot2Config, wlanConfiguration.hotspot2Config) && Objects.equals((Object)this.nasIdentifierType, (Object)wlanConfiguration.nasIdentifierType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.hiddenId, this.enabled, this.settingPreference, this.iappEnabled, this.iappKey, this.hideSsid, this.priority, this.security, this.name, this.wlanBand, this.wlanBands, this.guestPolicyEnabled, this.wpaMode, this.wpaEncryption, this.p2p, this.p2pCrossConnect, this.proxyArp, this.l2Isolation, this.tdlsProhibit, this.bssTransition, this.authCache, this.radiusProfileId, this.vlanEnabled, this.vlan, this.macFilterEnabled, this.macFilterPolicy, this.macFilterList, this.bcFilterEnabled, this.bcFilterList, this.countryBeacon, this.optimizeIotWifiConnectivity, this.dtimMode, this.dtimNa, this.dtimNg, this.dtim6e, this.groupRekeyPeriod, this.fastRoamingEnabled, this.wpa3FastRoamingEnabled, this.rrmEnabled, this.hotspot2confEnabled, this.hotspot2confId, this.multicastEnhanceEnabled, this.minRateNaAdvertisingRates, this.minRateNaDataRateKbps, this.minRateNaEnabled, this.minRateNgAdvertisingRates, this.minRateNgDataRateKbps, this.minRateNgEnabled, this.no2ghzOui, this.pmfMode, this.elementAdopt, this.radiusDasEnabled, this.radiusMacAuthEnabled, this.radiusMacAclEmptyPassword, this.radiusMacAclFormat, this.schedule, this.scheduleWithDuration, this.scheduleEnabled, this.scheduleReversed, this.uapsdEnabled, this.dpiEnabled, this.dpiGroupId, this.userGroupId, this.networkConfigurationId, this.roamClusterId, this.wepIndex, this.apGroupIds, this.wpaPreSharedKey, this.wepKey, this.wpaPskRadius, this.pmfCipher, this.wpa3Support, this.wpa3Transition, this.wpa3Enhanced192, this.enhancedIot, this.saePskVlanRequired, this.saeAntiClogging, this.saeSync, this.encryptionGroups, this.perSsidLogLevel, this.pskStationList, this.privatePreSharedKeysEnabled, this.privatePreSharedKeys, this.hotspot2Config, this.nasIdentifierType, this.nasIdentifier});
    }
}

