/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.ext.ComponentAttributeProvider;
import org.jgrapht.ext.ComponentNameProvider;
import org.jgrapht.ext.DOTUtils;
import org.jgrapht.ext.GraphExporter;
import org.jgrapht.ext.IntegerComponentNameProvider;
import org.jgrapht.graph.AbstractBaseGraph;

public class DOTExporter<V, E>
implements GraphExporter<V, E> {
    public static final String DEFAULT_GRAPH_ID = "G";
    private ComponentNameProvider<Graph<V, E>> graphIDProvider;
    private ComponentNameProvider<V> vertexIDProvider;
    private ComponentNameProvider<V> vertexLabelProvider;
    private ComponentNameProvider<E> edgeLabelProvider;
    private ComponentAttributeProvider<V> vertexAttributeProvider;
    private ComponentAttributeProvider<E> edgeAttributeProvider;

    public DOTExporter() {
        this(new IntegerComponentNameProvider(), null, null, null, null, null);
    }

    public DOTExporter(ComponentNameProvider<V> vertexIDProvider, ComponentNameProvider<V> vertexLabelProvider, ComponentNameProvider<E> edgeLabelProvider) {
        this(vertexIDProvider, vertexLabelProvider, edgeLabelProvider, null, null, null);
    }

    public DOTExporter(ComponentNameProvider<V> vertexIDProvider, ComponentNameProvider<V> vertexLabelProvider, ComponentNameProvider<E> edgeLabelProvider, ComponentAttributeProvider<V> vertexAttributeProvider, ComponentAttributeProvider<E> edgeAttributeProvider) {
        this(vertexIDProvider, vertexLabelProvider, edgeLabelProvider, vertexAttributeProvider, edgeAttributeProvider, null);
    }

    public DOTExporter(ComponentNameProvider<V> vertexIDProvider, ComponentNameProvider<V> vertexLabelProvider, ComponentNameProvider<E> edgeLabelProvider, ComponentAttributeProvider<V> vertexAttributeProvider, ComponentAttributeProvider<E> edgeAttributeProvider, ComponentNameProvider<Graph<V, E>> graphIDProvider) {
        this.vertexIDProvider = vertexIDProvider;
        this.vertexLabelProvider = vertexLabelProvider;
        this.edgeLabelProvider = edgeLabelProvider;
        this.vertexAttributeProvider = vertexAttributeProvider;
        this.edgeAttributeProvider = edgeAttributeProvider;
        this.graphIDProvider = graphIDProvider == null ? any -> DEFAULT_GRAPH_ID : graphIDProvider;
    }

    @Override
    public void exportGraph(Graph<V, E> g, Writer writer) {
        String connector;
        PrintWriter out = new PrintWriter(writer);
        String indent = "  ";
        String header = g instanceof AbstractBaseGraph && !((AbstractBaseGraph)g).isAllowingMultipleEdges() ? "strict " : "";
        String graphId = this.graphIDProvider.getName(g);
        if (graphId == null || graphId.trim().isEmpty()) {
            graphId = DEFAULT_GRAPH_ID;
        }
        if (!DOTUtils.isValidID(graphId)) {
            throw new RuntimeException("Generated graph ID '" + graphId + "' is not valid with respect to the .dot language");
        }
        if (g instanceof DirectedGraph) {
            header = header + "digraph";
            connector = " -> ";
        } else {
            header = header + "graph";
            connector = " -- ";
        }
        header = header + " " + graphId + " {";
        out.println(header);
        for (V v : g.vertexSet()) {
            out.print(indent + this.getVertexID(v));
            String labelName = null;
            if (this.vertexLabelProvider != null) {
                labelName = this.vertexLabelProvider.getName(v);
            }
            Map<String, String> attributes = null;
            if (this.vertexAttributeProvider != null) {
                attributes = this.vertexAttributeProvider.getComponentAttributes(v);
            }
            this.renderAttributes(out, labelName, attributes);
            out.println(";");
        }
        for (Object e : g.edgeSet()) {
            String source = this.getVertexID(g.getEdgeSource(e));
            String target = this.getVertexID(g.getEdgeTarget(e));
            out.print(indent + source + connector + target);
            String labelName = null;
            if (this.edgeLabelProvider != null) {
                labelName = this.edgeLabelProvider.getName(e);
            }
            Map<String, String> attributes = null;
            if (this.edgeAttributeProvider != null) {
                attributes = this.edgeAttributeProvider.getComponentAttributes(e);
            }
            this.renderAttributes(out, labelName, attributes);
            out.println(";");
        }
        out.println("}");
        out.flush();
    }

    private void renderAttributes(PrintWriter out, String labelName, Map<String, String> attributes) {
        if (labelName == null && attributes == null) {
            return;
        }
        out.print(" [ ");
        if (labelName == null) {
            labelName = attributes.get("label");
        }
        if (labelName != null) {
            out.print("label=\"" + labelName + "\" ");
        }
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String name = entry.getKey();
                if (name.equals("label")) continue;
                out.print(name + "=\"" + entry.getValue() + "\" ");
            }
        }
        out.print("]");
    }

    private String getVertexID(V v) {
        String idCandidate = this.vertexIDProvider.getName(v);
        if (DOTUtils.isValidID(idCandidate)) {
            return idCandidate;
        }
        throw new RuntimeException("Generated id '" + idCandidate + "'for vertex '" + v + "' is not valid with respect to the .dot language");
    }
}

