/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.tools;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.structure.PDNumberTreeNode;

public class PageLabels {
    private final NavigableMap<Integer, PageLabelDictionary> labelsMap;

    public PageLabels(PDNumberTreeNode numberTree) {
        if (numberTree == null) {
            throw new IllegalArgumentException("Number tree base element can not be null");
        }
        this.labelsMap = new TreeMap<Integer, PageLabelDictionary>();
        this.parseTree(numberTree);
    }

    private void parseTree(PDNumberTreeNode numberTree) {
        for (Map.Entry<Long, COSObject> entry : numberTree.getNums().entrySet()) {
            Long key = entry.getKey();
            COSObject cosValue = entry.getValue();
            if (key == null || cosValue == null || cosValue.empty() || cosValue.getType() != COSObjType.COS_DICT) continue;
            PageLabelDictionary pageLabelDictionary = new PageLabelDictionary((COSDictionary)cosValue.getDirectBase(), key.intValue());
            this.labelsMap.put(key.intValue(), pageLabelDictionary);
        }
        for (PDNumberTreeNode kid : numberTree.getKids()) {
            this.parseTree(kid);
        }
    }

    public String getLabel(int pageIndex) {
        Map.Entry<Integer, PageLabelDictionary> pageLabelDictionaryEntry = this.labelsMap.floorEntry(pageIndex);
        if (pageLabelDictionaryEntry != null) {
            return pageLabelDictionaryEntry.getValue().getLabel(pageIndex);
        }
        return null;
    }

    private static class PageLabelDictionary {
        private static final TreeMap<Integer, String> MAP = new TreeMap();
        private final ASAtom type;
        private final String prefix;
        private final int firstRangePortion;
        private final int rangeStartIndex;

        public PageLabelDictionary(COSDictionary dict, int rangeStartIndex) {
            this.type = dict.getNameKey(ASAtom.S);
            String prefixValue = dict.getStringKey(ASAtom.P);
            this.prefix = prefixValue == null ? "" : prefixValue;
            Long integerKey = dict.getIntegerKey(ASAtom.ST);
            this.firstRangePortion = integerKey == null ? 1 : integerKey.intValue();
            this.rangeStartIndex = rangeStartIndex;
        }

        public String getLabel(int pageIndex) {
            if (pageIndex < this.rangeStartIndex) {
                throw new IllegalArgumentException("Page index can not be less than range start index");
            }
            int pageNumber = this.getLabelNumber(pageIndex);
            String number = this.getTypedNumber(pageNumber);
            return this.prefix + number;
        }

        private String getTypedNumber(int pageNumber) {
            if (ASAtom.D == this.type) {
                return String.valueOf(pageNumber);
            }
            if (ASAtom.R == this.type) {
                return PageLabelDictionary.getRoman(pageNumber);
            }
            if (ASAtom.R_LOWERCASE == this.type) {
                return PageLabelDictionary.getRoman(pageNumber).toLowerCase();
            }
            if (ASAtom.A == this.type) {
                return PageLabelDictionary.getLetters(pageNumber);
            }
            if (ASAtom.A_LOWERCASE == this.type) {
                return PageLabelDictionary.getLetters(pageNumber).toLowerCase();
            }
            return "";
        }

        private static String getLetters(int pageNumber) {
            int numb = pageNumber - 1;
            int remainder = numb % 26;
            char letter = (char)(65 + remainder);
            int numberOfLetters = numb / 26 + 1;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < numberOfLetters; ++i) {
                builder.append(letter);
            }
            return builder.toString();
        }

        private static String getRoman(int pageNumber) {
            int floor;
            StringBuilder builder = new StringBuilder();
            for (int curr = pageNumber; curr > 0; curr -= floor) {
                floor = MAP.floorKey(curr);
                builder.append(MAP.get(floor));
            }
            return builder.toString();
        }

        private int getLabelNumber(int pageIndex) {
            return pageIndex - this.rangeStartIndex + this.firstRangePortion;
        }

        static {
            MAP.put(1000, "M");
            MAP.put(900, "CM");
            MAP.put(500, "D");
            MAP.put(400, "CD");
            MAP.put(100, "C");
            MAP.put(90, "XC");
            MAP.put(50, "L");
            MAP.put(40, "XL");
            MAP.put(10, "X");
            MAP.put(9, "IX");
            MAP.put(5, "V");
            MAP.put(4, "IV");
            MAP.put(1, "I");
        }
    }
}

