/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.editor.AnnotationsAttributeEditor;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.editor.ElementValueAdder;
import proguard.classfile.editor.ParameterAnnotationsAttributeEditor;
import proguard.classfile.util.SimplifiedVisitor;

public class AnnotationAdder
extends SimplifiedVisitor
implements AnnotationVisitor {
    private static final ElementValue[] EMPTY_ELEMENT_VALUES = new ElementValue[0];
    private final ProgramClass targetClass;
    private final AnnotationElementValue targetAnnotationElementValue;
    private final AnnotationsAttributeEditor annotationsAttributeEditor;
    private final ParameterAnnotationsAttributeEditor parameterAnnotationsAttributeEditor;
    private final ConstantAdder constantAdder;

    public AnnotationAdder(ProgramClass targetClass, AnnotationElementValue targetAnnotationElementValue) {
        this.targetClass = targetClass;
        this.targetAnnotationElementValue = targetAnnotationElementValue;
        this.annotationsAttributeEditor = null;
        this.parameterAnnotationsAttributeEditor = null;
        this.constantAdder = new ConstantAdder(targetClass);
    }

    public AnnotationAdder(ProgramClass targetClass, AnnotationsAttribute targetAnnotationsAttribute) {
        this.targetClass = targetClass;
        this.targetAnnotationElementValue = null;
        this.annotationsAttributeEditor = new AnnotationsAttributeEditor(targetAnnotationsAttribute);
        this.parameterAnnotationsAttributeEditor = null;
        this.constantAdder = new ConstantAdder(targetClass);
    }

    public AnnotationAdder(ProgramClass targetClass, ParameterAnnotationsAttribute targetParameterAnnotationsAttribute) {
        this.targetClass = targetClass;
        this.targetAnnotationElementValue = null;
        this.annotationsAttributeEditor = null;
        this.parameterAnnotationsAttributeEditor = new ParameterAnnotationsAttributeEditor(targetParameterAnnotationsAttribute);
        this.constantAdder = new ConstantAdder(targetClass);
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        Annotation newAnnotation = new Annotation(this.constantAdder.addConstant(clazz, annotation.u2typeIndex), 0, annotation.u2elementValuesCount > 0 ? new ElementValue[annotation.u2elementValuesCount] : EMPTY_ELEMENT_VALUES);
        newAnnotation.referencedClasses = annotation.referencedClasses;
        annotation.elementValuesAccept(clazz, new ElementValueAdder(this.targetClass, newAnnotation, false));
        if (this.targetAnnotationElementValue != null) {
            this.targetAnnotationElementValue.annotationValue = newAnnotation;
        } else {
            this.annotationsAttributeEditor.addAnnotation(newAnnotation);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Method method, int parameterIndex, Annotation annotation) {
        Annotation newAnnotation = new Annotation(this.constantAdder.addConstant(clazz, annotation.u2typeIndex), 0, annotation.u2elementValuesCount > 0 ? new ElementValue[annotation.u2elementValuesCount] : EMPTY_ELEMENT_VALUES);
        newAnnotation.referencedClasses = annotation.referencedClasses;
        annotation.elementValuesAccept(clazz, new ElementValueAdder(this.targetClass, newAnnotation, false));
        this.parameterAnnotationsAttributeEditor.addAnnotation(parameterIndex, newAnnotation);
    }
}

