/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.functions.Reverse;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;

public abstract class SequenceExtent
implements GroundedValue {
    public static Of<Item> from(SequenceIterator iter) {
        Item item;
        ArrayList<Item> list = new ArrayList<Item>(!SequenceTool.supportsGetLength(iter) ? 20 : ((LastPositionFinder)((Object)iter)).getLength());
        while ((item = iter.next()) != null) {
            list.add(item);
        }
        return new Of<Item>(list);
    }

    public static GroundedValue makeResidue(SequenceIterator iter) {
        if (iter instanceof GroundedIterator && ((GroundedIterator)iter).isActuallyGrounded()) {
            return ((GroundedIterator)iter).getResidue();
        }
        Of<Item> extent = SequenceExtent.from(iter);
        return extent.reduce();
    }

    public static <T extends Item> GroundedValue makeSequenceExtent(List<T> input) {
        int len = input.size();
        if (len == 0) {
            return EmptySequence.getInstance();
        }
        if (len == 1) {
            return (GroundedValue)input.get(0);
        }
        return new Of<T>(input);
    }

    public abstract SequenceIterator reverseIterate();

    public static class Of<T extends Item>
    extends SequenceExtent
    implements Iterable<T> {
        private List<T> items;

        public Of(List<T> list) {
            this.items = list;
        }

        public Of(T[] items) {
            this(Arrays.asList(items));
        }

        public Of(Of<T> ext, int start, int length) {
            this.items = ext.items.subList(start, start + length);
        }

        @Override
        public ListIterator.Of<T> iterate() {
            return new ListIterator.Of<T>(this.items);
        }

        @Override
        public SequenceIterator reverseIterate() {
            return Reverse.reverseIterator(this.items);
        }

        @Override
        public boolean effectiveBooleanValue() throws XPathException {
            int len = this.getLength();
            if (len == 0) {
                return false;
            }
            Item first = (Item)this.items.get(0);
            if (first instanceof NodeInfo) {
                return true;
            }
            if (len == 1 && first instanceof AtomicValue) {
                return first.effectiveBooleanValue();
            }
            return ExpressionTool.effectiveBooleanValue(this.iterate());
        }

        @Override
        public Item itemAt(int n) {
            if (n >= 0 && n < this.items.size()) {
                return (Item)this.items.get(n);
            }
            return null;
        }

        @Override
        public Item head() {
            if (this.items.isEmpty()) {
                return null;
            }
            return (Item)this.items.get(0);
        }

        @Override
        public int getLength() {
            return this.items.size();
        }

        @Override
        public UnicodeString getUnicodeStringValue() throws XPathException {
            switch (this.getLength()) {
                case 0: {
                    return EmptyUnicodeString.getInstance();
                }
                case 1: {
                    return this.head().getUnicodeStringValue();
                }
            }
            UnicodeBuilder builder = new UnicodeBuilder();
            UnicodeString separator = EmptyUnicodeString.getInstance();
            for (Item item : this.items) {
                builder.append(separator);
                separator = StringConstants.SINGLE_SPACE;
                builder.append(item.getStringValue());
            }
            return builder.toUnicodeString();
        }

        @Override
        public String getStringValue() throws XPathException {
            switch (this.getLength()) {
                case 0: {
                    return "";
                }
                case 1: {
                    return this.head().getStringValue();
                }
            }
            StringBuilder builder = new StringBuilder();
            String separator = "";
            for (Item item : this.items) {
                builder.append(separator);
                separator = " ";
                builder.append(item.getStringValue());
            }
            return builder.toString();
        }

        @Override
        public GroundedValue subsequence(int start, int length) {
            int size;
            if (start < 0) {
                start = 0;
            }
            if (start > (size = this.getLength())) {
                return EmptySequence.getInstance();
            }
            int limit = (long)start + (long)length > (long)size ? size : start + length;
            return new Of<T>(this.items.subList(start, limit)).reduce();
        }

        public String toString() {
            StringBuilder fsb = new StringBuilder(64);
            for (int i = 0; i < this.getLength(); ++i) {
                fsb.append(i == 0 ? "(" : ", ");
                fsb.append(((Item)this.items.get(i)).toString());
            }
            fsb.append(')');
            return fsb.toString();
        }

        @Override
        public GroundedValue reduce() {
            int len = this.getLength();
            if (len == 0) {
                return EmptySequence.getInstance();
            }
            if (len == 1) {
                return this.itemAt(0);
            }
            return this;
        }

        @Override
        public Iterator<T> iterator() {
            return this.items.iterator();
        }
    }
}

