/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.api.FeatureReport;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.LinkedResource;
import com.adobe.epubcheck.opf.LinkedResources;
import com.adobe.epubcheck.opf.MetadataSet;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFHandler;
import com.adobe.epubcheck.opf.OPFHandler30;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.PublicationType;
import com.adobe.epubcheck.opf.ResourceCollection;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.overlay.OverlayTextChecker;
import com.adobe.epubcheck.overlay.SmilClock;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.vocab.DCMESVocab;
import com.adobe.epubcheck.vocab.MediaOverlaysVocab;
import com.adobe.epubcheck.vocab.PackageVocabs;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import io.mola.galimatias.URL;
import java.util.List;
import java.util.Set;
import org.w3c.epubcheck.core.references.Reference;
import org.w3c.epubcheck.core.references.ReferenceRegistry;
import org.w3c.epubcheck.util.url.URLFragment;

public class OPFChecker30
extends OPFChecker {
    public OPFChecker30(ValidationContext context) {
        super(context);
    }

    @Override
    public void initHandler() {
        this.opfHandler = new OPFHandler30(this.context);
    }

    @Override
    protected boolean checkPackage() {
        super.checkPackage();
        this.checkCollectionsContent();
        this.checkPagination();
        this.checkSemantics();
        this.checkNav();
        this.checkSpecifics();
        return false;
    }

    @Override
    protected boolean checkContent() {
        super.checkContent();
        this.checkLinkedResources();
        this.checkCollections();
        this.checkMediaOverlaysDuration();
        return true;
    }

    @Override
    protected void checkItem(OPFItem item, OPFHandler opfHandler) {
        Optional<OPFItem> overlay;
        String mimeType;
        if (item.hasDataURL()) {
            this.report.message(MessageId.RSC_029, item.getLocation(), new Object[0]);
            return;
        }
        if (item.getPath().startsWith("META-INF/")) {
            this.report.message(MessageId.PKG_025, item.getLocation(), new Object[0]);
        }
        if ((mimeType = item.getMimeType()) == null || mimeType.equals("")) {
            return;
        }
        if (!mimeType.matches("[a-zA-Z0-9!#$&+-^_]+/[a-zA-Z0-9!#$&+-^_]+")) {
            return;
        }
        String preferredMimeType = OPFChecker30.getPreferredMediaType(mimeType, item.getPath());
        if (preferredMimeType != null) {
            this.report.message(MessageId.OPF_090, item.getLocation(), preferredMimeType, mimeType);
        }
        if (!item.isRemote() && item.getURL().fragment() != null) {
            this.report.message(MessageId.OPF_091, item.getLocation(), new Object[0]);
        }
        if (this.context.referenceRegistry.isPresent() && !Strings.isNullOrEmpty((String)item.getMediaOverlay()) && (overlay = opfHandler.getItemById(item.getMediaOverlay())).isPresent()) {
            ((ReferenceRegistry)this.context.referenceRegistry.get()).registerReference(((OPFItem)overlay.get()).getURL(), Reference.Type.MEDIA_OVERLAY, item.getLocation());
        }
    }

    @Override
    protected void checkItemAfterResourceValidation(OPFItem item) {
        String mediatype = item.getMimeType();
        if (!(!item.isRemote() || OPFChecker30.isAudioType(mediatype) || OPFChecker30.isVideoType(mediatype) || "application/x-shockwave-flash".equals(mediatype) || OPFChecker30.isFontType(mediatype))) {
            if (item.isInSpine()) {
                this.report.message(MessageId.RSC_006, item.getLocation(), item.getPath());
            } else if (!((ReferenceRegistry)this.context.referenceRegistry.get()).hasReferencesTo(item.getURL())) {
                if (this.context.featureReport.hasFeature(FeatureEnum.HAS_SCRIPTS)) {
                    this.report.message(MessageId.RSC_006b, item.getLocation(), item.getPath());
                } else {
                    this.report.message(MessageId.RSC_006, item.getLocation(), item.getPath());
                }
            }
        }
        if (!item.isInSpine() && !item.isNav() && !item.isNcx() && this.context.referenceRegistry.isPresent() && ((ReferenceRegistry)this.context.referenceRegistry.get()).asList().stream().noneMatch(ref -> ref.targetResource.equals((Object)item.getURL()) && ref.type.isPublicationResourceReference())) {
            this.report.message(MessageId.OPF_097, item.getLocation(), item.getPath());
        }
        if (OPFChecker30.isBlessedItemType(mediatype, this.version)) {
            OverlayTextChecker overlayTextChecker = (OverlayTextChecker)this.context.overlayTextChecker.get();
            String mo = item.getMediaOverlay();
            URL docURL = item.getURL();
            if (overlayTextChecker.isReferencedByOverlay(docURL)) {
                if (Strings.isNullOrEmpty((String)mo)) {
                    this.report.message(MessageId.MED_010, item.getLocation().context(item.getPath()), new Object[0]);
                } else if (!overlayTextChecker.isCorrectOverlay(docURL, mo)) {
                    this.report.message(MessageId.MED_012, item.getLocation().context(item.getPath()), new Object[0]);
                }
            } else if (!Strings.isNullOrEmpty((String)mo)) {
                this.report.message(MessageId.MED_013, item.getLocation().context(item.getPath()), new Object[0]);
            }
        }
        if (item.isInSpine() && !item.isLinear() && this.context.referenceRegistry.isPresent() && !((ReferenceRegistry)this.context.referenceRegistry.get()).asList().stream().anyMatch(ref -> ref.type == Reference.Type.HYPERLINK && ref.targetResource.equals((Object)item.getURL()))) {
            if (this.context.featureReport.hasFeature(FeatureEnum.HAS_SCRIPTS)) {
                this.report.message(MessageId.OPF_096b, item.getLocation(), item.getPath());
            } else {
                this.report.message(MessageId.OPF_096, item.getLocation(), item.getPath());
            }
        }
    }

    @Override
    protected void checkSpineItem(OPFItem item, OPFHandler opfHandler) {
        String mimeType;
        if (item.hasDataURL()) {
            return;
        }
        if (item.getProperties().contains(PackageVocabs.ITEM_VOCAB.get(PackageVocabs.ITEM_PROPERTIES.DATA_NAV))) {
            this.report.message(MessageId.OPF_077, item.getLocation(), new Object[0]);
        }
        if (!OPFChecker30.isBlessedItemType(mimeType = item.getMimeType(), this.version)) {
            if (!item.hasFallback()) {
                this.report.message(MessageId.OPF_043, item.getLocation(), mimeType);
            } else if (!item.hasContentDocumentFallback()) {
                this.report.message(MessageId.OPF_044, item.getLocation(), mimeType);
            }
        }
    }

    private void checkCollections() {
        for (ResourceCollection collection : ((OPFHandler30)this.opfHandler).getCollections().asList()) {
            if (collection.hasRole(ResourceCollection.Roles.DICTIONARY)) {
                this.checkDictCollection(collection);
            }
            if (collection.hasRole(ResourceCollection.Roles.INDEX)) {
                this.checkIndexCollection(collection);
            }
            if (!collection.hasRole(ResourceCollection.Roles.PREVIEW)) continue;
            this.checkPreviewCollection(collection);
        }
    }

    private void checkCollectionsContent() {
        for (ResourceCollection collection : ((OPFHandler30)this.opfHandler).getCollections().asList()) {
            if (!collection.hasRole(ResourceCollection.Roles.DICTIONARY)) continue;
            this.checkDictCollectionContent(collection);
        }
    }

    private void checkDictCollection(ResourceCollection collection) {
        if (collection.hasRole(ResourceCollection.Roles.DICTIONARY)) {
            boolean skmFound = false;
            for (LinkedResource resource : collection.getResources().asList()) {
                Optional<OPFItem> item = this.opfHandler.getItemByURL(resource.getDocumentURL());
                if (!item.isPresent()) {
                    this.report.message(MessageId.OPF_081, EPUBLocation.of(this.context), this.context.relativize(resource.getDocumentURL()));
                    continue;
                }
                if ("application/vnd.epub.search-key-map+xml".equals(((OPFItem)item.get()).getMimeType())) {
                    if (skmFound) {
                        this.report.message(MessageId.OPF_082, EPUBLocation.of(this.context), new Object[0]);
                    }
                    skmFound = true;
                    continue;
                }
                if ("application/xhtml+xml".equals(((OPFItem)item.get()).getMimeType())) continue;
                this.report.message(MessageId.OPF_084, EPUBLocation.of(this.context), this.context.relativize(resource.getDocumentURL()));
            }
            if (!skmFound) {
                this.report.message(MessageId.OPF_083, EPUBLocation.of(this.context), new Object[0]);
            }
        }
    }

    private void checkDictCollectionContent(ResourceCollection collection) {
        if (collection.hasRole(ResourceCollection.Roles.DICTIONARY)) {
            boolean dictFound = false;
            for (LinkedResource resource : collection.getResources().asList()) {
                final Optional<OPFItem> item = this.opfHandler.getItemByURL(resource.getDocumentURL());
                if (dictFound || !item.isPresent() || !"application/xhtml+xml".equals(((OPFItem)item.get()).getMimeType())) continue;
                dictFound = Iterables.tryFind(this.context.featureReport.getFeature(FeatureEnum.DICTIONARY), (Predicate)new Predicate<FeatureReport.Feature>(){

                    public boolean apply(FeatureReport.Feature dict) {
                        return ((OPFItem)item.get()).getPath().equals(((EPUBLocation)dict.getLocation().get()).getPath());
                    }
                }).isPresent();
            }
            if (!dictFound) {
                this.report.message(MessageId.OPF_078, EPUBLocation.of(this.context), new Object[0]);
            }
        }
    }

    private void checkIndexCollection(ResourceCollection collection) {
        if (collection.hasRole(ResourceCollection.Roles.INDEX) || collection.hasRole(ResourceCollection.Roles.INDEX_GROUP)) {
            for (LinkedResource resource : collection.getResources().asList()) {
                Optional<OPFItem> item = this.opfHandler.getItemByURL(resource.getDocumentURL());
                if (item.isPresent() && "application/xhtml+xml".equals(((OPFItem)item.get()).getMimeType())) continue;
                this.report.message(MessageId.OPF_071, EPUBLocation.of(this.context), new Object[0]);
            }
            for (ResourceCollection childCollection : collection.getCollections().asList()) {
                this.checkIndexCollection(childCollection);
            }
        }
    }

    private void checkPreviewCollection(ResourceCollection collection) {
        if (collection.hasRole(ResourceCollection.Roles.PREVIEW)) {
            for (LinkedResource resource : collection.getResources().asList()) {
                Optional<OPFItem> item = this.opfHandler.getItemByURL(resource.getDocumentURL());
                if (!item.isPresent() || !"application/xhtml+xml".equals(((OPFItem)item.get()).getMimeType()) && !"image/svg+xml".equals(((OPFItem)item.get()).getMimeType())) {
                    this.report.message(MessageId.OPF_075, EPUBLocation.of(this.context), new Object[0]);
                    continue;
                }
                URLFragment fragment = URLFragment.parse(resource.getURL());
                if (!fragment.exists() || !"epubcfi".equals(fragment.getScheme())) continue;
                this.report.message(MessageId.OPF_076, EPUBLocation.of(this.context), new Object[0]);
            }
        }
    }

    private void checkLinkedResources() {
        LinkedResources links = ((OPFHandler30)this.opfHandler).getLinkedResources();
        for (LinkedResource link : links.asList()) {
            Optional<OPFItem> item = this.opfHandler.getItemByURL(link.getDocumentURL());
            if (!item.isPresent() || ((OPFItem)item.get()).isInSpine()) continue;
            this.report.message(MessageId.OPF_067, EPUBLocation.of(this.context), ((OPFItem)item.get()).getPath());
        }
    }

    private void checkMediaOverlaysDuration() {
        MetadataSet metadata = ((OPFHandler30)this.opfHandler).getMetadata();
        List<MetadataSet.Metadata> totalDurationExpressions = metadata.getPrimary(MediaOverlaysVocab.VOCAB.get(MediaOverlaysVocab.PROPERTIES.DURATION));
        if (!totalDurationExpressions.isEmpty()) {
            try {
                SmilClock totalDuration = new SmilClock(totalDurationExpressions.iterator().next().getValue());
                SmilClock sumDuration = new SmilClock();
                List<MetadataSet.Metadata> allDurations = metadata.getAny(MediaOverlaysVocab.VOCAB.get(MediaOverlaysVocab.PROPERTIES.DURATION));
                for (MetadataSet.Metadata durationExpression : allDurations) {
                    if (durationExpression.isPrimary()) continue;
                    sumDuration = sumDuration.addTime(new SmilClock(durationExpression.getValue()));
                }
                if (!totalDuration.eqWithinTolerance(sumDuration, 1000L)) {
                    this.report.message(MessageId.MED_016, EPUBLocation.of(this.context), new Object[0]);
                }
            }
            catch (NumberFormatException e) {
                return;
            }
        }
    }

    private void checkPagination() {
        if ((this.context.profile == EPUBProfile.EDUPUB || this.context.pubTypes.contains((Object)PublicationType.EDUPUB)) && this.context.featureReport.hasFeature(FeatureEnum.PAGE_BREAK)) {
            List<MetadataSet.Metadata> dcSourceMetas;
            if (!this.context.featureReport.hasFeature(FeatureEnum.PAGE_LIST)) {
                this.report.message(MessageId.NAV_003, EPUBLocation.of(this.context), new Object[0]);
            }
            if ((dcSourceMetas = ((OPFHandler30)this.opfHandler).getMetadata().getPrimary(DCMESVocab.VOCAB.get(DCMESVocab.PROPERTIES.SOURCE))).isEmpty()) {
                this.report.message(MessageId.OPF_066, EPUBLocation.of(this.context), new Object[0]);
            } else if (!MetadataSet.tryFindInRefines(dcSourceMetas, PackageVocabs.META_VOCAB.get(PackageVocabs.META_PROPERTIES.SOURCE_OF), (Optional<String>)Optional.of((Object)"pagination")).isPresent()) {
                this.report.message(MessageId.OPF_066, EPUBLocation.of(this.context), new Object[0]);
            }
        }
    }

    private void checkSemantics() {
        if ((this.context.profile == EPUBProfile.EDUPUB || this.context.pubTypes.contains((Object)PublicationType.EDUPUB)) && this.context.featureReport.hasFeature(FeatureEnum.HAS_MICRODATA) && !this.context.featureReport.hasFeature(FeatureEnum.HAS_RDFA)) {
            this.report.message(MessageId.HTM_051, (EPUBLocation)this.context.featureReport.getFeature(FeatureEnum.HAS_MICRODATA).iterator().next().getLocation().get(), new Object[0]);
        }
    }

    private void checkNav() {
        if (this.context.profile == EPUBProfile.EDUPUB || this.context.pubTypes.contains((Object)PublicationType.EDUPUB)) {
            Set<FeatureReport.Feature> sections = this.context.featureReport.getFeature(FeatureEnum.SECTIONS);
            Set<FeatureReport.Feature> tocLinks = this.context.featureReport.getFeature(FeatureEnum.TOC_LINKS);
            if (sections.size() != tocLinks.size()) {
                this.report.message(MessageId.NAV_004, tocLinks.isEmpty() ? EPUBLocation.of(this.context) : (EPUBLocation)tocLinks.iterator().next().getLocation().get(), new Object[0]);
            }
            if (this.context.featureReport.hasFeature(FeatureEnum.AUDIO) && !this.context.featureReport.hasFeature(FeatureEnum.LOA)) {
                this.report.message(MessageId.NAV_005, tocLinks.isEmpty() ? EPUBLocation.of(this.context) : (EPUBLocation)tocLinks.iterator().next().getLocation().get(), new Object[0]);
            }
            if (this.context.featureReport.hasFeature(FeatureEnum.FIGURE) && !this.context.featureReport.hasFeature(FeatureEnum.LOI)) {
                this.report.message(MessageId.NAV_006, tocLinks.isEmpty() ? EPUBLocation.of(this.context) : (EPUBLocation)tocLinks.iterator().next().getLocation().get(), new Object[0]);
            }
            if (this.context.featureReport.hasFeature(FeatureEnum.TABLE) && !this.context.featureReport.hasFeature(FeatureEnum.LOT)) {
                this.report.message(MessageId.NAV_007, tocLinks.isEmpty() ? EPUBLocation.of(this.context) : (EPUBLocation)tocLinks.iterator().next().getLocation().get(), new Object[0]);
            }
            if (this.context.featureReport.hasFeature(FeatureEnum.VIDEO) && !this.context.featureReport.hasFeature(FeatureEnum.LOV)) {
                this.report.message(MessageId.NAV_008, tocLinks.isEmpty() ? EPUBLocation.of(this.context) : (EPUBLocation)tocLinks.iterator().next().getLocation().get(), new Object[0]);
            }
        }
    }

    private void checkSpecifics() {
        if (this.context.featureReport.hasFeature(FeatureEnum.DICTIONARY) && !this.context.pubTypes.contains((Object)PublicationType.DICTIONARY)) {
            this.report.message(MessageId.OPF_079, (EPUBLocation)this.context.featureReport.getFeature(FeatureEnum.DICTIONARY).iterator().next().getLocation().get(), new Object[0]);
        }
        if ((this.context.profile == EPUBProfile.DICT || this.context.pubTypes.contains((Object)PublicationType.DICTIONARY)) && !this.context.featureReport.hasFeature(FeatureEnum.DICTIONARY)) {
            this.report.message(MessageId.OPF_078, EPUBLocation.of(this.context), new Object[0]);
        }
    }

    public static boolean isAudioType(String type) {
        return type != null && type.startsWith("audio/");
    }

    public static boolean isBlessedAudioType(String type) {
        return type.equals("audio/mpeg") || type.equals("audio/mp4") || type.matches("audio/ogg\\s*;\\s*codecs=opus");
    }

    public static boolean isVideoType(String type) {
        return type != null && type.startsWith("video/");
    }

    public static boolean isBlessedVideoType(String type) {
        return OPFChecker30.isVideoType(type);
    }

    public static boolean isCommonVideoType(String type) {
        return "video/h264".equals(type) || "video/webm".equals(type) || "video/mp4".equals(type);
    }

    public static boolean isFontType(String type) {
        return type.startsWith("font/") || type.startsWith("application/font-") || type.equals("application/vnd.ms-opentype");
    }

    public static boolean isBlessedFontType(String type) {
        return type.equals("font/otf") || type.equals("font/ttf") || type.equals("font/woff") || type.equals("font/woff2") || type.equals("application/font-sfnt") || type.equals("application/font-woff") || type.equals("application/vnd.ms-opentype") || type.equals("application/x-font-ttf");
    }

    public static boolean isBlessedScriptType(String type) {
        return type.equals("text/javascript") || type.equals("application/javascript") || type.equals("application/ecmascript");
    }

    public static boolean isCoreMediaType(String type) {
        return type != null && (OPFChecker30.isBlessedAudioType(type) || OPFChecker30.isBlessedVideoType(type) || OPFChecker30.isBlessedFontType(type) || OPFChecker30.isBlessedItemType(type, EPUBVersion.VERSION_3) || OPFChecker30.isBlessedImageType(type, EPUBVersion.VERSION_3) || OPFChecker30.isBlessedScriptType(type) || OPFChecker30.isBlessedStyleType(type) || type.equals("application/pls+xml") || type.equals("application/smil+xml") || type.equals("image/svg+xml"));
    }

    public static String getPreferredMediaType(String type, String path) {
        switch (Strings.nullToEmpty((String)type)) {
            case "application/font-sfnt": {
                return path.endsWith(".ttf") ? "font/ttf" : (path.endsWith(".otf") ? "font/otf" : "font/(ttf|otf)");
            }
            case "application/vnd.ms-opentype": {
                return "font/otf";
            }
            case "application/font-woff": {
                return "font/woff";
            }
            case "application/x-font-ttf": {
                return "font/ttf";
            }
            case "text/javascript": 
            case "application/ecmascript": {
                return "application/javascript";
            }
        }
        return null;
    }
}

