/*
 * Decompiled with CFR 0.152.
 */
package agent.frida;

import agent.frida.model.impl.FridaModelImpl;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.program.model.listing.Program;
import java.util.concurrent.CompletableFuture;

@ConfigurableFactory.FactoryDescription(brief="PROTOTYPE: Frida", htmlDetails="Connect to Frida.\nThis is an experimental connector. Use at your own risk.\nThis will access the native API, which may put Ghidra's JVM at risk.")
public class FridaInJvmDebuggerModelFactory
implements DebuggerModelFactory {
    public CompletableFuture<? extends DebuggerObjectModel> build() {
        FridaModelImpl model = new FridaModelImpl();
        return model.startFrida(new String[0]).thenApply(__ -> model);
    }

    public int getPriority(Program program) {
        String exe;
        String osname = System.getProperty("os.name").toLowerCase();
        if (!(osname.contains("mac os x") || osname.contains("linux") || osname.contains("windows"))) {
            return -1;
        }
        if (program != null && ((exe = program.getExecutablePath()) == null || exe.isBlank())) {
            return -1;
        }
        return 30;
    }
}

