/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.manager.FridaReason;
import agent.frida.manager.FridaState;
import agent.frida.manager.FridaValue;
import agent.frida.model.iface2.FridaModelTargetRegister;
import agent.frida.model.iface2.FridaModelTargetRegisterBank;
import agent.frida.model.iface2.FridaModelTargetRegisterContainerAndBank;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.impl.FridaModelTargetRegisterImpl;
import agent.frida.model.impl.FridaModelTargetThreadImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.error.DebuggerRegisterAccessException;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="RegisterContainer", attributeResync=TargetObjectSchema.ResyncMode.ALWAYS, elements={@TargetElementType(type=FridaModelTargetRegisterImpl.class)}, attributes={@TargetAttributeType(name="_descriptions", type=FridaModelTargetRegisterContainerImpl.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class FridaModelTargetRegisterContainerImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetRegisterContainerAndBank {
    public static final String NAME = "Registers";
    protected final FridaModelTargetThreadImpl thread;

    public FridaModelTargetRegisterContainerImpl(FridaModelTargetThreadImpl thread) {
        super(thread.getModel(), (TargetObject)thread, NAME, "RegisterContainer");
        this.thread = thread;
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getName(), "_descriptions", this), "Initialized");
        this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        if (refresh.equals((Object)DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS)) {
            this.broadcast().invalidateCacheRequested((TargetObject)this);
        }
        return this.getManager().listRegisters(this.thread.getThread()).thenAccept(registers -> {
            List targetRegisters;
            FridaModelTargetRegisterContainerImpl fridaModelTargetRegisterContainerImpl = this;
            synchronized (fridaModelTargetRegisterContainerImpl) {
                targetRegisters = registers.entrySet().stream().map(this::getTargetRegister).collect(Collectors.toList());
            }
            this.setElements(targetRegisters, Map.of(), "Refreshed");
            if (!this.getCachedElements().isEmpty()) {
                this.readRegistersNamed(this.getCachedElements().keySet());
            }
        });
    }

    @Override
    public FridaModelTargetRegister getTargetRegister(Map.Entry entry) {
        FridaValue val = new FridaValue((String)entry.getKey(), (String)entry.getValue());
        TargetObject targetObject = this.getMapObject(val);
        if (targetObject != null) {
            FridaModelTargetRegister targetRegister = (FridaModelTargetRegister)targetObject;
            targetRegister.setModelObject(val);
            return targetRegister;
        }
        return new FridaModelTargetRegisterImpl(this, val);
    }

    public void threadStateChangedSpecific(FridaState state, FridaReason reason) {
        if (state.equals((Object)FridaState.FRIDA_THREAD_STOPPED)) {
            this.requestAttributes(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER).thenAccept(__ -> {
                for (Object attribute : this.getCachedAttributes().values()) {
                    if (!(attribute instanceof FridaModelTargetRegisterBank)) continue;
                    FridaModelTargetRegisterBank bank = (FridaModelTargetRegisterBank)attribute;
                    bank.threadStateChangedSpecific(state, reason);
                }
            });
        }
    }

    public CompletableFuture<? extends Map<String, byte[]>> readRegistersNamed(Collection<String> names) {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        Map els = this.getCachedElements();
        for (String regname : names) {
            if (!this.elements.containsKey(regname)) {
                throw new DebuggerRegisterAccessException("No such register: " + regname);
            }
            FridaModelTargetRegisterImpl register = (FridaModelTargetRegisterImpl)els.get(regname);
            byte[] bytes = register.getBytes();
            result.put(regname, bytes);
        }
        this.broadcast().registersUpdated((TargetObject)this, result);
        return CompletableFuture.completedFuture(result);
    }

    public CompletableFuture<Void> writeRegistersNamed(Map<String, byte[]> values) {
        Map els = this.getCachedElements();
        for (Map.Entry<String, byte[]> ent : values.entrySet()) {
            String regname = ent.getKey();
            FridaModelTargetRegisterImpl reg = (FridaModelTargetRegisterImpl)els.get(regname);
            if (reg == null) {
                throw new DebuggerRegisterAccessException("No such register: " + regname);
            }
            BigInteger val = new BigInteger(1, ent.getValue());
            reg.getRegister().setValue(val.toString());
        }
        this.broadcast().registersUpdated((TargetObject)this.getProxy(), values);
        return AsyncUtils.nil();
    }
}

