/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaCause;
import agent.frida.manager.FridaFrame;
import agent.frida.manager.FridaReason;
import agent.frida.manager.FridaState;
import agent.frida.manager.FridaThread;
import agent.frida.model.iface1.FridaModelTargetFocusScope;
import agent.frida.model.iface2.FridaModelTargetProcess;
import agent.frida.model.iface2.FridaModelTargetThread;
import agent.frida.model.iface2.FridaModelTargetThreadContainer;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.impl.FridaModelTargetRegisterContainerImpl;
import agent.frida.model.impl.FridaModelTargetStackImpl;
import agent.frida.model.methods.FridaModelTargetThreadStalkImpl;
import agent.frida.model.methods.FridaModelTargetUnloadScriptImpl;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Thread", attributeResync=TargetObjectSchema.ResyncMode.ALWAYS, elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Registers", type=FridaModelTargetRegisterContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Stack", type=FridaModelTargetStackImpl.class, required=true, fixed=true), @TargetAttributeType(name="_arch", type=String.class), @TargetAttributeType(type=Object.class)})
public class FridaModelTargetThreadImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetThread {
    public static final TargetSteppable.TargetStepKindSet SUPPORTED_KINDS = TargetSteppable.TargetStepKindSet.of();
    protected final FridaModelTargetStackImpl stack;
    private FridaModelTargetProcess process;
    private Integer base = 10;
    private FridaModelTargetRegisterContainerImpl registers;
    private FridaModelTargetThreadStalkImpl stalk;
    private FridaModelTargetUnloadScriptImpl unload;

    protected static String indexThread(Integer id) {
        return PathUtils.makeIndex((int)id);
    }

    protected static String indexThread(FridaThread thread) {
        return FridaClient.getId(thread);
    }

    protected static String keyThread(FridaThread thread) {
        return PathUtils.makeKey((String)FridaModelTargetThreadImpl.indexThread(thread));
    }

    public FridaModelTargetThreadImpl(FridaModelTargetThreadContainer threads, FridaModelTargetProcess process, FridaThread thread) {
        super(threads.getModel(), (TargetObject)threads, FridaModelTargetThreadImpl.keyThread(thread), thread, "Thread");
        this.process = process;
        this.registers = new FridaModelTargetRegisterContainerImpl(this);
        this.stack = new FridaModelTargetStackImpl(this, process);
        this.stalk = new FridaModelTargetThreadStalkImpl(this);
        this.unload = new FridaModelTargetUnloadScriptImpl(this, this.stalk.getName());
        this.changeAttributes(List.of(), List.of(this.registers, this.stack, this.stalk, this.unload), Map.of("_display", this.getDisplay(), "_state", TargetExecutionStateful.TargetExecutionState.ALIVE), "Initialized");
        this.getManager().addStateListener(this);
        this.getManager().addEventsListener(this);
    }

    @Override
    public void setModelObject(Object modelObject) {
        super.setModelObject(modelObject);
        this.getModel().addModelObject(modelObject, (TargetObject)this);
    }

    @Override
    public String getDescription(int level) {
        FridaThread thread = (FridaThread)this.getModelObject();
        return thread.getDescription();
    }

    public String getDisplay() {
        Object tidstr = FridaClient.getId(this.getThread());
        tidstr = this.base == 16 ? "0x" + (String)tidstr : Long.toString(Long.parseLong((String)tidstr, 16));
        return "[" + (String)tidstr + "]";
    }

    @Override
    public void threadSelected(FridaThread eventThread, FridaFrame frame, FridaCause cause) {
        if (eventThread.getTid().equals(this.getThread().getTid())) {
            ((FridaModelTargetFocusScope)this.searchForSuitable(TargetFocusScope.class)).setFocus(this);
        }
    }

    @Override
    public void threadStateChangedSpecific(FridaState state, FridaReason reason) {
        TargetExecutionStateful.TargetExecutionState targetState = FridaClient.convertState(state);
        this.changeAttributes(List.of(), List.of(), Map.of("_state", targetState), reason.desc());
        this.stack.threadStateChangedSpecific(state, reason);
        this.registers.threadStateChangedSpecific(state, reason);
    }

    @Override
    public CompletableFuture<Void> setActive() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public FridaModelTargetStackImpl getStack() {
        return this.stack;
    }

    @Override
    public FridaThread getThread() {
        return (FridaThread)this.getModelObject();
    }

    public FridaModelTargetProcess getProcess() {
        return this.process;
    }

    @Override
    public String getExecutingProcessorType() {
        return null;
    }

    public void setBase(Object value) {
        this.base = (Integer)value;
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay()), "Started");
    }

    @Override
    public void stateChanged(FridaState state, FridaCause cause) {
        FridaModelTargetThreadContainer container = (FridaModelTargetThreadContainer)this.getParent();
        FridaReason.Reasons unknown = FridaReason.Reasons.UNKNOWN;
        this.process.threadStateChanged(this.getThread(), state, cause, unknown);
        container.threadStateChanged(this.getThread(), state, cause, unknown);
        this.threadStateChangedSpecific(state, unknown);
    }
}

