/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.extensions;

import generic.jar.ResourceFile;
import generic.json.Json;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.extensions.ExtensionUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import utilities.util.FileUtilities;
import utility.application.ApplicationLayout;

public class ExtensionDetails
implements Comparable<ExtensionDetails> {
    private File installDir;
    private String archivePath;
    private String name;
    private String description;
    private String createdOn;
    private String author;
    private String version;

    public ExtensionDetails(String name, String description, String author, String createdOn, String version) {
        this.name = name;
        this.description = description;
        this.author = author;
        this.createdOn = createdOn;
        this.version = version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionDetails other = (ExtensionDetails)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String getInstallPath() {
        if (this.installDir != null) {
            return this.installDir.getAbsolutePath();
        }
        return null;
    }

    public File getInstallDir() {
        return this.installDir;
    }

    public void setInstallDir(File installDir) {
        this.installDir = installDir;
    }

    public String getArchivePath() {
        return this.archivePath;
    }

    public void setArchivePath(String path) {
        this.archivePath = path;
    }

    public boolean isFromArchive() {
        return this.archivePath != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String date) {
        this.createdOn = date;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Set<URL> getLibraries() {
        if (!this.isInstalled()) {
            return Collections.emptySet();
        }
        HashSet<File> jarFiles = new HashSet<File>();
        this.findJarFiles(new File(this.installDir, "lib"), jarFiles);
        HashSet<URL> paths = new HashSet<URL>();
        for (File jar : jarFiles) {
            try {
                URL jarUrl = jar.toURI().toURL();
                paths.add(jarUrl);
            }
            catch (MalformedURLException e) {}
        }
        return paths;
    }

    public boolean isInstalled() {
        if (this.installDir == null) {
            return false;
        }
        if (Application.inSingleJarMode()) {
            return true;
        }
        File f = new File(this.installDir, "Module.manifest");
        return f.exists();
    }

    public boolean isPendingUninstall() {
        if (this.installDir == null) {
            return false;
        }
        if (Application.inSingleJarMode()) {
            return false;
        }
        File f = new File(this.installDir, "Module.manifest.uninstalled");
        return f.exists();
    }

    public boolean isInstalledInInstallationFolder() {
        if (this.installDir == null) {
            return false;
        }
        ApplicationLayout layout = Application.getApplicationLayout();
        List extDirs = layout.getExtensionInstallationDirs();
        if (extDirs.size() < 2) {
            Msg.trace((Object)this, (Object)"Unexpected extension installation dirs; revisit this assumption");
            return false;
        }
        ResourceFile appExtDir = (ResourceFile)extDirs.get(1);
        return FileUtilities.isPathContainedWithin((File)appExtDir.getFile(false), (File)this.installDir);
    }

    public boolean markForUninstall() {
        if (this.installDir == null) {
            return false;
        }
        Msg.trace((Object)this, (Object)("Marking extension for uninstall '" + this.installDir + "'"));
        boolean success = true;
        File manifest = new File(this.installDir, "Module.manifest");
        if (manifest.exists()) {
            File newFile = new File(this.installDir, "Module.manifest.uninstalled");
            if (!manifest.renameTo(newFile)) {
                Msg.trace((Object)this, (Object)("Unable to rename module manifest file: " + manifest));
                success = false;
            }
        } else {
            Msg.trace((Object)this, (Object)("No manifest file found for extension '" + this.name + "'"));
        }
        File properties = new File(this.installDir, ExtensionUtils.PROPERTIES_FILE_NAME);
        if (properties.exists()) {
            File newFile = new File(this.installDir, ExtensionUtils.PROPERTIES_FILE_NAME_UNINSTALLED);
            if (!properties.renameTo(newFile)) {
                Msg.trace((Object)this, (Object)("Unable to rename properties file: " + properties));
                success = false;
            }
        } else {
            Msg.trace((Object)this, (Object)("No properties file found for extension '" + this.name + "'"));
        }
        return success;
    }

    public boolean clearMarkForUninstall() {
        if (this.installDir == null) {
            Msg.error((Object)this, (Object)("Cannot restore extension; extension installation dir is missing for: " + this.name));
            return false;
        }
        Msg.trace((Object)this, (Object)("Restoring extension state files for '" + this.installDir + "'"));
        boolean success = true;
        File manifest = new File(this.installDir, "Module.manifest.uninstalled");
        if (manifest.exists()) {
            File newFile = new File(this.installDir, "Module.manifest");
            if (!manifest.renameTo(newFile)) {
                Msg.trace((Object)this, (Object)("Unable to rename module manifest file: " + manifest));
                success = false;
            }
        } else {
            Msg.trace((Object)this, (Object)("No manifest file found for extension '" + this.name + "'"));
        }
        File properties = new File(this.installDir, ExtensionUtils.PROPERTIES_FILE_NAME_UNINSTALLED);
        if (properties.exists()) {
            File newFile = new File(this.installDir, ExtensionUtils.PROPERTIES_FILE_NAME);
            if (!properties.renameTo(newFile)) {
                Msg.trace((Object)this, (Object)("Unable to rename properties file: " + properties));
                success = false;
            }
        } else {
            Msg.trace((Object)this, (Object)("No properties file found for extension '" + this.name + "'"));
        }
        return success;
    }

    @Override
    public int compareTo(ExtensionDetails other) {
        return this.name.compareTo(other.name);
    }

    public String toString() {
        return Json.toString(this);
    }

    private void findJarFiles(File dir, Set<File> jarFiles) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (!f.isFile() || !f.getName().endsWith(".jar")) continue;
            jarFiles.add(f);
        }
    }
}

