/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.java;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.java.JavaClassDecompilerFileSystemFactory;
import ghidra.file.jad.JadProcessController;
import ghidra.file.jad.JadProcessWrapper;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.SingleFileSystemIndexHelper;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.fileinfo.FileAttribute;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import utilities.util.FileUtilities;

@FileSystemInfo(type="javaclass", description="Java Class Decompiler", factory=JavaClassDecompilerFileSystemFactory.class, priority=-10)
public class JavaClassDecompilerFileSystem
implements GFileSystem {
    private final FSRLRoot fsFSRL;
    private final FileSystemService fsService;
    private FileSystemRefManager refManager = new FileSystemRefManager((GFileSystem)this);
    private SingleFileSystemIndexHelper fsIndexHelper;
    private ByteProvider provider;
    private FSRL containerFSRL;
    private String className;
    private String javaSrcFilename;

    public JavaClassDecompilerFileSystem(FSRLRoot fsFSRL, ByteProvider provider, FileSystemService fsService, TaskMonitor monitor) throws CancelledException, IOException {
        this.fsService = fsService;
        this.fsFSRL = fsFSRL;
        this.provider = provider;
        this.containerFSRL = provider.getFSRL();
        this.className = FilenameUtils.removeExtension((String)this.containerFSRL.getName());
        this.javaSrcFilename = this.className + ".java";
        try (ByteProvider decompiledBP = this.getDecompiledJavaSrcFileEntry(null, monitor);){
            this.fsIndexHelper = new SingleFileSystemIndexHelper((GFileSystem)this, fsFSRL, this.javaSrcFilename, decompiledBP.length(), decompiledBP.getFSRL().getMD5());
        }
    }

    private ByteProvider getDecompiledJavaSrcFileEntry(FSRL targetFSRL, TaskMonitor monitor) throws CancelledException, IOException {
        return this.fsService.getDerivedByteProviderPush(this.containerFSRL, targetFSRL, this.javaSrcFilename, -1L, os -> this.decompileClassFileToStream(os, monitor), monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompileClassFileToStream(OutputStream os, TaskMonitor monitor) throws CancelledException, IOException {
        File tempDir = null;
        try {
            tempDir = FileUtilities.createTempDirectory((String)"JavaClassDecompilerFileSystem");
            File tempClassFile = new File(tempDir, this.containerFSRL.getName());
            FSUtilities.copyByteProviderToFile((ByteProvider)this.provider, (File)tempClassFile, (TaskMonitor)monitor);
            File tempDestJavaSrcFile = new File(tempDir, this.javaSrcFilename);
            JadProcessWrapper wrapper = new JadProcessWrapper(tempClassFile);
            JadProcessController controller = new JadProcessController(wrapper, this.className);
            controller.decompile(5, monitor);
            FileUtilities.copyFileToStream((File)tempDestJavaSrcFile, (OutputStream)os, (TaskMonitor)monitor);
        }
        finally {
            FileUtilities.deleteDir((File)tempDir, (TaskMonitor)monitor);
        }
    }

    public GFile getPayloadFile() {
        return this.fsIndexHelper.getPayloadFile();
    }

    public String getName() {
        return this.containerFSRL.getName();
    }

    public void close() throws IOException {
        this.refManager.onClose();
        this.fsIndexHelper.clear();
        this.provider.close();
    }

    public boolean isClosed() {
        return this.fsIndexHelper.isClosed();
    }

    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    public int getFileCount() {
        return this.fsIndexHelper.getFileCount();
    }

    public GFile lookup(String path) {
        return this.fsIndexHelper.lookup(path);
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        if (this.fsIndexHelper.isPayloadFile(file)) {
            return this.getDecompiledJavaSrcFileEntry(file.getFSRL(), monitor);
        }
        return null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsIndexHelper.getListing(directory);
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        return FileAttributes.of((FileAttribute[])new FileAttribute[]{FileAttribute.create((String)"Class name", (Object)this.className)});
    }

    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }
}

