/*
 * Decompiled with CFR 0.152.
 */
package ghidra.macosx.plugins;

import docking.Tool;
import docking.action.builder.ActionBuilder;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImage;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingAndSlideInfo;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.file.formats.ios.dyldcache.DyldCacheFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.options.Options;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="DYLD Cache Builder", description="This plugin provides actions for adding DYLD Cache components to the program")
public class DyldCacheBuilderPlugin
extends Plugin {
    public DyldCacheBuilderPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
        String actionName = "Add To Program";
        new ActionBuilder(actionName, this.getName()).withContext(ProgramLocationActionContext.class).enabledWhen(p -> p.getProgram().getExecutableFormat().equals("Extracted DYLD Component")).onAction(plac -> TaskLauncher.launchModal((String)actionName, monitor -> this.addMissingDyldCacheComponent(plac.getLocation(), monitor))).popupMenuPath(new String[]{"References", actionName}).popupMenuGroup("Add").helpLocation(new HelpLocation("ImporterPlugin", "Add_To_Program")).buildAndInstall((Tool)this.tool);
    }

    private void addMissingDyldCacheComponent(ProgramLocation location, TaskMonitor monitor) {
        Program program = location.getProgram();
        Address refAddress = location.getRefAddress();
        if (refAddress == null) {
            Msg.showInfo((Object)((Object)this), null, (String)this.name, (Object)"No referenced address selected");
            return;
        }
        if (refAddress.getAddressSpace().isExternalSpace()) {
            Msg.showInfo((Object)((Object)this), null, (String)this.name, (Object)"External locations are not currently supported");
            return;
        }
        if (program.getMemory().contains(refAddress)) {
            Msg.showInfo((Object)((Object)this), null, (String)this.name, (Object)"Referenced address already exists in memory");
            return;
        }
        try (FileSystemRef fsRef2 = this.openDyldCache(program, monitor);){
            DyldCacheFileSystem fs = (DyldCacheFileSystem)fsRef2.getFilesystem();
            DyldCacheUtils.SplitDyldCache splitDyldCache = fs.getSplitDyldCache();
            long refAddr = refAddress.getOffset();
            String fsPath = this.findInDylibSegment(refAddr, splitDyldCache);
            if (fsPath == null) {
                fsPath = this.findInStubs(refAddr, splitDyldCache);
            }
            if (fsPath == null) {
                fsPath = this.findInDyldData(refAddr, splitDyldCache);
            }
            if (fsPath != null) {
                ImporterUtilities.showAddToProgramDialog((FSRL)fs.getFSRL().appendPath(fsPath), (Program)program, (PluginTool)this.tool, (TaskMonitor)monitor);
            } else {
                Msg.showInfo((Object)((Object)this), null, (String)this.name, (Object)"Address %s not found in %s".formatted(refAddress, fs.toString()));
            }
        }
        catch (CancelledException fsRef2) {
        }
        catch (MachException | IOException e) {
            Msg.showError((Object)((Object)this), null, (String)this.name, (Object)e.getMessage(), (Throwable)e);
        }
    }

    private FileSystemRef openDyldCache(Program program, TaskMonitor monitor) throws IOException, CancelledException {
        FileSystemService fsService = FileSystemService.getInstance();
        Options props = program.getOptions("Program Information");
        String fsrlProp = props.getString("FSRL", null);
        if (fsrlProp == null) {
            throw new IOException("The program does not have an FSRL property");
        }
        FSRL fsrl = FSRL.fromString((String)fsrlProp);
        String requiredProtocol = "dyldcachev1";
        if (!fsrl.getFS().getProtocol().equals(requiredProtocol)) {
            throw new IOException("The program's FSRL protocol is '%s' but '%s' is required".formatted(fsrl.getFS().getProtocol(), requiredProtocol));
        }
        FSRLRoot fsrlRoot = fsrl.getFS();
        return fsService.getFilesystem(fsrlRoot, monitor);
    }

    private String findInDylibSegment(long addr, DyldCacheUtils.SplitDyldCache splitDyldCache) throws MachException, IOException {
        for (int i = 0; i < splitDyldCache.size(); ++i) {
            DyldCacheHeader dyldCacheHeader = splitDyldCache.getDyldCacheHeader(i);
            ByteProvider provider = splitDyldCache.getProvider(i);
            for (DyldCacheImage mappedImage : dyldCacheHeader.getMappedImages()) {
                MachHeader machHeader = new MachHeader(provider, mappedImage.getAddress() - dyldCacheHeader.getBaseAddress());
                for (SegmentCommand segment : machHeader.parseSegments()) {
                    if (!segment.contains(addr)) continue;
                    return mappedImage.getPath();
                }
            }
        }
        return null;
    }

    private String findInStubs(long addr, DyldCacheUtils.SplitDyldCache splitDyldCache) {
        for (int i = 0; i < splitDyldCache.size(); ++i) {
            String dyldCacheName = splitDyldCache.getName(i);
            DyldCacheHeader dyldCacheHeader = splitDyldCache.getDyldCacheHeader(i);
            for (DyldCacheMappingAndSlideInfo mappingInfo : dyldCacheHeader.getCacheMappingAndSlideInfos()) {
                if (!mappingInfo.contains(addr) || !mappingInfo.isTextStubs()) continue;
                return DyldCacheFileSystem.getStubPath(dyldCacheName);
            }
        }
        return null;
    }

    private String findInDyldData(long addr, DyldCacheUtils.SplitDyldCache splitDyldCache) {
        for (int i = 0; i < splitDyldCache.size(); ++i) {
            String dyldCacheName = splitDyldCache.getName(i);
            if (!dyldCacheName.endsWith(".dylddata")) continue;
            DyldCacheHeader dyldCacheHeader = splitDyldCache.getDyldCacheHeader(i);
            List mappingInfos = dyldCacheHeader.getCacheMappingAndSlideInfos();
            for (int j = 0; j < mappingInfos.size(); ++j) {
                DyldCacheMappingAndSlideInfo mappingInfo = (DyldCacheMappingAndSlideInfo)mappingInfos.get(j);
                if (!mappingInfo.contains(addr)) continue;
                return DyldCacheFileSystem.getDyldDataPath(dyldCacheName, j);
            }
        }
        return null;
    }
}

