/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.Field;
import ghidra.async.AsyncFence;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.model.JdiModelTargetField;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetReferenceType;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="FieldsContainer", elements={@TargetElementType(type=JdiModelTargetField.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetFieldContainer
extends JdiModelTargetObjectImpl {
    protected final JdiModelTargetReferenceType reftype;
    protected final Map<String, JdiModelTargetField> fieldsByName = new HashMap<String, JdiModelTargetField>();
    private boolean useAll;

    public JdiModelTargetFieldContainer(JdiModelTargetReferenceType reftype, boolean all) {
        super(reftype, all ? "Fields (All)" : "Fields");
        this.reftype = reftype;
        this.useAll = all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> updateUsingFields(Map<String, Field> byName) {
        List fields;
        JdiModelTargetFieldContainer jdiModelTargetFieldContainer = this;
        synchronized (jdiModelTargetFieldContainer) {
            fields = byName.values().stream().map(this::getTargetField).collect(Collectors.toList());
        }
        AsyncFence fence = new AsyncFence();
        for (JdiModelTargetField m : fields) {
            fence.include(m.init());
        }
        return fence.ready().thenAccept(__ -> this.changeElements(List.of(), fields, Map.of(), "Refreshed"));
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        List<Field> fields = this.useAll ? this.reftype.reftype.allFields() : this.reftype.reftype.fields();
        for (Field f : fields) {
            map.put(f.name(), f);
        }
        this.fieldsByName.keySet().retainAll(map.keySet());
        return this.updateUsingFields(map);
    }

    protected synchronized JdiModelTargetField getTargetField(Field var) {
        return this.fieldsByName.computeIfAbsent(var.name(), n -> (JdiModelTargetField)this.getInstance(var));
    }

    public synchronized JdiModelTargetField getTargetFieldIfPresent(String name) {
        return this.fieldsByName.get(name);
    }
}

