/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequestManager;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.manager.breakpoint.JdiBreakpointInfo;
import ghidra.dbg.jdi.model.JdiModelImpl;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetReferenceType;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Location", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Method", type=String.class, required=true, fixed=true), @TargetAttributeType(name="Line", type=Integer.class, required=true, fixed=true), @TargetAttributeType(name="Index", type=Long.class, required=true, fixed=true), @TargetAttributeType(name="Address", type=String.class, required=true, fixed=true), @TargetAttributeType(type=Object.class)})
public class JdiModelTargetLocation
extends JdiModelTargetObjectImpl {
    protected final Location location;
    private JdiModelTargetReferenceType declaringType;
    private Address address;

    public static String getUniqueId(Location obj) {
        return obj.toString() + ":" + obj.codeIndex();
    }

    public JdiModelTargetLocation(JdiModelTargetObject parent, Location location, boolean isElement) {
        super(parent, JdiModelTargetLocation.getUniqueId(location), location, isElement);
        this.location = location;
        this.impl.registerMethod(location.method());
        this.address = this.getAddress();
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay(), "Method", location.method().name(), "Line", location.lineNumber(), "Index", location.codeIndex(), "Address", Long.toHexString(this.address.getOffset())), "Initialized");
    }

    public CompletableFuture<Void> requestAttributes(DebuggerObjectModel.RefreshBehavior refresh) {
        this.declaringType = (JdiModelTargetReferenceType)this.getInstance(this.location.declaringType());
        this.changeAttributes(List.of(), List.of(), Map.of("Declaring Type", this.declaringType), "Initialized");
        try {
            String sourceName = this.location.sourceName();
            String sourcePath = this.location.sourcePath();
            this.changeAttributes(List.of(), List.of(), Map.of("Source Name", sourceName, "Source Path", sourcePath), "Initialized");
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> init() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public String getDisplay() {
        return this.location == null ? super.getDisplay() : this.location.toString() + " [" + Long.toHexString(this.address.getOffset()) + "]";
    }

    public Address getAddress() {
        if (this.address != null) {
            return this.address;
        }
        return JdiModelTargetLocation.getAddressFromLocation(this.impl, this.location);
    }

    public static Address getAddressFromLocation(JdiModelImpl impl, Location location) {
        AddressRange addressRange = impl.getAddressRange(location.method());
        if (addressRange == null) {
            return impl.getAddressSpace("ram").getAddress(-1L);
        }
        long codeIndex = location.codeIndex();
        return addressRange.getMinAddress().add(codeIndex < 0L ? 0L : codeIndex);
    }

    public JdiBreakpointInfo addBreakpoint() {
        EventRequestManager eventManager = this.location.virtualMachine().eventRequestManager();
        BreakpointRequest request = eventManager.createBreakpointRequest(this.location);
        request.enable();
        return new JdiBreakpointInfo(request);
    }
}

