/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Method;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.model.JdiModelTargetAttributesContainer;
import ghidra.dbg.jdi.model.JdiModelTargetLocalVariableContainer;
import ghidra.dbg.jdi.model.JdiModelTargetLocation;
import ghidra.dbg.jdi.model.JdiModelTargetLocationContainer;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetType;
import ghidra.dbg.jdi.model.JdiModelTargetTypeContainer;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Method", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Attributes", type=JdiModelTargetAttributesContainer.class), @TargetAttributeType(type=Object.class)})
public class JdiModelTargetMethod
extends JdiModelTargetObjectImpl {
    protected final Method method;
    private JdiModelTargetLocation location;
    private JdiModelTargetAttributesContainer addedAttributes;
    private JdiModelTargetTypeContainer argumentTypes;
    private JdiModelTargetLocalVariableContainer arguments;
    private JdiModelTargetLocationContainer locations;
    private JdiModelTargetLocalVariableContainer variables;
    private JdiModelTargetType returnType;

    public JdiModelTargetMethod(JdiModelTargetObject parent, Method method, boolean isElement) {
        super(parent, method.toString(), method, isElement);
        this.method = method;
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay()), "Initialized");
    }

    private void populateAttributes() {
        HashMap<String, Object> attrs;
        block2: {
            this.addedAttributes = new JdiModelTargetAttributesContainer(this, "Attributes");
            attrs = new HashMap<String, Object>();
            attrs.put("isAbstract", this.method.isAbstract());
            attrs.put("isBridge", this.method.isBridge());
            attrs.put("isStatic", this.method.isStatic());
            attrs.put("isConstructor", this.method.isConstructor());
            attrs.put("isDefault", this.method.isDefault());
            attrs.put("isFinal", this.method.isFinal());
            attrs.put("isNative", this.method.isNative());
            attrs.put("isObsolete", this.method.isObsolete());
            attrs.put("isStatic", this.method.isStatic());
            attrs.put("isStaticInitializer", this.method.isStaticInitializer());
            attrs.put("isSynchronized", this.method.isSynchronized());
            attrs.put("isSynthetic", this.method.isSynthetic());
            try {
                attrs.put("isPackagePrivate", this.method.isPackagePrivate());
                attrs.put("isPrivate", this.method.isPrivate());
                attrs.put("isProtected", this.method.isProtected());
                attrs.put("isPublic", this.method.isPublic());
            }
            catch (Exception e) {
                if (!(e instanceof ClassNotLoadedException)) break block2;
                attrs.put("status", "Class not loaded");
            }
        }
        this.addedAttributes.addAttributes(attrs);
    }

    public CompletableFuture<Void> requestAttributes(DebuggerObjectModel.RefreshBehavior refresh) {
        this.populateAttributes();
        this.changeAttributes(List.of(), List.of(this.addedAttributes), Map.of("Argument Types", this.method.argumentTypeNames(), "Return Type", this.method.returnTypeName()), "Initialized");
        JdiModelTargetLocation jdiModelTargetLocation = this.location = this.method.location() == null ? null : new JdiModelTargetLocation((JdiModelTargetObject)this.parent, this.method.location(), false);
        if (this.location != null) {
            this.changeAttributes(List.of(), List.of(this.location), Map.of(), "Initialized");
        }
        try {
            this.arguments = new JdiModelTargetLocalVariableContainer(this, "Arguments", this.method.arguments());
            if (this.arguments != null) {
                this.changeAttributes(List.of(), List.of(this.arguments), Map.of(), "Initialized");
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        try {
            this.argumentTypes = new JdiModelTargetTypeContainer(this, "Argument Types", this.method.argumentTypes());
            if (this.argumentTypes != null) {
                this.changeAttributes(List.of(), List.of(this.argumentTypes), Map.of(), "Initialized");
            }
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            // empty catch block
        }
        try {
            this.locations = new JdiModelTargetLocationContainer(this, "Locations", this.method.allLineLocations());
            if (this.locations != null) {
                this.changeAttributes(List.of(), List.of(this.locations), Map.of(), "Initialized");
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        try {
            this.returnType = (JdiModelTargetType)this.getInstance(this.method.returnType());
            if (this.returnType != null) {
                this.changeAttributes(List.of(), List.of(this.returnType), Map.of(), "Initialized");
            }
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            // empty catch block
        }
        try {
            this.variables = new JdiModelTargetLocalVariableContainer(this, "Variables", this.method.variables());
            if (this.variables != null) {
                this.changeAttributes(List.of(), List.of(this.variables), Map.of(), "Initialized");
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> init() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public String getDisplay() {
        return this.method == null ? super.getDisplay() : this.method.name();
    }
}

