/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;

public class ClangReturnType
extends ClangTokenGroup {
    private DataType datatype = null;
    private Varnode varnode = null;

    public ClangReturnType(ClangNode par) {
        super(par);
    }

    public DataType getDataType() {
        return this.datatype;
    }

    public Varnode getVarnode() {
        return this.varnode;
    }

    @Override
    public void decode(Decoder decoder, PcodeFactory pfactory) throws DecoderException {
        int attribId;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId != AttributeId.ATTRIB_VARREF.id()) continue;
            int refid = (int)decoder.readUnsignedInteger();
            this.varnode = pfactory.getRef(refid);
            if (this.varnode == null) break;
            if (this.varnode.getHigh() == null) {
                Msg.warn((Object)this, (Object)("VOID high variable problem at " + this.varnode.getAddress()));
                return;
            }
            this.datatype = this.varnode.getHigh().getDataType();
            break;
        }
        super.decode(decoder, pfactory);
    }
}

