/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.util.exception.NotFoundException;

public class Loongarch_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 258;
    }

    public RelocationResult relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        ElfHeader elf = elfRelocationContext.getElfHeader();
        if (!this.canRelocate(elf)) {
            return RelocationResult.FAILURE;
        }
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        boolean is32 = elf.is32Bit();
        int type = relocation.getType();
        if (0 == type) {
            return RelocationResult.SKIPPED;
        }
        long addend = relocation.hasAddend() ? relocation.getAddend() : (is32 ? (long)memory.getInt(relocationAddress) : memory.getLong(relocationAddress));
        long offset = relocationAddress.getOffset();
        long base = elfRelocationContext.getImageBaseWordAdjustmentOffset();
        int symbolIndex = relocation.getSymbolIndex();
        ElfSymbol sym = elfRelocationContext.getSymbol(symbolIndex);
        Address symbolAddr = elfRelocationContext.getSymbolAddress(sym);
        long symbolValue = elfRelocationContext.getSymbolValue(sym);
        String symbolName = elfRelocationContext.getSymbolName(symbolIndex);
        long value64 = 0L;
        int value32 = 0;
        short value16 = 0;
        byte value8 = 0;
        byte[] bytes24 = new byte[3];
        int byteLength = 4;
        switch (type) {
            case 1: {
                value32 = (int)(symbolValue + addend);
                memory.setInt(relocationAddress, value32);
                if (symbolIndex == 0 || addend == 0L || sym.isSection()) break;
                Loongarch_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                if (!elf.is32Bit()) break;
                Loongarch_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case 2: {
                value64 = symbolValue + addend;
                memory.setLong(relocationAddress, value64);
                byteLength = 8;
                if (symbolIndex == 0 || addend == 0L || sym.isSection()) break;
                Loongarch_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                if (!elf.is64Bit()) break;
                Loongarch_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case 3: {
                if (is32) {
                    value32 = (int)(base + addend);
                    memory.setInt(relocationAddress, value32);
                    break;
                }
                value64 = base + addend;
                memory.setLong(relocationAddress, value64);
                byteLength = 8;
                break;
            }
            case 4: {
                Loongarch_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_LARCH_COPY", (String)symbolName, (long)symbolIndex, (String)"Runtime copy not supported", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 5: {
                if (is32) {
                    value32 = (int)symbolValue;
                    memory.setInt(relocationAddress, value32);
                    break;
                }
                value64 = symbolValue;
                memory.setLong(relocationAddress, value64);
                byteLength = 8;
                break;
            }
            case 6: {
                Loongarch_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_LARCH_TLS_DTPMOD32", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not supported", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 7: {
                Loongarch_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_LARCH_TLS_DTPMOD64", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not supported", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 8: {
                Loongarch_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_LARCH_TLS_DTPREL32", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not supported", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 9: {
                Loongarch_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_LARCH_TLS_DTPREL64", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not supported", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 10: {
                Loongarch_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_LARCH_TLS_DTREL32", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not supported", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 11: {
                Loongarch_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_LARCH_TLS_TPREL64", (String)symbolName, (long)symbolIndex, (String)"Thread Local Symbol relocation not supported", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 12: {
                if (is32) {
                    value32 = (int)(addend + elfRelocationContext.getImageBaseWordAdjustmentOffset());
                    memory.setInt(relocationAddress, value32);
                    break;
                }
                byteLength = 8;
                value64 = addend + elfRelocationContext.getImageBaseWordAdjustmentOffset();
                memory.setLong(relocationAddress, value64);
                break;
            }
            case 47: {
                value8 = memory.getByte(relocationAddress);
                value8 = (byte)(value8 + (byte)symbolValue);
                value8 = (byte)(value8 + (byte)addend);
                memory.setByte(relocationAddress, value8);
                byteLength = 1;
                break;
            }
            case 48: {
                value16 = memory.getShort(relocationAddress);
                value16 = (short)(value16 + (short)symbolValue);
                value16 = (short)(value16 + (short)addend);
                memory.setShort(relocationAddress, value16);
                byteLength = 2;
                break;
            }
            case 49: {
                memory.getBytes(relocationAddress, bytes24);
                value32 = (bytes24[2] << 8) + bytes24[1] << 8 + bytes24[0];
                value32 += (int)symbolValue;
                bytes24[0] = (byte)(value32 += (int)addend);
                bytes24[1] = (byte)(value32 >> 8);
                bytes24[2] = (byte)(value32 >> 16);
                memory.setBytes(relocationAddress, bytes24);
                byteLength = 3;
                break;
            }
            case 50: {
                value32 = memory.getInt(relocationAddress);
                value32 += (int)symbolValue;
                memory.setInt(relocationAddress, value32 += (int)addend);
                break;
            }
            case 51: {
                value64 = memory.getLong(relocationAddress);
                value64 += symbolValue;
                memory.setLong(relocationAddress, value64 += addend);
                byteLength = 8;
                break;
            }
            case 52: {
                value8 = memory.getByte(relocationAddress);
                value8 = (byte)(value8 - (byte)symbolValue);
                value8 = (byte)(value8 - (byte)addend);
                memory.setByte(relocationAddress, value8);
                byteLength = 1;
                break;
            }
            case 53: {
                value16 = memory.getShort(relocationAddress);
                value16 = (short)(value16 - (short)symbolValue);
                value16 = (short)(value16 - (short)addend);
                memory.setShort(relocationAddress, value16);
                byteLength = 2;
                break;
            }
            case 54: {
                memory.getBytes(relocationAddress, bytes24);
                value32 = (bytes24[2] << 8) + bytes24[1] << 8 + bytes24[0];
                value32 -= (int)symbolValue;
                bytes24[0] = (byte)(value32 -= (int)addend);
                bytes24[1] = (byte)(value32 >> 8);
                bytes24[2] = (byte)(value32 >> 16);
                memory.setBytes(relocationAddress, bytes24);
                byteLength = 3;
                break;
            }
            case 55: {
                value32 = memory.getInt(relocationAddress);
                value32 -= (int)symbolValue;
                memory.setInt(relocationAddress, value32 -= (int)addend);
                break;
            }
            case 56: {
                value64 = memory.getLong(relocationAddress);
                value64 -= symbolValue;
                memory.setLong(relocationAddress, value64 -= addend);
                byteLength = 8;
                break;
            }
            default: {
                Loongarch_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

