/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler;

import ghidra.app.plugin.assembler.AssemblySemanticException;
import ghidra.app.plugin.assembler.AssemblySyntaxException;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseResult;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolutionResults;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.mem.MemoryAccessException;
import java.util.Collection;

public interface Assembler {
    public InstructionIterator assemble(Address var1, String ... var2) throws AssemblySyntaxException, AssemblySemanticException, MemoryAccessException, AddressOverflowException;

    public byte[] assembleLine(Address var1, String var2) throws AssemblySyntaxException, AssemblySemanticException;

    public byte[] assembleLine(Address var1, String var2, AssemblyPatternBlock var3) throws AssemblySemanticException, AssemblySyntaxException;

    public Collection<AssemblyParseResult> parseLine(String var1);

    public AssemblyResolutionResults resolveTree(AssemblyParseResult var1, Address var2, AssemblyPatternBlock var3);

    public AssemblyResolutionResults resolveTree(AssemblyParseResult var1, Address var2);

    public AssemblyResolutionResults resolveLine(Address var1, String var2) throws AssemblySyntaxException;

    public AssemblyResolutionResults resolveLine(Address var1, String var2, AssemblyPatternBlock var3) throws AssemblySyntaxException;

    public Instruction patchProgram(AssemblyResolvedPatterns var1, Address var2) throws MemoryAccessException;

    public InstructionIterator patchProgram(byte[] var1, Address var2) throws MemoryAccessException;

    public AssemblyPatternBlock getContextAt(Address var1);
}

