/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedBackfill;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyTreeResolver;
import ghidra.app.plugin.assembler.sleigh.util.DbgTimer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.set.AbstractSetDecorator;

public class AssemblyResolutionResults
extends AbstractSetDecorator<AssemblyResolution> {
    protected static final DbgTimer DBG = AssemblyTreeResolver.DBG;
    protected final Set<AssemblyResolution> resolutions;

    public AssemblyResolutionResults() {
        this.resolutions = new LinkedHashSet<AssemblyResolution>();
    }

    private AssemblyResolutionResults(Set<AssemblyResolution> resolutions) {
        this.resolutions = resolutions;
    }

    public static AssemblyResolutionResults singleton(AssemblyResolvedPatterns rc) {
        return new AssemblyResolutionResults(Collections.singleton(rc));
    }

    public boolean add(AssemblyResolution ar) {
        return this.resolutions.add(ar);
    }

    public void absorb(AssemblyResolutionResults that) {
        this.resolutions.addAll(that.resolutions);
    }

    public boolean addAll(Collection<? extends AssemblyResolution> c) {
        return this.resolutions.addAll(c);
    }

    public Set<AssemblyResolution> getResolutions() {
        return Collections.unmodifiableSet(this.resolutions);
    }

    protected Set<AssemblyResolution> decorated() {
        return this.getResolutions();
    }

    public boolean remove(AssemblyResolution ar) {
        return this.resolutions.remove(ar);
    }

    protected AssemblyResolutionResults apply(Applicator applicator) {
        AssemblyResolutionResults results = new AssemblyResolutionResults();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            AssemblyResolution res = (AssemblyResolution)iterator.next();
            if (res.isError()) {
                results.add(res);
                continue;
            }
            AssemblyResolvedPatterns rc = (AssemblyResolvedPatterns)res;
            DBG.println("Current: " + rc.lineToString());
            for (AssemblyResolution assemblyResolution : applicator.getPatterns(rc)) {
                DBG.println("Pattern: " + assemblyResolution.lineToString());
                AssemblyResolvedPatterns combined = applicator.combine(rc, assemblyResolution);
                DBG.println("Combined: " + (combined == null ? "(null)" : combined.lineToString()));
                if (combined == null) {
                    results.add(AssemblyResolution.error(applicator.describeError(rc, assemblyResolution), rc));
                    continue;
                }
                results.add(applicator.finish(combined));
            }
        }
        return results;
    }

    protected AssemblyResolutionResults apply(Function<AssemblyResolvedPatterns, AssemblyResolution> function) {
        return this.stream().map(res -> {
            assert (!(res instanceof AssemblyResolvedBackfill));
            if (res.isError()) {
                return res;
            }
            return (AssemblyResolution)function.apply((AssemblyResolvedPatterns)res);
        }).collect(Collectors.toCollection(AssemblyResolutionResults::new));
    }

    public static interface Applicator {
        public Iterable<? extends AssemblyResolution> getPatterns(AssemblyResolvedPatterns var1);

        default public AssemblyResolvedPatterns setDescription(AssemblyResolvedPatterns res, AssemblyResolution from) {
            AssemblyResolvedPatterns temp = res.withDescription(from.description);
            return temp;
        }

        default public AssemblyResolvedPatterns setRight(AssemblyResolvedPatterns res, AssemblyResolvedPatterns cur) {
            return res.withRight(cur);
        }

        default public AssemblyResolvedPatterns combineConstructor(AssemblyResolvedPatterns cur, AssemblyResolvedPatterns pat) {
            AssemblyResolvedPatterns combined = cur.combine(pat);
            if (combined == null) {
                return null;
            }
            return this.setRight(this.setDescription(combined, pat), cur);
        }

        default public AssemblyResolvedPatterns combineBackfill(AssemblyResolvedPatterns cur, AssemblyResolvedBackfill bf) {
            AssemblyResolvedPatterns combined = cur.combine(bf);
            return this.setRight(this.setDescription(combined, bf), cur);
        }

        default public AssemblyResolvedPatterns combine(AssemblyResolvedPatterns cur, AssemblyResolution pat) {
            if (pat.isError()) {
                throw new AssertionError();
            }
            if (pat.isBackfill()) {
                return this.combineBackfill(cur, (AssemblyResolvedBackfill)pat);
            }
            return this.combineConstructor(cur, (AssemblyResolvedPatterns)pat);
        }

        public String describeError(AssemblyResolvedPatterns var1, AssemblyResolution var2);

        default public AssemblyResolution finish(AssemblyResolvedPatterns resolved) {
            return resolved;
        }
    }
}

