/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.symbol;

import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNumericSymbols;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseToken;
import java.util.Collection;
import java.util.Collections;

public class AssemblyStringTerminal
extends AssemblyTerminal {
    protected final String str;

    public AssemblyStringTerminal(String str) {
        super("\"" + str + "\"");
        this.str = str;
    }

    @Override
    public String toString() {
        return "\"" + this.str + "\"";
    }

    public Collection<AssemblyParseToken> match(String buffer, int pos, AssemblyGrammar grammar, AssemblyNumericSymbols symbols) {
        if (buffer.regionMatches(pos, this.str, 0, this.str.length())) {
            return Collections.singleton(new AssemblyParseToken(grammar, this, this.str));
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<String> getSuggestions(String got, AssemblyNumericSymbols symbols) {
        return Collections.singleton(this.str);
    }

    @Override
    public boolean takesOperandIndex() {
        return false;
    }
}

