/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.semantics;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.error.LowlevelError;
import ghidra.pcodeCPort.semantics.HandleTpl;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.space.spacetype;
import ghidra.pcodeCPort.translate.Translate;
import ghidra.pcodeCPort.utils.XmlUtils;
import java.io.PrintStream;
import org.jdom.Element;

public class ConstTpl {
    private const_type type;
    private AddrSpace spaceid;
    private int handle_index;
    private long value_real;
    private v_field select;

    public String toString() {
        return "{type=" + this.type + " value_real=" + String.format("0x%x", this.value_real) + " spaceid=" + this.spaceid + "}";
    }

    public ConstTpl() {
        this.type = const_type.real;
        this.value_real = 0L;
    }

    public ConstTpl(ConstTpl op2) {
        this.type = op2.type;
        this.spaceid = op2.spaceid;
        this.handle_index = op2.handle_index;
        this.value_real = op2.value_real;
        this.select = op2.select;
    }

    public ConstTpl(const_type tp) {
        this.type = tp;
    }

    public ConstTpl(const_type tp, long val) {
        this.type = tp;
        this.value_real = val;
    }

    public ConstTpl(const_type tp, int ht, v_field vf) {
        this.type = const_type.handle;
        this.handle_index = ht;
        this.select = vf;
    }

    public ConstTpl(const_type tp, int ht, v_field vf, long plus) {
        this.type = const_type.handle;
        this.handle_index = ht;
        this.select = vf;
        this.value_real = plus;
    }

    public ConstTpl(AddrSpace sid) {
        this.type = const_type.spaceid;
        this.spaceid = sid;
    }

    public long getReal() {
        return this.value_real;
    }

    public AddrSpace getSpace() {
        return this.spaceid;
    }

    public int getHandleIndex() {
        return this.handle_index;
    }

    public const_type getType() {
        return this.type;
    }

    public v_field getSelect() {
        return this.select;
    }

    public boolean isZero() {
        return this.type == const_type.real && this.value_real == 0L;
    }

    public boolean isConstSpace() {
        if (this.type == const_type.spaceid) {
            return this.spaceid.getType() == spacetype.IPTR_CONSTANT;
        }
        return false;
    }

    public boolean isUniqueSpace() {
        if (this.type == const_type.spaceid) {
            return this.spaceid.getType() == spacetype.IPTR_INTERNAL;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConstTpl)) {
            return false;
        }
        ConstTpl op2 = (ConstTpl)obj;
        if (this.type != op2.type) {
            return false;
        }
        switch (this.type) {
            case real: {
                return this.value_real == op2.value_real;
            }
            case handle: {
                if (this.handle_index != op2.handle_index) {
                    return false;
                }
                if (this.select == op2.select) break;
                return false;
            }
            case spaceid: {
                return this.spaceid == op2.spaceid;
            }
        }
        return true;
    }

    public int compareTo(ConstTpl op2) {
        if (this.type != op2.type) {
            return this.type.ordinal() - op2.type.ordinal();
        }
        switch (this.type) {
            case real: {
                long diff = this.value_real - op2.value_real;
                return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
            }
            case handle: {
                if (this.handle_index != op2.handle_index) {
                    return this.handle_index - op2.handle_index;
                }
                return this.select.compareTo(op2.select);
            }
            case spaceid: {
                return this.spaceid.compareTo(op2.spaceid);
            }
        }
        return 0;
    }

    private void copyIntoMe(ConstTpl other) {
        this.type = other.type;
        this.spaceid = other.spaceid;
        this.handle_index = other.handle_index;
        this.value_real = other.value_real;
        this.select = other.select;
    }

    public void transfer(VectorSTL<HandleTpl> params) {
        if (this.type != const_type.handle) {
            return;
        }
        HandleTpl newhandle = (HandleTpl)params.get(this.handle_index);
        switch (this.select) {
            case v_space: {
                this.copyIntoMe(newhandle.getSpace());
                break;
            }
            case v_offset: {
                this.copyIntoMe(newhandle.getPtrOffset());
                break;
            }
            case v_size: {
                this.copyIntoMe(newhandle.getSize());
                break;
            }
            case v_offset_plus: {
                long tmp = this.value_real;
                this.copyIntoMe(newhandle.getPtrOffset());
                if (this.type == const_type.real) {
                    this.value_real += tmp & 0xFFFFL;
                    break;
                }
                if (this.type == const_type.handle && this.select == v_field.v_offset) {
                    this.select = v_field.v_offset_plus;
                    this.value_real = tmp;
                    break;
                }
                throw new LowlevelError("Cannot truncate macro input in this way");
            }
        }
    }

    private static void printHandleSelector(PrintStream s, v_field val) {
        switch (val) {
            case v_space: {
                s.append("space");
                break;
            }
            case v_offset: {
                s.append("offset");
                break;
            }
            case v_size: {
                s.append("size");
                break;
            }
            case v_offset_plus: {
                s.append("offset_plus");
            }
        }
    }

    private static v_field readHandleSelector(String name) {
        if (name.equals("space")) {
            return v_field.v_space;
        }
        if (name.equals("offset")) {
            return v_field.v_offset;
        }
        if (name.equals("size")) {
            return v_field.v_size;
        }
        if (name.equals("offset_plus")) {
            return v_field.v_offset_plus;
        }
        throw new LowlevelError("Bad handle selector");
    }

    public void changeHandleIndex(VectorSTL<Integer> handmap) {
        if (this.type == const_type.handle) {
            this.handle_index = (Integer)handmap.get(this.handle_index);
        }
    }

    public void saveXml(PrintStream s) {
        s.append("<const_tpl type=\"");
        switch (this.type) {
            case real: {
                s.append("real\" val=\"0x");
                s.append(Long.toHexString(this.value_real));
                s.append("\"/>");
                break;
            }
            case handle: {
                s.append("handle\" val=\"");
                s.print(this.handle_index);
                s.append("\" ");
                s.append("s=\"");
                ConstTpl.printHandleSelector(s, this.select);
                s.append('\"');
                if (this.select == v_field.v_offset_plus) {
                    s.append(" plus=\"0x").append(Long.toHexString(this.value_real)).append('\"');
                }
                s.append("/>");
                break;
            }
            case j_start: {
                s.append("start\"/>");
                break;
            }
            case j_next: {
                s.append("next\"/>");
                break;
            }
            case j_next2: {
                s.append("next2\"/>");
                break;
            }
            case j_curspace: {
                s.append("curspace\"/>");
                break;
            }
            case j_curspace_size: {
                s.append("curspace_size\"/>");
                break;
            }
            case spaceid: {
                s.append("spaceid\" name=\"");
                s.append(this.spaceid.getName());
                s.append("\"/>");
                break;
            }
            case j_relative: {
                s.append("relative\" val=\"0x");
                s.append(Long.toHexString(this.value_real));
                s.append("\"/>");
                break;
            }
            case j_flowref: {
                s.append("flowref\"/>");
                break;
            }
            case j_flowref_size: {
                s.append("flowref_size\"/>");
                break;
            }
            case j_flowdest: {
                s.append("flowdest\"/>");
                break;
            }
            case j_flowdest_size: {
                s.append("flowdest_size\"/>");
            }
        }
    }

    public void restoreXml(Element el, Translate trans) {
        String typestring = el.getAttributeValue("type");
        if (typestring.equals("real")) {
            this.type = const_type.real;
            this.value_real = XmlUtils.decodeUnknownLong(el.getAttributeValue("val"));
        } else if (typestring.equals("handle")) {
            this.type = const_type.handle;
            this.handle_index = XmlUtils.decodeUnknownInt(el.getAttributeValue("val"));
            this.select = ConstTpl.readHandleSelector(el.getAttributeValue("s"));
            if (this.select == v_field.v_offset_plus) {
                this.value_real = XmlUtils.decodeUnknownLong(el.getAttributeValue("plus"));
            }
        } else if (typestring.equals("start")) {
            this.type = const_type.j_start;
        } else if (typestring.equals("next")) {
            this.type = const_type.j_next;
        } else if (typestring.equals("next2")) {
            this.type = const_type.j_next2;
        } else if (typestring.equals("curspace")) {
            this.type = const_type.j_curspace;
        } else if (typestring.equals("curspace_size")) {
            this.type = const_type.j_curspace_size;
        } else if (typestring.equals("spaceid")) {
            this.type = const_type.spaceid;
            this.spaceid = trans.getSpaceByName(el.getAttributeValue("name"));
        } else if (typestring.equals("relative")) {
            this.type = const_type.j_relative;
            this.value_real = XmlUtils.decodeUnknownLong(el.getAttributeValue("val"));
        } else if (typestring.equals("flowref")) {
            this.type = const_type.j_flowref;
        } else if (typestring.equals("flowref_size")) {
            this.type = const_type.j_flowref_size;
        } else if (typestring.equals("flowdest")) {
            this.type = const_type.j_flowdest;
        } else if (typestring.equals("flowdest_size")) {
            this.type = const_type.j_flowdest_size;
        } else {
            throw new LowlevelError("Bad constant type");
        }
    }

    public static enum const_type {
        real,
        handle,
        j_start,
        j_next,
        j_next2,
        j_curspace,
        j_curspace_size,
        spaceid,
        j_relative,
        j_flowref,
        j_flowref_size,
        j_flowdest,
        j_flowdest_size;

    }

    public static enum v_field {
        v_space,
        v_offset,
        v_size,
        v_offset_plus;

    }
}

