/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghpatexpress.TokenPattern;
import ghidra.pcodeCPort.translate.Translate;
import ghidra.pcodeCPort.utils.Utils;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import org.jdom.Element;

public class ContextField
extends PatternValue {
    private int startbit;
    private int endbit;
    private int startbyte;
    private int endbyte;
    private int shift;
    private boolean signbit;

    public ContextField(Location location) {
        super(location);
    }

    public int getStartBit() {
        return this.startbit;
    }

    public int getEndBit() {
        return this.endbit;
    }

    public boolean getSignBit() {
        return this.signbit;
    }

    @Override
    public TokenPattern genMinPattern(VectorSTL<TokenPattern> ops) {
        return new TokenPattern(this.location);
    }

    @Override
    public long minValue() {
        return 0L;
    }

    @Override
    public long maxValue() {
        long res = 0L;
        res ^= 0xFFFFFFFFFFFFFFFFL;
        res = Utils.zzz_zero_extend(res, this.endbit - this.startbit);
        return res;
    }

    public ContextField(Location location, boolean s, int sbit, int ebit) {
        super(location);
        this.signbit = s;
        this.startbit = sbit;
        this.endbit = ebit;
        this.startbyte = this.startbit / 8;
        this.endbyte = this.endbit / 8;
        this.shift = 7 - this.endbit % 8;
    }

    public String toString() {
        return "cf:{" + this.startbit + "," + this.endbit + "," + this.startbyte + "," + this.endbyte + "," + this.shift + "," + this.signbit + "}";
    }

    @Override
    public TokenPattern genPattern(long val) {
        return new TokenPattern(this.location, val, this.startbit, this.endbit);
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<contextfield");
        s.append(" signbit=\"");
        if (this.signbit) {
            s.append("true\"");
        } else {
            s.append("false\"");
        }
        s.append(" startbit=\"");
        s.print(this.startbit);
        s.append("\"");
        s.append(" endbit=\"");
        s.print(this.endbit);
        s.append("\"");
        s.append(" startbyte=\"").print(this.startbyte);
        s.append("\"");
        s.append(" endbyte=\"").print(this.endbyte);
        s.append("\"");
        s.append(" shift=\"").print(this.shift);
        s.append("\"/>\n");
    }

    @Override
    public void restoreXml(Element el, Translate trans) {
        this.signbit = XmlUtils.decodeBoolean(el.getAttributeValue("signbit"));
        this.startbit = XmlUtils.decodeUnknownInt(el.getAttributeValue("startbit"));
        this.endbit = XmlUtils.decodeUnknownInt(el.getAttributeValue("endbit"));
        this.startbyte = XmlUtils.decodeUnknownInt(el.getAttributeValue("startbyte"));
        this.endbyte = XmlUtils.decodeUnknownInt(el.getAttributeValue("endbyte"));
        this.shift = XmlUtils.decodeUnknownInt(el.getAttributeValue("shift"));
    }
}

