/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.OverlaySpaceDBAdapter;
import ghidra.program.database.ProgramAddressFactory;
import ghidra.program.database.ProgramOverlayAddressSpace;
import ghidra.program.database.util.EmptyRecordIterator;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.util.LanguageTranslator;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

class OverlaySpaceDBAdapterV1
extends OverlaySpaceDBAdapter {
    private static final int VERSION = 1;
    static final Schema SCHEMA_V1 = new Schema(1, "ID", new Field[]{StringField.INSTANCE, StringField.INSTANCE}, new String[]{"Overlay Space Name", "Base Space Name"});
    static final int OV_SPACE_NAME_COL_V1 = 0;
    static final int OV_SPACE_BASE_COL_V1 = 1;

    OverlaySpaceDBAdapterV1(DBHandle dbHandle, int openMode) throws IOException, VersionException {
        super(dbHandle);
        Table table = dbHandle.getTable(TABLE_NAME);
        if (openMode == 0) {
            if (table != null) {
                throw new IOException("Table already exists: " + TABLE_NAME);
            }
            return;
        }
        if (table != null && table.getSchema().getVersion() != 1) {
            int version = table.getSchema().getVersion();
            if (version < 1) {
                throw new VersionException(true);
            }
            throw new VersionException(2, false);
        }
    }

    @Override
    ProgramOverlayAddressSpace createOverlaySpace(ProgramAddressFactory factory, String spaceName, AddressSpace baseSpace) throws IOException, DuplicateNameException, InvalidNameException {
        if (!factory.isValidOverlayBaseSpace(baseSpace)) {
            throw new IllegalArgumentException("Invalid address space for overlay: " + baseSpace.getName());
        }
        factory.checkValidOverlaySpaceName(spaceName);
        if (factory.getAddressSpace(spaceName) != null) {
            throw new DuplicateNameException("Overlay space '" + spaceName + "' duplicates name of another address space");
        }
        Table table = this.db.getTable(TABLE_NAME);
        if (table == null) {
            table = this.db.createTable(TABLE_NAME, SCHEMA_V1);
        }
        DBRecord rec = SCHEMA_V1.createRecord(table.getKey());
        rec.setString(0, spaceName);
        rec.setString(1, baseSpace.getName());
        table.putRecord(rec);
        return factory.addOverlaySpace(rec.getKey(), spaceName, baseSpace);
    }

    @Override
    protected RecordIterator getOverlayRecords() throws IOException {
        Table table = this.db.getTable(TABLE_NAME);
        if (table == null) {
            return EmptyRecordIterator.INSTANCE;
        }
        return table.iterator();
    }

    @Override
    protected void updateOverlayRecord(DBRecord rec) throws IOException {
        Table table = this.db.getTable(TABLE_NAME);
        if (table == null) {
            table = this.db.createTable(TABLE_NAME, SCHEMA_V1);
        }
        table.putRecord(rec);
    }

    @Override
    boolean removeOverlaySpace(String name) throws IOException {
        Table table = this.db.getTable(TABLE_NAME);
        if (table == null) {
            return false;
        }
        RecordIterator it = table.iterator();
        while (it.hasNext()) {
            DBRecord rec = it.next();
            String overlayName = rec.getString(0);
            if (!name.equals(overlayName)) continue;
            it.delete();
            return true;
        }
        return false;
    }

    @Override
    boolean renameOverlaySpace(String oldName, String newName) throws IOException {
        Table table = this.db.getTable(TABLE_NAME);
        if (table == null) {
            return false;
        }
        RecordIterator it = table.iterator();
        while (it.hasNext()) {
            DBRecord rec = it.next();
            String spaceName = rec.getString(0);
            if (!oldName.equals(spaceName)) continue;
            it.delete();
            rec.setString(0, newName);
            table.putRecord(rec);
            return true;
        }
        return false;
    }

    @Override
    void updateOverlaySpaces(ProgramAddressFactory factory) throws IOException {
        HashMap<Long, DBRecord> keyToRecordMap = new HashMap<Long, DBRecord>();
        Table table = this.db.getTable(TABLE_NAME);
        if (table != null) {
            for (Object rec : table) {
                keyToRecordMap.put(rec.getKey(), (DBRecord)rec);
            }
        }
        ArrayList<ProgramOverlayAddressSpace> renameList = new ArrayList<ProgramOverlayAddressSpace>();
        for (DBRecord space : factory.getAllAddressSpaces()) {
            if (!(space instanceof ProgramOverlayAddressSpace)) continue;
            ProgramOverlayAddressSpace os = (ProgramOverlayAddressSpace)space;
            String name = os.getName();
            DBRecord rec = (DBRecord)keyToRecordMap.get(os.getKey());
            if (rec == null || !this.isCompatibleOverlay(os, rec, factory)) {
                factory.removeOverlaySpace(name);
                continue;
            }
            if (name.equals(rec.getString(0))) {
                keyToRecordMap.remove(os.getKey());
                continue;
            }
            renameList.add(os);
            factory.removeOverlaySpace(name);
        }
        try {
            Object rec;
            for (ProgramOverlayAddressSpace existingSpace : renameList) {
                long key = existingSpace.getKey();
                DBRecord rec2 = (DBRecord)keyToRecordMap.get(key);
                existingSpace.setName(rec2.getString(0));
                factory.addOverlaySpace(existingSpace);
                keyToRecordMap.remove(key);
            }
            rec = keyToRecordMap.keySet().iterator();
            while (rec.hasNext()) {
                long key = (Long)rec.next();
                DBRecord rec3 = (DBRecord)keyToRecordMap.get(key);
                String spaceName = rec3.getString(0);
                AddressSpace baseSpace = factory.getAddressSpace(rec3.getString(1));
                factory.addOverlaySpace(key, spaceName, baseSpace);
            }
        }
        catch (DuplicateNameException | IllegalArgumentException e) {
            throw new AssertionError("Unexpected error updating overlay address spaces", e);
        }
        factory.refreshStaleOverlayStatus();
    }

    private boolean isCompatibleOverlay(ProgramOverlayAddressSpace os, DBRecord rec, ProgramAddressFactory factory) throws IOException {
        String baseSpaceName = rec.getString(1);
        AddressSpace baseSpace = factory.getAddressSpace(baseSpaceName);
        if (baseSpace == null) {
            throw new IOException("Base space for overlay not found: " + baseSpaceName);
        }
        return baseSpace == os.getOverlayedSpace();
    }

    @Override
    void setLanguage(Language newLanguage, ProgramAddressFactory addrFactory, LanguageTranslator translator) throws IOException {
        Table table = this.db.getTable(TABLE_NAME);
        if (table != null) {
            for (DBRecord rec : table) {
                String oldUnderlyingSpaceName = rec.getString(1);
                AddressSpace space = addrFactory.getAddressSpace(oldUnderlyingSpaceName);
                if (space != null && space.isNonLoadedMemorySpace()) continue;
                AddressSpace newSpace = translator.getNewAddressSpace(oldUnderlyingSpaceName);
                if (newSpace == null) {
                    throw new IOException("Failed to map old address space: " + oldUnderlyingSpaceName);
                }
                rec.setString(1, newSpace.getName());
                table.putRecord(rec);
            }
        }
        this.initializeOverlaySpaces(addrFactory);
    }
}

