/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.bookmark;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.Table;
import db.util.ErrorHandler;
import generic.util.MultiIterator;
import generic.util.WrappingPeekableIterator;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.bookmark.BookmarkDB;
import ghidra.program.database.bookmark.BookmarkDBAdapter;
import ghidra.program.database.bookmark.BookmarkDBAdapterV0;
import ghidra.program.database.bookmark.BookmarkTypeDB;
import ghidra.program.database.bookmark.BookmarkTypeDBAdapter;
import ghidra.program.database.bookmark.BookmarkTypeDBAdapterNoTable;
import ghidra.program.database.bookmark.OldBookmark;
import ghidra.program.database.bookmark.OldBookmarkManager;
import ghidra.program.database.map.AddressIndexPrimaryKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.util.DatabaseTableUtils;
import ghidra.program.database.util.EmptyRecordIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.BookmarkType;
import ghidra.program.model.listing.Program;
import ghidra.util.Lock;
import ghidra.util.datastruct.ObjectArray;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.ClosedException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;

public class BookmarkDBManager
implements BookmarkManager,
ErrorHandler,
ManagerDB {
    private ProgramDB program;
    private AddressMap addrMap;
    private BookmarkTypeDBAdapter bookmarkTypeAdapter;
    private BookmarkDBAdapter bookmarkAdapter;
    private DBObjectCache<BookmarkDB> cache;
    private boolean upgrade = false;
    private Map<String, BookmarkType> typesByName = new TreeMap<String, BookmarkType>();
    private ObjectArray typesArray = new ObjectArray();
    private Lock lock;

    public BookmarkDBManager(DBHandle handle, AddressMap addrMap, int openMode, Lock lock, TaskMonitor monitor) throws VersionException, IOException {
        this.addrMap = addrMap;
        this.lock = lock;
        this.upgrade = openMode == 3;
        this.bookmarkTypeAdapter = BookmarkTypeDBAdapter.getAdapter(handle, openMode);
        int[] types = this.bookmarkTypeAdapter.getTypeIds();
        this.bookmarkAdapter = BookmarkDBAdapter.getAdapter(handle, openMode, types, addrMap, monitor);
        this.cache = new DBObjectCache(100);
    }

    @Override
    public void setProgram(ProgramDB program) {
        if (this.program != null) {
            throw new AssertException();
        }
        this.program = program;
        try {
            DBRecord[] typeRecords;
            if (this.upgrade) {
                this.upgradeOldBookmarks(program);
            } else if (this.bookmarkTypeAdapter instanceof BookmarkTypeDBAdapterNoTable && this.bookmarkAdapter instanceof BookmarkDBAdapterV0) {
                OldBookmarkManager oldMgr = new OldBookmarkManager(program);
                ((BookmarkTypeDBAdapterNoTable)this.bookmarkTypeAdapter).setOldBookmarkManager(oldMgr);
                ((BookmarkDBAdapterV0)this.bookmarkAdapter).setOldBookmarkManager(oldMgr, this.addrMap, TaskMonitor.DUMMY);
            }
            for (DBRecord rec : typeRecords = this.bookmarkTypeAdapter.getRecords()) {
                int typeId = (int)rec.getKey();
                BookmarkTypeDB type = new BookmarkTypeDB(typeId, rec.getString(0));
                type.setHasBookmarks(true);
                this.typesByName.put(type.getTypeString(), type);
                this.typesArray.put(typeId, (Object)type);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    @Override
    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
    }

    public void dbError(IOException e) {
        this.program.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        this.lock.acquire();
        try {
            this.cache.invalidate();
            this.bookmarkAdapter.reloadTables();
            this.refreshBookmarkTypes();
        }
        finally {
            this.lock.release();
        }
    }

    private void refreshBookmarkTypes() {
        for (BookmarkTypeDB bookmarkTypeDB : this.typesByName.values()) {
            bookmarkTypeDB.setHasBookmarks(this.bookmarkAdapter.hasTable(bookmarkTypeDB.getTypeId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bookmarkChanged(BookmarkDB bm) {
        this.lock.acquire();
        try {
            DBRecord rec = bm.getRecord();
            if (rec != null) {
                this.bookmarkAdapter.updateRecord(rec);
                Address addr = bm.getAddress();
                this.program.setObjChanged(124, addr, (Object)bm, null, null);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    private void upgradeOldBookmarks(ProgramDB programDB) {
        OldBookmarkManager oldMgr = new OldBookmarkManager(programDB);
        DBRecord[] oldTypes = oldMgr.getTypeRecords();
        if (oldTypes.length == 0) {
            return;
        }
        for (DBRecord oldType : oldTypes) {
            String type = oldType.getString(0);
            AddressIterator iter = oldMgr.getBookmarkAddresses(type);
            while (iter.hasNext()) {
                OldBookmark bm = oldMgr.getBookmark(iter.next(), type);
                this.setBookmark(bm.getAddress(), type, bm.getCategory(), bm.getComment());
            }
            oldMgr.removeAllBookmarks(type);
        }
    }

    private BookmarkTypeDB getBookmarkType(String type, boolean create) throws IOException {
        BookmarkTypeDB bmt = (BookmarkTypeDB)this.typesByName.get(type);
        if (bmt == null) {
            int typeId = this.findNextTypeId();
            bmt = new BookmarkTypeDB(typeId, type);
            this.typesByName.put(type, bmt);
            this.typesArray.put(typeId, (Object)bmt);
        }
        if (create && !bmt.hasBookmarks()) {
            this.bookmarkTypeAdapter.addType(bmt.getTypeId(), bmt.getTypeString());
            bmt.setHasBookmarks(true);
            this.bookmarkAdapter.addType(bmt.getTypeId());
            this.program.setObjChanged(120, bmt, null, null);
        }
        return bmt;
    }

    private int findNextTypeId() {
        int n = this.typesArray.getLastNonEmptyIndex() + 2;
        for (int i = 0; i < n; ++i) {
            if (this.typesArray.get(i) != null) continue;
            return i;
        }
        return n;
    }

    BookmarkTypeDB getBookmarkType(int typeID) {
        return (BookmarkTypeDB)this.typesArray.get(typeID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BookmarkType defineType(String type, Icon icon, Color color, int priority) {
        this.lock.acquire();
        try {
            String validatedType = StringUtils.trim((String)type);
            if (StringUtils.isBlank((CharSequence)validatedType) || icon == null || color == null) {
                throw new IllegalArgumentException("Invalid bookmark type parameters were specified");
            }
            BookmarkTypeDB bmt = null;
            try {
                bmt = this.getBookmarkType(validatedType, false);
                bmt.setIcon(icon);
                bmt.setMarkerColor(color);
                bmt.setMarkerPriority(priority);
            }
            catch (IOException e) {
                this.dbError(e);
            }
            BookmarkTypeDB bookmarkTypeDB = bmt;
            return bookmarkTypeDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BookmarkType[] getBookmarkTypes() {
        this.lock.acquire();
        try {
            Collection<BookmarkType> c = this.typesByName.values();
            BookmarkType[] bmTypes = new BookmarkTypeDB[c.size()];
            c.toArray(bmTypes);
            BookmarkType[] bookmarkTypeArray = bmTypes;
            return bookmarkTypeArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    @Override
    public BookmarkType getBookmarkType(String type) {
        return this.typesByName.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bookmark setBookmark(Address addr, String type, String category, String comment) {
        this.lock.acquire();
        try {
            BookmarkTypeDB bmt = this.getBookmarkType(type, true);
            int typeId = bmt.getTypeId();
            BookmarkDB bm = (BookmarkDB)this.getBookmark(addr, type, category);
            if (bm != null) {
                bm.setComment(comment);
            } else {
                DBRecord rec = this.bookmarkAdapter.createBookmark(typeId, category, this.addrMap.getKey(addr, true), comment);
                bm = new BookmarkDB(this, this.cache, rec);
                this.program.setObjChanged(122, addr, (Object)bm, null, null);
            }
            BookmarkDB bookmarkDB = bm;
            return bookmarkDB;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    private BookmarkDB getBookmark(DBRecord bookmarkRecord) {
        BookmarkDB bm = this.cache.get(bookmarkRecord);
        if (bm == null) {
            bm = new BookmarkDB(this, this.cache, bookmarkRecord);
        }
        return bm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bookmark getBookmark(Address addr, String type, String category) {
        block7: {
            this.lock.acquire();
            try {
                BookmarkTypeDB bmt = this.getBookmarkType(type, false);
                if (bmt == null || !bmt.hasBookmarks() || category == null) break block7;
                int typeId = bmt.getTypeId();
                RecordIterator iter = this.bookmarkAdapter.getRecordsByTypeAtAddress(typeId, this.addrMap.getKey(addr, false));
                while (iter.hasNext()) {
                    DBRecord rec = iter.next();
                    String cat = rec.getString(1);
                    if (!category.equals(cat)) continue;
                    BookmarkDB bookmarkDB = this.getBookmark(rec);
                    return bookmarkDB;
                }
            }
            catch (IOException e) {
                this.dbError(e);
            }
            finally {
                this.lock.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBookmark(Bookmark bookmark) {
        this.lock.acquire();
        try {
            if (bookmark instanceof BookmarkDB) {
                BookmarkDB bm = (BookmarkDB)bookmark;
                BookmarkTypeDB type = (BookmarkTypeDB)bm.getType();
                int typeId = type.getTypeId();
                this.doRemoveBookmark(bm);
                if (this.bookmarkAdapter.getBookmarkCount(typeId) == 0) {
                    this.removeBookmarks(type.getTypeString());
                }
            }
        }
        finally {
            this.lock.release();
        }
    }

    private void doRemoveBookmark(BookmarkDB bm) {
        Address addr = bm.getAddress();
        bm.setInvalid();
        try {
            this.bookmarkAdapter.deleteRecord(bm.getId());
            this.program.setObjChanged(123, addr, (Object)bm, null, null);
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBookmarks(String type) {
        this.lock.acquire();
        try {
            try {
                BookmarkTypeDB bmt = (BookmarkTypeDB)this.typesByName.get(type);
                if (bmt.hasBookmarks()) {
                    int typeId = bmt.getTypeId();
                    this.bookmarkAdapter.deleteType(typeId);
                    this.bookmarkTypeAdapter.deleteRecord(typeId);
                    bmt.setHasBookmarks(false);
                    this.program.setObjChanged(121, bmt, null, null);
                }
            }
            catch (IOException e) {
                this.dbError(e);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBookmarks(String type, String category, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            BookmarkType bmt = this.getBookmarkType(type);
            if (bmt == null || !bmt.hasBookmarks()) {
                return;
            }
            RecordIterator iter = this.bookmarkAdapter.getRecordsByTypeAndCategory(bmt.getTypeId(), category);
            while (iter.hasNext()) {
                DBRecord rec = iter.next();
                BookmarkDB bm = this.getBookmark(rec);
                this.removeBookmark(bm);
                monitor.checkCancelled();
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    Address getAddress(long index) {
        return this.addrMap.decodeAddress(index);
    }

    DBRecord getRecord(long id) {
        DBRecord rec = null;
        try {
            rec = this.bookmarkAdapter.getRecord(id);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        return rec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bookmark[] getBookmarks(Address addr) {
        this.lock.acquire();
        try {
            int n = this.typesArray.getLastNonEmptyIndex();
            ArrayList<Bookmark> list = new ArrayList<Bookmark>();
            for (int i = 0; i <= n; ++i) {
                BookmarkTypeDB bmt = (BookmarkTypeDB)this.typesArray.get(i);
                if (bmt == null || !bmt.hasBookmarks()) continue;
                this.getBookmarks(addr, i, list);
            }
            Bookmark[] bookmarks = new Bookmark[list.size()];
            list.toArray(bookmarks);
            Bookmark[] bookmarkArray = bookmarks;
            return bookmarkArray;
        }
        finally {
            this.lock.release();
        }
    }

    private void getBookmarks(Address addr, int typeId, List<Bookmark> list) {
        if (typeId < 0) {
            return;
        }
        try {
            RecordIterator iter = this.bookmarkAdapter.getRecordsByTypeAtAddress(typeId, this.addrMap.getKey(addr, false));
            while (iter.hasNext()) {
                DBRecord rec = iter.next();
                list.add(this.getBookmark(rec));
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bookmark[] getBookmarks(Address address, String type) {
        this.lock.acquire();
        try {
            Bookmark[] bookmarks = null;
            ArrayList<Bookmark> list = new ArrayList<Bookmark>();
            BookmarkType bmt = this.getBookmarkType(type);
            if (bmt != null && bmt.hasBookmarks()) {
                this.getBookmarks(address, bmt.getTypeId(), list);
            }
            bookmarks = new Bookmark[list.size()];
            list.toArray(bookmarks);
            Bookmark[] bookmarkArray = bookmarks;
            return bookmarkArray;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasBookmarks(String type) {
        this.lock.acquire();
        try {
            BookmarkType bmt = this.getBookmarkType(type);
            if (bmt == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = bmt.hasBookmarks();
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getCategories(String type) {
        this.lock.acquire();
        try {
            BookmarkType bmt = this.getBookmarkType(type);
            if (bmt == null || !bmt.hasBookmarks()) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            String[] stringArray = this.bookmarkAdapter.getCategories(bmt.getTypeId());
            return stringArray;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressSetView getBookmarkAddresses(String type) {
        this.lock.acquire();
        try {
            BookmarkType bmt = this.getBookmarkType(type);
            if (bmt == null || !bmt.hasBookmarks()) {
                AddressSet addressSet = new AddressSet();
                return addressSet;
            }
            AddressSetView addressSetView = this.bookmarkAdapter.getBookmarkAddresses(bmt.getTypeId());
            return addressSetView;
        }
        finally {
            this.lock.release();
        }
    }

    private Iterator<Bookmark> getBookmarksIterator(BookmarkType bmt) {
        EmptyRecordIterator it;
        try {
            it = bmt != null && bmt.hasBookmarks() ? this.bookmarkAdapter.getRecordsByType(bmt.getTypeId()) : new EmptyRecordIterator();
        }
        catch (IOException e) {
            this.program.dbError(e);
            it = new EmptyRecordIterator();
        }
        return new BookmarkRecordIterator(it);
    }

    private Iterator<Bookmark> getBookmarksIterator(Address startAddress, BookmarkType bmt, boolean forward) {
        EmptyRecordIterator it;
        try {
            it = bmt != null && bmt.hasBookmarks() ? this.bookmarkAdapter.getRecordsByTypeStartingAtAddress(bmt.getTypeId(), this.addrMap.getKey(startAddress, false), forward) : new EmptyRecordIterator();
        }
        catch (IOException e) {
            this.program.dbError(e);
            it = new EmptyRecordIterator();
        }
        return new BookmarkRecordIterator(it, forward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bookmark getBookmark(long id) {
        BookmarkDB bookmarkDB;
        this.lock.acquire();
        try {
            BookmarkDB bm = this.cache.get(id);
            if (bm == null) {
                DBRecord record = this.bookmarkAdapter.getRecord(id);
                if (record == null) {
                    Bookmark bookmark = null;
                    return bookmark;
                }
                bm = new BookmarkDB(this, this.cache, record);
            }
            bookmarkDB = bm;
            return bookmarkDB;
        }
        catch (ClosedException e) {
            bookmarkDB = null;
            return bookmarkDB;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    @Override
    public int getBookmarkCount() {
        this.lock.acquire();
        try {
            int n = this.bookmarkAdapter.getBookmarkCount();
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBookmarkCount(String type) {
        this.lock.acquire();
        try {
            BookmarkType bmt = this.getBookmarkType(type);
            if (bmt == null) {
                int n = 0;
                return n;
            }
            int n = this.bookmarkAdapter.getBookmarkCount(bmt.getTypeId());
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Iterator<Bookmark> getBookmarksIterator(String type) {
        BookmarkType bmt = this.getBookmarkType(type);
        return this.getBookmarksIterator(bmt);
    }

    @Override
    public Iterator<Bookmark> getBookmarksIterator(Address startAddress, boolean forward) {
        ArrayList<WrappingPeekableIterator> list = new ArrayList<WrappingPeekableIterator>();
        int n = this.typesArray.getLastNonEmptyIndex();
        for (int i = 0; i <= n; ++i) {
            BookmarkTypeDB bmt = (BookmarkTypeDB)this.typesArray.get(i);
            if (bmt == null || !bmt.hasBookmarks()) continue;
            Iterator<Bookmark> bookmarksIterator = this.getBookmarksIterator(startAddress, bmt, forward);
            list.add(new WrappingPeekableIterator(bookmarksIterator));
        }
        return new MultiIterator(list, forward);
    }

    @Override
    public Iterator<Bookmark> getBookmarksIterator() {
        this.lock.acquire();
        try {
            TotalIterator totalIterator = new TotalIterator();
            return totalIterator;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBookmarks(AddressSetView set, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            for (BookmarkTypeDB bookmarkTypeDB : this.typesByName.values()) {
                if (!bookmarkTypeDB.hasBookmarks()) continue;
                this.removeBookmarks(set, bookmarkTypeDB, null, monitor);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBookmarks(AddressSetView set, String type, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            BookmarkTypeDB bmt = (BookmarkTypeDB)this.getBookmarkType(type);
            if (bmt != null && bmt.hasBookmarks()) {
                this.removeBookmarks(set, bmt, null, monitor);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBookmarks(AddressSetView set, String type, String category, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            BookmarkTypeDB bmt = (BookmarkTypeDB)this.getBookmarkType(type);
            if (bmt != null && bmt.hasBookmarks()) {
                this.removeBookmarks(set, bmt, category, monitor);
            }
        }
        finally {
            this.lock.release();
        }
    }

    private void removeBookmarks(AddressSetView set, BookmarkTypeDB bmt, String category, TaskMonitor monitor) throws CancelledException {
        int typeId = bmt.getTypeId();
        try {
            Table table = this.bookmarkAdapter.getTable(typeId);
            if (table != null) {
                AddressIndexPrimaryKeyIterator it = new AddressIndexPrimaryKeyIterator(table, 0, this.addrMap, set, true);
                while (it.hasNext()) {
                    BookmarkDB bm = (BookmarkDB)this.getBookmark(it.next().getLongValue());
                    if (category == null || category.equals(bm.getCategory())) {
                        this.doRemoveBookmark(bm);
                    }
                    monitor.checkCancelled();
                }
                if (this.bookmarkAdapter.getBookmarkCount(typeId) == 0) {
                    this.removeBookmarks(bmt.getTypeString());
                }
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    @Override
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
        this.removeBookmarks(new AddressSet(startAddr, endAddr), monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            this.cache.invalidate();
            for (BookmarkTypeDB bookmarkTypeDB : this.typesByName.values()) {
                Table table;
                int typeId = bookmarkTypeDB.getTypeId();
                if (!bookmarkTypeDB.hasBookmarks() || (table = this.bookmarkAdapter.getTable(typeId)) == null) continue;
                int addrCol = 0;
                try {
                    DatabaseTableUtils.updateIndexedAddressField(table, addrCol, this.addrMap, fromAddr, toAddr, length, null, monitor);
                }
                catch (IOException e) {
                    this.dbError(e);
                }
            }
        }
        finally {
            this.lock.release();
        }
    }

    private class BookmarkRecordIterator
    implements Iterator<Bookmark> {
        private RecordIterator it;
        private Bookmark nextBookmark;
        private boolean forward;

        BookmarkRecordIterator(RecordIterator it) {
            this(it, true);
        }

        BookmarkRecordIterator(RecordIterator it, boolean forward) {
            this.it = it;
            this.forward = forward;
        }

        @Override
        public boolean hasNext() {
            if (this.nextBookmark == null) {
                this.findNext();
            }
            return this.nextBookmark != null;
        }

        private void findNext() {
            BookmarkDBManager.this.lock.acquire();
            try {
                while (this.nextBookmark == null && (this.forward ? this.it.hasNext() : this.it.hasPrevious())) {
                    DBRecord record = this.forward ? this.it.next() : this.it.previous();
                    this.nextBookmark = BookmarkDBManager.this.getBookmark(record);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                BookmarkDBManager.this.lock.release();
            }
        }

        @Override
        public Bookmark next() {
            if (this.hasNext()) {
                Bookmark ret = this.nextBookmark;
                this.nextBookmark = null;
                return ret;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class TotalIterator
    implements Iterator<Bookmark> {
        Iterator<BookmarkTypeDB> typeIt;
        Iterator<Bookmark> bookmarkIt;

        TotalIterator() {
            ArrayList<BookmarkTypeDB> list = new ArrayList<BookmarkTypeDB>();
            int n = BookmarkDBManager.this.typesArray.getLastNonEmptyIndex();
            for (int i = 0; i <= n; ++i) {
                BookmarkTypeDB bmt = (BookmarkTypeDB)BookmarkDBManager.this.typesArray.get(i);
                if (bmt == null || !bmt.hasBookmarks()) continue;
                list.add(bmt);
            }
            this.typeIt = list.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.bookmarkIt != null && this.bookmarkIt.hasNext()) {
                return true;
            }
            while (this.typeIt.hasNext()) {
                this.bookmarkIt = BookmarkDBManager.this.getBookmarksIterator(this.typeIt.next());
                if (this.bookmarkIt == null || !this.bookmarkIt.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Bookmark next() {
            return this.hasNext() ? this.bookmarkIt.next() : null;
        }

        @Override
        public void remove() {
            this.bookmarkIt.remove();
        }
    }
}

