/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import ghidra.program.database.mem.BitMappedSubMemoryBlock;
import ghidra.program.database.mem.ByteMappedSubMemoryBlock;
import ghidra.program.database.mem.ByteMappingScheme;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.database.mem.FileBytesSubMemoryBlock;
import ghidra.program.database.mem.SubMemoryBlock;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import java.util.Optional;

class MemoryBlockSourceInfoDB
implements MemoryBlockSourceInfo {
    private final MemoryBlock block;
    private final SubMemoryBlock subBlock;

    MemoryBlockSourceInfoDB(MemoryBlock block, SubMemoryBlock subBlock) {
        this.block = block;
        this.subBlock = subBlock;
    }

    @Override
    public long getLength() {
        return this.subBlock.subBlockLength;
    }

    @Override
    public Address getMinAddress() {
        return this.block.getStart().add(this.subBlock.subBlockOffset);
    }

    @Override
    public Address getMaxAddress() {
        return this.block.getStart().add(this.subBlock.subBlockOffset + this.subBlock.subBlockLength - 1L);
    }

    @Override
    public String getDescription() {
        return this.subBlock.getDescription();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": StartAddress = " + this.getMinAddress() + ", length = " + this.getLength();
    }

    @Override
    public Optional<FileBytes> getFileBytes() {
        if (this.subBlock instanceof FileBytesSubMemoryBlock) {
            return Optional.of(((FileBytesSubMemoryBlock)this.subBlock).getFileBytes());
        }
        return Optional.empty();
    }

    @Override
    public long getFileBytesOffset() {
        if (this.subBlock instanceof FileBytesSubMemoryBlock) {
            return ((FileBytesSubMemoryBlock)this.subBlock).getFileBytesOffset();
        }
        return -1L;
    }

    @Override
    public long getFileBytesOffset(Address address) {
        if (this.subBlock instanceof FileBytesSubMemoryBlock && this.contains(address)) {
            long subBlockOffset = address.subtract(this.getMinAddress());
            return ((FileBytesSubMemoryBlock)this.subBlock).getFileBytesOffset() + subBlockOffset;
        }
        return -1L;
    }

    @Override
    public Optional<AddressRange> getMappedRange() {
        if (this.subBlock instanceof BitMappedSubMemoryBlock) {
            BitMappedSubMemoryBlock bitMapped = (BitMappedSubMemoryBlock)this.subBlock;
            return Optional.of(bitMapped.getMappedRange());
        }
        if (this.subBlock instanceof ByteMappedSubMemoryBlock) {
            ByteMappedSubMemoryBlock byteMapped = (ByteMappedSubMemoryBlock)this.subBlock;
            return Optional.of(byteMapped.getMappedRange());
        }
        return Optional.empty();
    }

    @Override
    public Optional<ByteMappingScheme> getByteMappingScheme() {
        if (this.subBlock instanceof ByteMappedSubMemoryBlock) {
            ByteMappedSubMemoryBlock byteMapped = (ByteMappedSubMemoryBlock)this.subBlock;
            return Optional.of(byteMapped.getByteMappingScheme());
        }
        return Optional.empty();
    }

    @Override
    public MemoryBlock getMemoryBlock() {
        return this.block;
    }

    @Override
    public boolean contains(Address address) {
        return address.compareTo(this.getMinAddress()) >= 0 && address.compareTo(this.getMaxAddress()) <= 0;
    }
}

