/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.util.ErrorHandler;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressKeyAddressIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.EquateDB;
import ghidra.program.database.symbol.EquateDBAdapter;
import ghidra.program.database.symbol.EquateRefDB;
import ghidra.program.database.symbol.EquateRefDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.EmptyAddressIterator;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateReference;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.util.EquateInfo;
import ghidra.util.Lock;
import ghidra.util.UniversalID;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class EquateManager
implements EquateTable,
ErrorHandler,
ManagerDB {
    private AddressMap addrMap;
    private DBObjectCache<EquateRefDB> refCache;
    private DBObjectCache<EquateDB> equateCache;
    private EquateDBAdapter equateAdapter;
    private EquateRefDBAdapter refAdapter;
    private ProgramDB program;
    private Lock lock;
    public static final String DATATYPE_TAG = "dtID";
    public static final String ERROR_TAG = "<BAD EQUATE>";
    public static final String FORMAT_DELIMITER = ":";

    public EquateManager(DBHandle handle, AddressMap addrMap, int openMode, Lock lock, TaskMonitor monitor) throws VersionException, IOException {
        this.addrMap = addrMap;
        this.lock = lock;
        this.initializeAdapters(handle, openMode, monitor);
        this.refCache = new DBObjectCache(100);
        this.equateCache = new DBObjectCache(100);
    }

    ProgramDB getProgram() {
        return this.program;
    }

    private void initializeAdapters(DBHandle handle, int openMode, TaskMonitor monitor) throws VersionException, IOException {
        VersionException versionExc = null;
        try {
            this.equateAdapter = EquateDBAdapter.getAdapter(handle, openMode, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.refAdapter = EquateRefDBAdapter.getAdapter(handle, openMode, this.addrMap, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        if (versionExc != null) {
            throw versionExc;
        }
    }

    @Override
    public void setProgram(ProgramDB program) {
        this.program = program;
    }

    @Override
    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
    }

    public void dbError(IOException e) {
        this.program.dbError(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Equate createEquate(String name, long value) throws DuplicateNameException, InvalidInputException {
        this.lock.acquire();
        try {
            if (this.equateAdapter.hasRecord(name)) {
                throw new DuplicateNameException(name + " already exists for an equate.");
            }
            this.validateName(name);
            DBRecord record = this.equateAdapter.createEquate(name, value);
            EquateDB equate = new EquateDB(this, this.equateCache, record);
            this.program.setChanged(70, new EquateInfo(name, value, null, 0, 0L), null);
            EquateDB equateDB = equate;
            return equateDB;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Equate getEquate(Address reference, int opIndex, long scalarValue) {
        this.lock.acquire();
        try {
            Field[] keys;
            long refAddr = this.addrMap.getKey(reference, false);
            if (refAddr == -1L) {
                Equate equate = null;
                return equate;
            }
            for (Field key : keys = this.refAdapter.getRecordKeysForAddr(refAddr)) {
                EquateDB equate;
                EquateRefDB ref = this.getEquateRefDB(key.getLongValue());
                if (ref.getOpIndex() != opIndex || (equate = this.getEquateDB(ref.getEquateID())).getValue() != scalarValue) continue;
                EquateDB equateDB = equate;
                return equateDB;
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Equate> getEquates(Address reference, int opIndex) {
        LinkedList<Equate> ret = new LinkedList<Equate>();
        this.lock.acquire();
        try {
            Field[] keys;
            long refAddr = this.addrMap.getKey(reference, false);
            if (refAddr == -1L) {
                LinkedList<Equate> linkedList = ret;
                return linkedList;
            }
            for (Field key : keys = this.refAdapter.getRecordKeysForAddr(refAddr)) {
                EquateRefDB ref = this.getEquateRefDB(key.getLongValue());
                if (ref.getOpIndex() != opIndex) continue;
                ret.add(this.getEquateDB(ref.getEquateID()));
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Equate> getEquates(Address reference) {
        LinkedList<Equate> ret = new LinkedList<Equate>();
        this.lock.acquire();
        try {
            Field[] keys;
            long refAddr = this.addrMap.getKey(reference, false);
            if (refAddr == -1L) {
                LinkedList<Equate> linkedList = ret;
                return linkedList;
            }
            for (Field key : keys = this.refAdapter.getRecordKeysForAddr(refAddr)) {
                EquateRefDB ref = this.getEquateRefDB(key.getLongValue());
                ret.add(this.getEquateDB(ref.getEquateID()));
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Equate getEquate(String name) {
        this.lock.acquire();
        try {
            long equateID = this.equateAdapter.getRecordKey(name);
            EquateDB equateDB = this.getEquateDB(equateID);
            return equateDB;
        }
        catch (NotFoundException equateID) {
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    @Override
    public AddressIterator getEquateAddresses() {
        try {
            return new AddressKeyAddressIterator(this.refAdapter.getIteratorForAddresses(), true, this.addrMap, this);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return new EmptyAddressIterator();
        }
    }

    @Override
    public AddressIterator getEquateAddresses(Address startAddr) {
        try {
            return new AddressKeyAddressIterator(this.refAdapter.getIteratorForAddresses(startAddr), true, this.addrMap, this);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return new EmptyAddressIterator();
        }
    }

    private AddressIterator getEquateAddresses(Address startAddr, Address endAddr) {
        try {
            return new AddressKeyAddressIterator(this.refAdapter.getIteratorForAddresses(startAddr, endAddr), true, this.addrMap, this);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return new EmptyAddressIterator();
        }
    }

    @Override
    public AddressIterator getEquateAddresses(AddressSetView set) {
        try {
            return new AddressKeyAddressIterator(this.refAdapter.getIteratorForAddresses(set), true, this.addrMap, this);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return new EmptyAddressIterator();
        }
    }

    @Override
    public Iterator<Equate> getEquates() {
        try {
            RecordIterator iter = this.equateAdapter.getRecords();
            return new EquateIterator(iter);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return new EquateIterator(null);
        }
    }

    @Override
    public List<Equate> getEquates(long value) {
        ArrayList<Equate> list = new ArrayList<Equate>();
        try {
            RecordIterator iter = this.equateAdapter.getRecords();
            while (iter.hasNext()) {
                DBRecord rec = iter.next();
                EquateDB equateDB = this.getEquateDB(rec.getKey());
                if (equateDB.getValue() != value) continue;
                list.add(equateDB);
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            ArrayList<EquateRefDB> list = new ArrayList<EquateRefDB>();
            AddressIterator iter = this.getEquateAddresses(startAddr, endAddr);
            while (iter.hasNext()) {
                Field[] keys;
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                Address addr = iter.next();
                for (Field key : keys = this.refAdapter.getRecordKeysForAddr(this.addrMap.getKey(addr, false))) {
                    EquateRefDB ref = this.getEquateRefDB(key.getLongValue());
                    list.add(ref);
                }
            }
            for (EquateRefDB ref : list) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                EquateDB equateDB = this.getEquateDB(ref.getEquateID());
                this.removeRef(equateDB, ref);
                if (this.getReferenceCount(equateDB.getKey()) != 0) continue;
                this.removeEquate(equateDB);
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEquate(String name) {
        if (name == null) {
            return false;
        }
        this.lock.acquire();
        try {
            EquateDB equateDB = (EquateDB)this.getEquate(name);
            if (equateDB != null) {
                long equateID = equateDB.getKey();
                this.removeReferences(equateID);
                this.removeEquate(equateDB);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEquate(EquateDB equateDB) throws IOException {
        this.lock.acquire();
        try {
            String name = equateDB.getName();
            long equateID = equateDB.getKey();
            this.equateAdapter.removeRecord(equateID);
            this.equateCache.delete(equateID);
            this.program.setChanged(71, name, null);
        }
        finally {
            this.lock.release();
        }
    }

    AddressMap getAddressMap() {
        return this.addrMap;
    }

    EquateDBAdapter getEquateDatabaseAdapter() {
        return this.equateAdapter;
    }

    EquateRefDBAdapter getRefDatabaseAdapter() {
        return this.refAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addReference(long equateID, Address address, int opIndex, long dynamicHash) throws IOException {
        this.lock.acquire();
        try {
            Field[] keys;
            EquateDB equateDB = this.getEquateDB(equateID);
            String name = equateDB.getName();
            long value = equateDB.getValue();
            long addr = this.addrMap.getKey(address, true);
            for (Field key : keys = this.refAdapter.getRecordKeysForAddr(addr)) {
                EquateRefDB ref = this.getEquateRefDB(key.getLongValue());
                if (dynamicHash != 0L) {
                    if (ref.getDynamicHashValue() != dynamicHash) continue;
                    this.removeRef(equateDB, ref);
                    continue;
                }
                if (ref.getDynamicHashValue() != 0L || ref.getOpIndex() != opIndex) continue;
                this.removeRef(equateDB, ref);
            }
            DBRecord record = this.refAdapter.createReference(addr, (short)opIndex, dynamicHash, equateID);
            new EquateRefDB(this, this.refCache, record);
            this.program.setChanged(72, address, address, new EquateInfo(name, value, address, opIndex, dynamicHash), null);
        }
        finally {
            this.lock.release();
        }
    }

    EquateRefDB[] getReferences(long equateID) throws IOException {
        Field[] keys = this.refAdapter.getRecordKeysForEquateID(equateID);
        EquateRefDB[] refs = new EquateRefDB[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            refs[i] = this.getEquateRefDB(keys[i].getLongValue());
        }
        return refs;
    }

    int getReferenceCount(long equateID) throws IOException {
        return this.getReferences(equateID).length;
    }

    List<EquateReference> getReferences(long equateID, Address reference) throws IOException {
        Field[] keys;
        ArrayList<EquateReference> refs = new ArrayList<EquateReference>();
        long refAddr = this.addrMap.getKey(reference, false);
        if (refAddr == -1L) {
            return refs;
        }
        for (Field key : keys = this.refAdapter.getRecordKeysForAddr(refAddr)) {
            EquateRefDB ref = this.getEquateRefDB(key.getLongValue());
            if (ref.getEquateID() != equateID) continue;
            refs.add(ref);
        }
        return refs;
    }

    void removeReference(EquateDB equateDB, Address refAddr, short opIndex) throws IOException {
        Field[] keys;
        for (Field key : keys = this.refAdapter.getRecordKeysForEquateID(equateDB.getKey())) {
            EquateRefDB ref = this.getEquateRefDB(key.getLongValue());
            if (ref.getOpIndex() != opIndex || !ref.getAddress().equals(refAddr)) continue;
            this.removeRef(equateDB, ref);
            break;
        }
    }

    void removeReference(EquateDB equateDB, long dynamicHash, Address refAddr) throws IOException {
        Field[] keys;
        for (Field key : keys = this.refAdapter.getRecordKeysForEquateID(equateDB.getKey())) {
            EquateRefDB ref = this.getEquateRefDB(key.getLongValue());
            if (ref.getDynamicHashValue() != dynamicHash || !ref.getAddress().equals(refAddr)) continue;
            this.removeRef(equateDB, ref);
            break;
        }
    }

    void validateName(String name) throws InvalidInputException {
        if (name == null) {
            throw new InvalidInputException("Name is null");
        }
        if ((name = name.trim()).length() == 0) {
            throw new InvalidInputException("Name is empty string.");
        }
    }

    void equateNameChanged(String oldName, String newName) {
        this.program.setChanged(74, oldName, newName);
    }

    DBRecord getEquateRecord(long equateID) {
        try {
            return this.equateAdapter.getRecord(equateID);
        }
        catch (IOException e) {
            this.dbError(e);
            return null;
        }
    }

    DBRecord getEquateRefRecord(long refID) {
        try {
            return this.refAdapter.getRecord(refID);
        }
        catch (IOException e) {
            this.dbError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRef(EquateDB equateDB, EquateRefDB ref) throws IOException {
        this.lock.acquire();
        try {
            long key = ref.getKey();
            this.refAdapter.removeRecord(key);
            this.refCache.delete(key);
            this.referenceRemoved(equateDB, ref.getAddress(), ref.getOpIndex(), ref.getDynamicHashValue());
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EquateDB getEquateDB(long equateID) throws IOException {
        this.lock.acquire();
        try {
            DBRecord record;
            EquateDB equateDB = this.equateCache.get(equateID);
            if (equateDB == null && (record = this.equateAdapter.getRecord(equateID)) != null) {
                equateDB = new EquateDB(this, this.equateCache, record);
            }
            EquateDB equateDB2 = equateDB;
            return equateDB2;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EquateRefDB getEquateRefDB(long key) throws IOException {
        this.lock.acquire();
        try {
            EquateRefDB ref = this.refCache.get(key);
            if (ref == null) {
                DBRecord record = this.refAdapter.getRecord(key);
                ref = new EquateRefDB(this, this.refCache, record);
            }
            EquateRefDB equateRefDB = ref;
            return equateRefDB;
        }
        finally {
            this.lock.release();
        }
    }

    private void removeReferences(long equateID) throws IOException {
        Field[] keys;
        EquateDB equateDB = this.getEquateDB(equateID);
        for (Field key : keys = this.refAdapter.getRecordKeysForEquateID(equateID)) {
            EquateRefDB ref = this.getEquateRefDB(key.getLongValue());
            this.removeRef(equateDB, ref);
        }
    }

    private void referenceRemoved(EquateDB equateDB, Address refAddr, short opIndex, long dynamichash) {
        this.program.setChanged(73, refAddr, refAddr, new EquateInfo(equateDB.getName(), equateDB.getValue(), refAddr, opIndex, dynamichash), null);
    }

    Lock getLock() {
        return this.lock;
    }

    @Override
    public void invalidateCache(boolean all) {
        this.lock.acquire();
        try {
            this.refCache.invalidate();
            this.equateCache.invalidate();
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            this.invalidateCache(true);
            this.refAdapter.moveAddressRange(fromAddr, toAddr, length, monitor);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    public static String formatNameForEquate(UniversalID dtID, long equateValue) {
        return "dtID:" + dtID.getValue() + FORMAT_DELIMITER + equateValue;
    }

    public static String formatNameForEquateError(long equateValue) {
        return "0x" + Long.toString(equateValue, 16) + " <BAD EQUATE>";
    }

    public static UniversalID getDataTypeUUID(String formattedEquateName) {
        if (formattedEquateName.startsWith(DATATYPE_TAG)) {
            return new UniversalID(Long.parseLong(formattedEquateName.split(FORMAT_DELIMITER)[1]));
        }
        return null;
    }

    public static long getEquateValueFromFormattedName(String formattedEquateName) {
        if (formattedEquateName.startsWith(DATATYPE_TAG)) {
            return Long.parseLong(formattedEquateName.split(FORMAT_DELIMITER)[2]);
        }
        return -1L;
    }

    private class EquateIterator
    implements Iterator<Equate> {
        private RecordIterator iter;

        private EquateIterator(RecordIterator iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            if (this.iter != null) {
                try {
                    return this.iter.hasNext();
                }
                catch (IOException e) {
                    EquateManager.this.program.dbError(e);
                }
            }
            return false;
        }

        @Override
        public Equate next() {
            if (this.iter != null) {
                try {
                    DBRecord record = this.iter.next();
                    if (record != null) {
                        return EquateManager.this.getEquateDB(record.getKey());
                    }
                }
                catch (IOException e) {
                    EquateManager.this.program.dbError(e);
                }
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported.");
        }
    }
}

