/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.util.ErrorHandler;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.VariableStorageDBAdapter;
import ghidra.program.database.symbol.VariableStorageManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.util.LanguageTranslator;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakValueHashMap;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public class VariableStorageManagerDB
implements VariableStorageManager {
    private ProgramArchitecture arch;
    private Lock lock;
    private ErrorHandler errorHandler;
    private VariableStorageDBAdapter adapter;
    private DBObjectCache<MyVariableStorage> cache = new DBObjectCache(256);
    private WeakValueHashMap<Long, MyVariableStorage> cacheMap = new WeakValueHashMap(256);

    public VariableStorageManagerDB(DBHandle handle, AddressMap addrMap, int openMode, ErrorHandler errorHandler, Lock lock, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        this.errorHandler = errorHandler;
        this.lock = lock;
        this.adapter = VariableStorageDBAdapter.getAdapter(handle, openMode, addrMap, monitor);
    }

    public void setProgramArchitecture(ProgramArchitecture arch) {
        this.arch = arch;
    }

    public static void delete(DBHandle dbHandle) throws IOException {
        dbHandle.deleteTable("Variable Storage");
    }

    public static boolean exists(DBHandle dbHandle) {
        return dbHandle.getTable("Variable Storage") != null;
    }

    void invalidateCache(boolean all) {
        this.cache.invalidate();
        this.cacheMap.clear();
    }

    private MyVariableStorage getMyVariableStorage(Address variableAddr) throws IOException {
        if (!variableAddr.isVariableAddress()) {
            throw new IllegalArgumentException("Address is not a VariableAddress: " + variableAddr);
        }
        MyVariableStorage varStore = this.cache.get(variableAddr.getOffset());
        if (varStore != null) {
            return varStore;
        }
        DBRecord rec = this.adapter.getRecord(variableAddr.getOffset());
        if (rec == null) {
            return null;
        }
        varStore = new MyVariableStorage(this.cache, rec);
        this.cacheMap.put((Object)varStore.getLongHash(), (Object)varStore);
        return varStore;
    }

    List<Varnode> getStorageVarnodes(Address variableAddr) throws IOException {
        if (!variableAddr.isVariableAddress()) {
            throw new IllegalArgumentException();
        }
        DBRecord rec = this.adapter.getRecord(variableAddr.getOffset());
        if (rec == null) {
            return null;
        }
        try {
            return VariableStorage.getVarnodes(this.arch.getAddressFactory(), rec.getString(1));
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)("Invalid variable storage: " + e.getMessage()));
            return null;
        }
    }

    VariableStorage getVariableStorage(Address variableAddr) throws IOException {
        MyVariableStorage myStorage = this.getMyVariableStorage(variableAddr);
        if (myStorage != null) {
            return myStorage.getVariableStorage();
        }
        return null;
    }

    @Override
    public Address getVariableStorageAddress(VariableStorage storage, boolean create) throws IOException {
        long key;
        long hash = storage.getLongHash();
        MyVariableStorage myStorage = (MyVariableStorage)this.cacheMap.get((Object)hash);
        if (myStorage != null) {
            key = myStorage.getKey();
            if (this.cache.get(key) == null) {
                key = -1L;
            }
        } else {
            key = this.adapter.findRecordKey(hash);
        }
        if (key == -1L) {
            if (!create) {
                return null;
            }
            key = this.adapter.getNextStorageID();
            DBRecord rec = VariableStorageDBAdapter.VARIABLE_STORAGE_SCHEMA.createRecord(key);
            rec.setLongValue(0, storage.getLongHash());
            rec.setString(1, storage.getSerializationString());
            this.adapter.updateRecord(rec);
            myStorage = new MyVariableStorage(this.cache, rec);
            this.cacheMap.put((Object)hash, (Object)myStorage);
        }
        return AddressSpace.VARIABLE_SPACE.getAddress(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguage(LanguageTranslator translator, TaskMonitor monitor) throws CancelledException {
        monitor.initialize((long)this.adapter.getRecordCount());
        int cnt = 0;
        this.lock.acquire();
        try {
            RecordIterator recIter = this.adapter.getRecords();
            while (recIter.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = recIter.next();
                String serialization = rec.getString(1);
                try {
                    serialization = VariableStorage.translateSerialization(translator, serialization);
                    rec.setString(1, serialization);
                    this.adapter.updateRecord(rec);
                }
                catch (InvalidInputException e) {
                    continue;
                }
                monitor.setProgress((long)(++cnt));
            }
        }
        catch (IOException e) {
            this.errorHandler.dbError(e);
        }
        finally {
            this.invalidateCache(true);
            this.lock.release();
        }
    }

    private class MyVariableStorage
    extends DatabaseObject {
        private VariableStorage storage;
        private DBRecord record;

        private MyVariableStorage(DBObjectCache<MyVariableStorage> cache, DBRecord record) {
            super(cache, record.getKey());
            this.record = record;
            try {
                this.storage = VariableStorage.deserialize(VariableStorageManagerDB.this.arch, record.getString(1));
            }
            catch (InvalidInputException e) {
                this.storage = VariableStorage.BAD_STORAGE;
            }
        }

        VariableStorage getVariableStorage() {
            VariableStorageManagerDB.this.lock.acquire();
            try {
                this.checkIsValid();
                VariableStorage variableStorage = this.storage;
                return variableStorage;
            }
            finally {
                VariableStorageManagerDB.this.lock.release();
            }
        }

        long getLongHash() {
            return this.storage.getLongHash();
        }

        @Override
        protected boolean refresh() {
            block9: {
                VariableStorageManagerDB.this.lock.acquire();
                try {
                    this.storage = VariableStorage.BAD_STORAGE;
                    if (this.record == null) break block9;
                    DBRecord rec = VariableStorageManagerDB.this.adapter.getRecord(this.key);
                    if (rec == null) {
                        boolean bl = false;
                        return bl;
                    }
                    this.record = rec;
                    try {
                        this.storage = VariableStorage.deserialize(VariableStorageManagerDB.this.arch, this.record.getString(1));
                    }
                    catch (InvalidInputException invalidInputException) {
                        // empty catch block
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (IOException e) {
                    VariableStorageManagerDB.this.errorHandler.dbError(e);
                }
                finally {
                    VariableStorageManagerDB.this.lock.release();
                }
            }
            return false;
        }
    }
}

