/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.SwingUtilities;

public class DataTypeManagerChangeListenerHandler
implements DataTypeManagerChangeListener {
    private transient WeakSet<DataTypeManagerChangeListener> listenerList = WeakDataStructureFactory.createCopyOnReadWeakSet();

    public void addDataTypeManagerListener(DataTypeManagerChangeListener l) {
        this.listenerList.add((Object)l);
    }

    public void removeDataTypeManagerListener(DataTypeManagerChangeListener l) {
        this.listenerList.remove((Object)l);
    }

    @Override
    public void categoryAdded(DataTypeManager dtm, CategoryPath path) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        this.invokeRunnable(() -> {
            for (DataTypeManagerChangeListener listener : this.listenerList) {
                listener.categoryAdded(dtm, path);
            }
        });
    }

    @Override
    public void categoryMoved(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        this.invokeRunnable(() -> {
            for (DataTypeManagerChangeListener listener : this.listenerList) {
                listener.categoryMoved(dtm, oldPath, newPath);
            }
        });
    }

    @Override
    public void categoryRemoved(DataTypeManager dtm, CategoryPath path) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        this.invokeRunnable(() -> {
            for (DataTypeManagerChangeListener listener : this.listenerList) {
                listener.categoryRemoved(dtm, path);
            }
        });
    }

    @Override
    public void categoryRenamed(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        this.invokeRunnable(() -> {
            for (DataTypeManagerChangeListener listener : this.listenerList) {
                listener.categoryRenamed(dtm, oldPath, newPath);
            }
        });
    }

    @Override
    public void dataTypeAdded(DataTypeManager dtm, DataTypePath path) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        this.invokeRunnable(() -> {
            for (DataTypeManagerChangeListener listener : this.listenerList) {
                listener.dataTypeAdded(dtm, path);
            }
        });
    }

    @Override
    public void dataTypeChanged(DataTypeManager dtm, DataTypePath path) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        this.invokeRunnable(() -> {
            for (DataTypeManagerChangeListener listener : this.listenerList) {
                listener.dataTypeChanged(dtm, path);
            }
        });
    }

    @Override
    public void dataTypeMoved(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        this.invokeRunnable(() -> {
            for (DataTypeManagerChangeListener listener : this.listenerList) {
                listener.dataTypeMoved(dtm, oldPath, newPath);
            }
        });
    }

    @Override
    public void dataTypeRemoved(DataTypeManager dtm, DataTypePath path) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        this.invokeRunnable(() -> {
            for (DataTypeManagerChangeListener listener : this.listenerList) {
                listener.dataTypeRemoved(dtm, path);
            }
        });
    }

    @Override
    public void dataTypeRenamed(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        this.invokeRunnable(() -> {
            for (DataTypeManagerChangeListener listener : this.listenerList) {
                listener.dataTypeRenamed(dtm, oldPath, newPath);
                listener.favoritesChanged(dtm, oldPath, false);
            }
        });
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.listenerList = WeakDataStructureFactory.createCopyOnReadWeakSet();
    }

    private void invokeRunnable(Runnable r) {
        SwingUtilities.invokeLater(r);
    }

    @Override
    public void dataTypeReplaced(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath, DataType newDataType) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        this.invokeRunnable(() -> {
            for (DataTypeManagerChangeListener listener : this.listenerList) {
                listener.dataTypeReplaced(dtm, oldPath, newPath, newDataType);
            }
        });
    }

    @Override
    public void favoritesChanged(DataTypeManager dtm, DataTypePath path, boolean isFavorite) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        this.invokeRunnable(() -> {
            for (DataTypeManagerChangeListener listener : this.listenerList) {
                listener.favoritesChanged(dtm, path, isFavorite);
            }
        });
    }

    @Override
    public void sourceArchiveChanged(DataTypeManager dataTypeManager, SourceArchive dataTypeSource) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        this.invokeRunnable(() -> {
            for (DataTypeManagerChangeListener listener : this.listenerList) {
                listener.sourceArchiveChanged(dataTypeManager, dataTypeSource);
            }
        });
    }

    @Override
    public void sourceArchiveAdded(DataTypeManager dataTypeManager, SourceArchive dataTypeSource) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        this.invokeRunnable(() -> {
            for (DataTypeManagerChangeListener listener : this.listenerList) {
                listener.sourceArchiveAdded(dataTypeManager, dataTypeSource);
            }
        });
    }

    @Override
    public void programArchitectureChanged(DataTypeManager dataTypeManager) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        this.invokeRunnable(() -> {
            for (DataTypeManagerChangeListener listener : this.listenerList) {
                listener.programArchitectureChanged(dataTypeManager);
            }
        });
    }
}

