/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.mem.MemBuffer;

public class EndianSettingsDefinition
implements EnumSettingsDefinition {
    private static final String[] choices = new String[]{"default", "little", "big"};
    private static final String ENDIAN_SETTING_NAME = "endian";
    public static final EndianSettingsDefinition DEF;
    public static final EndianSettingsDefinition ENDIAN;
    public static final int DEFAULT = 0;
    public static final int LITTLE = 1;
    public static final int BIG = 2;

    private EndianSettingsDefinition() {
    }

    public boolean isBigEndian(Settings settings, MemBuffer buf) {
        int val = this.getChoice(settings);
        if (val == 0) {
            return buf.isBigEndian();
        }
        return val == 2;
    }

    public Endian getEndianess(Settings settings, Endian defaultValue) {
        int val = this.getChoice(settings);
        switch (val) {
            default: {
                return defaultValue;
            }
            case 2: {
                return Endian.BIG;
            }
            case 1: 
        }
        return Endian.LITTLE;
    }

    public void setBigEndian(Settings settings, boolean isBigEndian) {
        this.setChoice(settings, isBigEndian ? 2 : 1);
    }

    public int getChoice(Settings settings) {
        if (settings == null) {
            return 0;
        }
        Long value = settings.getLong(ENDIAN_SETTING_NAME);
        if (value == null) {
            return 0;
        }
        int val = value.intValue();
        if (val < 0 || val > 2) {
            val = 0;
        }
        return val;
    }

    public String getValueString(Settings settings) {
        return choices[this.getChoice(settings)];
    }

    public void setChoice(Settings settings, int value) {
        settings.setLong(ENDIAN_SETTING_NAME, (long)value);
    }

    public String[] getDisplayChoices(Settings settings) {
        return choices;
    }

    public String getName() {
        return "Endian";
    }

    public String getStorageKey() {
        return ENDIAN_SETTING_NAME;
    }

    public String getDescription() {
        return "Selects the endianess of the data";
    }

    public String getDisplayChoice(int value, Settings settings) {
        return choices[value];
    }

    public void clear(Settings settings) {
        settings.clearSetting(ENDIAN_SETTING_NAME);
    }

    public void copySetting(Settings settings, Settings destSettings) {
        Long l = settings.getLong(ENDIAN_SETTING_NAME);
        if (l == null) {
            destSettings.clearSetting(ENDIAN_SETTING_NAME);
        } else {
            destSettings.setLong(ENDIAN_SETTING_NAME, l.longValue());
        }
    }

    public boolean hasValue(Settings setting) {
        return setting.getValue(ENDIAN_SETTING_NAME) != null;
    }

    static {
        ENDIAN = DEF = new EndianSettingsDefinition();
    }
}

