/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.DynamicVariableStorage;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.exception.InvalidInputException;

public class ParameterPieces {
    public Address address;
    public DataType type;
    public Varnode[] joinPieces;
    public boolean isThisPointer = false;
    public boolean hiddenReturnPtr = false;
    public boolean isIndirect = false;

    public void swapMarkup(ParameterPieces op) {
        boolean tmpHidden = this.hiddenReturnPtr;
        boolean tmpIndirect = this.isIndirect;
        boolean tmpThis = this.isThisPointer;
        DataType tmpType = this.type;
        Varnode[] tmpJoin = this.joinPieces;
        this.hiddenReturnPtr = op.hiddenReturnPtr;
        this.isIndirect = op.isIndirect;
        this.isThisPointer = op.isThisPointer;
        this.type = op.type;
        this.joinPieces = op.joinPieces;
        op.hiddenReturnPtr = tmpHidden;
        op.isIndirect = tmpIndirect;
        op.isThisPointer = tmpThis;
        op.type = tmpType;
        op.joinPieces = tmpJoin;
    }

    public VariableStorage getVariableStorage(Program program) {
        DynamicVariableStorage store;
        if (this.type == null) {
            this.type = DataType.DEFAULT;
        }
        if (VoidDataType.isVoidDataType(this.type)) {
            if (this.isIndirect) {
                return DynamicVariableStorage.INDIRECT_VOID_STORAGE;
            }
            return VariableStorage.VOID_STORAGE;
        }
        int sz = this.type.getLength();
        if (sz == 0) {
            return VariableStorage.UNASSIGNED_STORAGE;
        }
        if (this.isThisPointer) {
            try {
                if (this.address != null) {
                    return new DynamicVariableStorage((ProgramArchitecture)program, AutoParameterType.THIS, this.address, sz);
                }
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            return DynamicVariableStorage.getUnassignedDynamicStorage(AutoParameterType.THIS);
        }
        if ((this.address == null || this.address == Address.NO_ADDRESS) && this.joinPieces == null) {
            return DynamicVariableStorage.getUnassignedDynamicStorage(this.isIndirect);
        }
        try {
            store = this.joinPieces != null ? new DynamicVariableStorage((ProgramArchitecture)program, this.isIndirect, this.joinPieces) : (this.hiddenReturnPtr ? new DynamicVariableStorage((ProgramArchitecture)program, AutoParameterType.RETURN_STORAGE_PTR, this.address, sz) : new DynamicVariableStorage((ProgramArchitecture)program, this.isIndirect, this.address, sz));
        }
        catch (InvalidInputException e) {
            store = DynamicVariableStorage.getUnassignedDynamicStorage(this.isIndirect);
        }
        return store;
    }
}

