/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSetViewAdapter;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OldGenericNamespaceAddress;
import ghidra.program.model.lang.Register;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RegisterManager {
    private List<Register> registers;
    private Map<String, Register> registerNameMap = new HashMap<String, Register>();
    private List<String> registerNames;
    private List<Register> contextRegisters;
    private Register contextBaseRegister;
    private Map<RegisterSizeKey, Register> sizeMap = new HashMap<RegisterSizeKey, Register>();
    private Map<Address, List<Register>> registerAddressMap = new HashMap<Address, List<Register>>();
    private AddressSet registerAddresses = new AddressSet();
    private AddressSetView registerAddressesView = new AddressSetViewAdapter(this.registerAddresses);
    private List<Register> sortedVectorRegisters;
    private static Comparator<Register> registerSizeComparator = new Comparator<Register>(){

        @Override
        public int compare(Register r1, Register r2) {
            return r2.getBitLength() - r1.getBitLength();
        }
    };

    RegisterManager(List<Register> registers, Map<String, Register> registerNameMap) {
        this.registers = Collections.unmodifiableList(registers);
        this.registerNameMap = Collections.unmodifiableMap(registerNameMap);
        this.initialize();
    }

    private void initialize() {
        ArrayList<String> registerNameList = new ArrayList<String>();
        ArrayList<Register> contextRegisterList = new ArrayList<Register>();
        ArrayList<Register> registerListSortedBySize = new ArrayList<Register>(this.registers);
        Collections.sort(registerListSortedBySize, registerSizeComparator);
        for (Register reg : registerListSortedBySize) {
            Address addr;
            List<Register> list;
            String regName = reg.getName();
            registerNameList.add(regName);
            if (reg.isProcessorContext()) {
                contextRegisterList.add(reg);
                if (reg.isBaseRegister()) {
                    this.contextBaseRegister = reg;
                }
            }
            if ((list = this.registerAddressMap.get(addr = reg.getAddress())) == null) {
                list = new ArrayList<Register>();
                this.registerAddressMap.put(addr, list);
            }
            list.add(reg);
            this.addRegisterAddresses(reg);
            if (reg.isProcessorContext()) continue;
            if (reg.isBigEndian()) {
                this.populateSizeMapBigEndian(reg);
                continue;
            }
            this.populateSizeMapLittleEndian(reg);
        }
        if (this.contextBaseRegister == null) {
            this.contextBaseRegister = Register.NO_CONTEXT;
        }
        Collections.reverse(registerListSortedBySize);
        for (Register register : registerListSortedBySize) {
            this.sizeMap.put(new RegisterSizeKey(register.getAddress(), 0), register);
        }
        this.contextRegisters = Collections.unmodifiableList(contextRegisterList);
        Collections.sort(registerNameList);
        this.registerNames = Collections.unmodifiableList(registerNameList);
    }

    private void addRegisterAddresses(Register reg) {
        Address min = reg.getAddress();
        this.registerAddresses.add(min, min.add(reg.getNumBytes() - 1));
    }

    private void populateSizeMapBigEndian(Register reg) {
        int regSize = reg.getMinimumByteSize();
        for (int i = 1; i <= regSize; ++i) {
            Address address = reg.getAddress().add(regSize - i);
            this.sizeMap.put(new RegisterSizeKey(address, i), reg);
        }
    }

    private void populateSizeMapLittleEndian(Register reg) {
        int regSize = reg.getMinimumByteSize();
        for (int i = 1; i <= regSize; ++i) {
            this.sizeMap.put(new RegisterSizeKey(reg.getAddress(), i), reg);
        }
    }

    public Register getContextBaseRegister() {
        return this.contextBaseRegister;
    }

    public List<Register> getContextRegisters() {
        return this.contextRegisters;
    }

    public List<String> getRegisterNames() {
        return this.registerNames;
    }

    public Register getRegister(Address addr) {
        AddressSpace space = addr.getAddressSpace();
        if (space.isRegisterSpace() || space.hasMappedRegisters()) {
            return this.sizeMap.get(new RegisterSizeKey(addr, 0));
        }
        return null;
    }

    public Register[] getRegisters(Address addr) {
        List<Register> list;
        AddressSpace space = addr.getAddressSpace();
        if ((space.isRegisterSpace() || space.hasMappedRegisters()) && (list = this.registerAddressMap.get(this.getGlobalAddress(addr))) != null) {
            Register[] regs = new Register[list.size()];
            list.toArray(regs);
            return regs;
        }
        return new Register[0];
    }

    private Address getGlobalAddress(Address addr) {
        if (addr instanceof OldGenericNamespaceAddress) {
            return ((OldGenericNamespaceAddress)addr).getGlobalAddress();
        }
        return addr;
    }

    public Register getRegister(Address addr, int size) {
        AddressSpace space = addr.getAddressSpace();
        if (space.isRegisterSpace() || space.hasMappedRegisters()) {
            return this.sizeMap.get(new RegisterSizeKey(addr, size));
        }
        return null;
    }

    public Register getRegister(String name) {
        return this.registerNameMap.get(name);
    }

    public List<Register> getRegisters() {
        return this.registers;
    }

    public List<Register> getSortedVectorRegisters() {
        if (this.sortedVectorRegisters == null) {
            ArrayList<Register> list = new ArrayList<Register>();
            for (Register reg : this.registers) {
                if (!reg.isVectorRegister()) continue;
                list.add(reg);
            }
            Collections.sort(list, RegisterManager::compareVectorRegisters);
            this.sortedVectorRegisters = Collections.unmodifiableList(list);
        }
        return this.sortedVectorRegisters;
    }

    public AddressSetView getRegisterAddresses() {
        return this.registerAddressesView;
    }

    private static int compareVectorRegisters(Register reg1, Register reg2) {
        if (!reg1.isVectorRegister() || !reg2.isVectorRegister()) {
            throw new IllegalArgumentException("compareVectorRegisters can only be applied to vector registers!");
        }
        int sizeComp = Integer.compare(reg2.getBitLength(), reg1.getBitLength());
        if (sizeComp != 0) {
            return sizeComp;
        }
        return Integer.compare(reg1.getOffset(), reg2.getOffset());
    }

    class RegisterSizeKey {
        Address address;
        int size;

        public RegisterSizeKey(Address addr, int size) {
            this.address = RegisterManager.this.getGlobalAddress(addr);
            this.size = size < 0 ? 0 : size;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            RegisterSizeKey other = (RegisterSizeKey)obj;
            return other.address.equals(this.address) && other.size == this.size;
        }

        public int hashCode() {
            return this.address.hashCode() << 8 + this.size;
        }

        public String toString() {
            return "{" + this.address.toString() + ", size = " + this.size + "}";
        }
    }
}

