/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.protorules.QualifierFilter;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public class VarargsFilter
implements QualifierFilter {
    @Override
    public QualifierFilter clone() {
        return new VarargsFilter();
    }

    @Override
    public boolean isEquivalent(QualifierFilter op) {
        return this.getClass() == op.getClass();
    }

    @Override
    public boolean filter(PrototypePieces proto, int pos) {
        if (proto.firstVarArgSlot < 0) {
            return false;
        }
        return pos >= proto.firstVarArgSlot;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_VARARGS);
        encoder.closeElement(ElementId.ELEM_VARARGS);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_VARARGS.name()});
        parser.end(elem);
    }
}

