/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.PcodeBlockBasic;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.SequenceNumber;
import ghidra.program.model.pcode.Varnode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class PcodeOp {
    public static final int UNIMPLEMENTED = 0;
    public static final int COPY = 1;
    public static final int LOAD = 2;
    public static final int STORE = 3;
    public static final int BRANCH = 4;
    public static final int CBRANCH = 5;
    public static final int BRANCHIND = 6;
    public static final int CALL = 7;
    public static final int CALLIND = 8;
    public static final int CALLOTHER = 9;
    public static final int RETURN = 10;
    public static final int INT_EQUAL = 11;
    public static final int INT_NOTEQUAL = 12;
    public static final int INT_SLESS = 13;
    public static final int INT_SLESSEQUAL = 14;
    public static final int INT_LESS = 15;
    public static final int INT_LESSEQUAL = 16;
    public static final int INT_ZEXT = 17;
    public static final int INT_SEXT = 18;
    public static final int INT_ADD = 19;
    public static final int INT_SUB = 20;
    public static final int INT_CARRY = 21;
    public static final int INT_SCARRY = 22;
    public static final int INT_SBORROW = 23;
    public static final int INT_2COMP = 24;
    public static final int INT_NEGATE = 25;
    public static final int INT_XOR = 26;
    public static final int INT_AND = 27;
    public static final int INT_OR = 28;
    public static final int INT_LEFT = 29;
    public static final int INT_RIGHT = 30;
    public static final int INT_SRIGHT = 31;
    public static final int INT_MULT = 32;
    public static final int INT_DIV = 33;
    public static final int INT_SDIV = 34;
    public static final int INT_REM = 35;
    public static final int INT_SREM = 36;
    public static final int BOOL_NEGATE = 37;
    public static final int BOOL_XOR = 38;
    public static final int BOOL_AND = 39;
    public static final int BOOL_OR = 40;
    public static final int FLOAT_EQUAL = 41;
    public static final int FLOAT_NOTEQUAL = 42;
    public static final int FLOAT_LESS = 43;
    public static final int FLOAT_LESSEQUAL = 44;
    public static final int FLOAT_NAN = 46;
    public static final int FLOAT_ADD = 47;
    public static final int FLOAT_DIV = 48;
    public static final int FLOAT_MULT = 49;
    public static final int FLOAT_SUB = 50;
    public static final int FLOAT_NEG = 51;
    public static final int FLOAT_ABS = 52;
    public static final int FLOAT_SQRT = 53;
    public static final int FLOAT_INT2FLOAT = 54;
    public static final int FLOAT_FLOAT2FLOAT = 55;
    public static final int FLOAT_TRUNC = 56;
    public static final int FLOAT_CEIL = 57;
    public static final int FLOAT_FLOOR = 58;
    public static final int FLOAT_ROUND = 59;
    public static final int MULTIEQUAL = 60;
    public static final int INDIRECT = 61;
    public static final int PIECE = 62;
    public static final int SUBPIECE = 63;
    public static final int CAST = 64;
    public static final int PTRADD = 65;
    public static final int PTRSUB = 66;
    public static final int SEGMENTOP = 67;
    public static final int CPOOLREF = 68;
    public static final int NEW = 69;
    public static final int INSERT = 70;
    public static final int EXTRACT = 71;
    public static final int POPCOUNT = 72;
    public static final int LZCOUNT = 73;
    public static final int PCODE_MAX = 74;
    private static Hashtable<String, Integer> opcodeTable;
    private int opcode;
    private SequenceNumber seqnum;
    private Varnode[] input;
    private Varnode output;

    public PcodeOp(SequenceNumber sq, int op, int numinputs, Varnode out) {
        this.opcode = op;
        this.seqnum = sq;
        this.input = new Varnode[numinputs];
        this.output = out;
    }

    public PcodeOp(SequenceNumber sq, int op, Varnode[] in, Varnode out) {
        this.opcode = op;
        this.seqnum = sq;
        this.input = in;
        this.output = out;
    }

    public PcodeOp(Address a, int sequencenumber, int op, Varnode[] in, Varnode out) {
        this.opcode = op;
        this.seqnum = new SequenceNumber(a, sequencenumber);
        this.input = in;
        this.output = out;
    }

    public PcodeOp(Address a, int sequencenumber, int op, Varnode[] in) {
        this(a, sequencenumber, op, in, null);
    }

    public PcodeOp(Address a, int sequencenumber, int op) {
        this(a, sequencenumber, op, new Varnode[0], null);
    }

    public final int getOpcode() {
        return this.opcode;
    }

    public final int getNumInputs() {
        if (this.input == null) {
            return 0;
        }
        return this.input.length;
    }

    public final Varnode[] getInputs() {
        return this.input;
    }

    public final Varnode getInput(int i) {
        if (i >= this.input.length || i < 0) {
            return null;
        }
        return this.input[i];
    }

    public final Varnode getOutput() {
        return this.output;
    }

    public final int getSlot(Varnode vn) {
        int i;
        int n = this.input.length;
        for (i = 0; i < n && this.input[i] != vn; ++i) {
        }
        return i;
    }

    public final String getMnemonic() {
        return PcodeOp.getMnemonic(this.opcode);
    }

    public boolean isDead() {
        return false;
    }

    public final boolean isAssignment() {
        return this.output != null;
    }

    public final boolean isCommutative() {
        return PcodeOp.isCommutative(this.opcode);
    }

    public final SequenceNumber getSeqnum() {
        return this.seqnum;
    }

    public Iterator<PcodeOp> getBasicIter() {
        return null;
    }

    public Iterator<Object> getInsertIter() {
        return null;
    }

    public PcodeBlockBasic getParent() {
        return null;
    }

    public final void setOpcode(int o) {
        this.opcode = o;
    }

    public final void setInput(Varnode vn, int slot) {
        if (this.input == null) {
            this.input = new Varnode[slot + 1];
            for (int i = 0; i < this.input.length; ++i) {
                this.input[i] = null;
            }
        } else if (slot >= this.input.length) {
            int i;
            Varnode[] newinput = new Varnode[slot + 1];
            for (i = 0; i < this.input.length; ++i) {
                newinput[i] = this.input[i];
            }
            for (i = this.input.length; i < newinput.length; ++i) {
                newinput[i] = null;
            }
            this.input = newinput;
        }
        this.input[slot] = vn;
    }

    public final void removeInput(int slot) {
        int i;
        if (this.input.length == 1) {
            this.input = null;
            return;
        }
        Varnode[] newinput = new Varnode[this.input.length - 1];
        for (i = 0; i < slot; ++i) {
            newinput[i] = this.input[i];
        }
        for (i = slot; i < newinput.length; ++i) {
            newinput[i] = this.input[i + 1];
        }
        this.input = newinput;
    }

    public final void insertInput(Varnode vn, int slot) {
        int i;
        if (this.input == null) {
            this.setInput(vn, slot);
            return;
        }
        Varnode[] newinput = new Varnode[this.input.length + 1];
        for (i = 0; i < slot; ++i) {
            newinput[i] = this.input[i];
        }
        for (i = slot + 1; i < newinput.length; ++i) {
            newinput[i] = this.input[i - 1];
        }
        newinput[slot] = vn;
        this.input = newinput;
    }

    public final void setTime(int t) {
        this.seqnum.setTime(t);
    }

    public final void setOrder(int ord) {
        this.seqnum.setOrder(ord);
    }

    public final void setOutput(Varnode vn) {
        this.output = vn;
    }

    public void encodeRaw(Encoder encoder, AddressFactory addrFactory) throws IOException {
        encoder.openElement(ElementId.ELEM_OP);
        encoder.writeSignedInteger(AttributeId.ATTRIB_CODE, this.opcode);
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, this.input.length);
        if (this.output == null) {
            encoder.openElement(ElementId.ELEM_VOID);
            encoder.closeElement(ElementId.ELEM_VOID);
        } else {
            this.output.encodeRaw(encoder);
        }
        if (this.opcode == 2 || this.opcode == 3) {
            int spaceId = (int)this.input[0].getOffset();
            encoder.openElement(ElementId.ELEM_SPACEID);
            AddressSpace space = addrFactory.getAddressSpace(spaceId);
            encoder.writeSpace(AttributeId.ATTRIB_NAME, space);
            encoder.closeElement(ElementId.ELEM_SPACEID);
        } else if (this.input.length > 0) {
            this.input[0].encodeRaw(encoder);
        }
        for (int i = 1; i < this.input.length; ++i) {
            this.input[i].encodeRaw(encoder);
        }
        encoder.closeElement(ElementId.ELEM_OP);
    }

    public static PcodeOp decode(Decoder decoder, PcodeFactory pfact) throws DecoderException {
        int subel;
        int el = decoder.openElement(ElementId.ELEM_OP);
        int opc = (int)decoder.readSignedInteger(AttributeId.ATTRIB_CODE);
        SequenceNumber seqnum = SequenceNumber.decode(decoder);
        Varnode output = Varnode.decode(decoder, pfact);
        ArrayList<Varnode> inputlist = new ArrayList<Varnode>();
        while ((subel = decoder.peekElement()) != 0) {
            Varnode vn = Varnode.decode(decoder, pfact);
            inputlist.add(vn);
        }
        PcodeOp res = pfact.newOp(seqnum, opc, inputlist, output);
        decoder.closeElement(el);
        return res;
    }

    public String toString() {
        Object s = this.output != null ? this.output.toString() : " --- ";
        s = (String)s + " " + this.getMnemonic() + " ";
        for (int i = 0; i < this.input.length; ++i) {
            s = this.input[i] == null ? (String)s + "null" : (String)s + this.input[i].toString();
            if (i >= this.input.length - 1) continue;
            s = (String)s + " , ";
        }
        return s;
    }

    public int hashCode() {
        return this.opcode + this.seqnum.hashCode();
    }

    private static void generateOpcodeTable() {
        opcodeTable = new Hashtable();
        for (int i = 0; i < 74; ++i) {
            opcodeTable.put(PcodeOp.getMnemonic(i), i);
        }
        opcodeTable.put("BUILD", 60);
        opcodeTable.put("DELAY_SLOT", 61);
        opcodeTable.put("LABEL", 65);
        opcodeTable.put("CROSSBUILD", 66);
    }

    public static final String getMnemonic(int op) {
        switch (op) {
            case 0: {
                return "UNIMPLEMENTED";
            }
            case 1: {
                return "COPY";
            }
            case 2: {
                return "LOAD";
            }
            case 3: {
                return "STORE";
            }
            case 4: {
                return "BRANCH";
            }
            case 5: {
                return "CBRANCH";
            }
            case 6: {
                return "BRANCHIND";
            }
            case 7: {
                return "CALL";
            }
            case 8: {
                return "CALLIND";
            }
            case 9: {
                return "CALLOTHER";
            }
            case 10: {
                return "RETURN";
            }
            case 11: {
                return "INT_EQUAL";
            }
            case 12: {
                return "INT_NOTEQUAL";
            }
            case 13: {
                return "INT_SLESS";
            }
            case 14: {
                return "INT_SLESSEQUAL";
            }
            case 15: {
                return "INT_LESS";
            }
            case 16: {
                return "INT_LESSEQUAL";
            }
            case 17: {
                return "INT_ZEXT";
            }
            case 18: {
                return "INT_SEXT";
            }
            case 19: {
                return "INT_ADD";
            }
            case 20: {
                return "INT_SUB";
            }
            case 21: {
                return "INT_CARRY";
            }
            case 22: {
                return "INT_SCARRY";
            }
            case 23: {
                return "INT_SBORROW";
            }
            case 24: {
                return "INT_2COMP";
            }
            case 25: {
                return "INT_NEGATE";
            }
            case 26: {
                return "INT_XOR";
            }
            case 27: {
                return "INT_AND";
            }
            case 28: {
                return "INT_OR";
            }
            case 29: {
                return "INT_LEFT";
            }
            case 30: {
                return "INT_RIGHT";
            }
            case 31: {
                return "INT_SRIGHT";
            }
            case 32: {
                return "INT_MULT";
            }
            case 33: {
                return "INT_DIV";
            }
            case 34: {
                return "INT_SDIV";
            }
            case 35: {
                return "INT_REM";
            }
            case 36: {
                return "INT_SREM";
            }
            case 37: {
                return "BOOL_NEGATE";
            }
            case 38: {
                return "BOOL_XOR";
            }
            case 39: {
                return "BOOL_AND";
            }
            case 40: {
                return "BOOL_OR";
            }
            case 41: {
                return "FLOAT_EQUAL";
            }
            case 42: {
                return "FLOAT_NOTEQUAL";
            }
            case 43: {
                return "FLOAT_LESS";
            }
            case 44: {
                return "FLOAT_LESSEQUAL";
            }
            case 46: {
                return "FLOAT_NAN";
            }
            case 47: {
                return "FLOAT_ADD";
            }
            case 48: {
                return "FLOAT_DIV";
            }
            case 49: {
                return "FLOAT_MULT";
            }
            case 50: {
                return "FLOAT_SUB";
            }
            case 51: {
                return "FLOAT_NEG";
            }
            case 52: {
                return "FLOAT_ABS";
            }
            case 53: {
                return "FLOAT_SQRT";
            }
            case 54: {
                return "INT2FLOAT";
            }
            case 55: {
                return "FLOAT2FLOAT";
            }
            case 56: {
                return "TRUNC";
            }
            case 57: {
                return "CEIL";
            }
            case 58: {
                return "FLOOR";
            }
            case 59: {
                return "ROUND";
            }
            case 60: {
                return "MULTIEQUAL";
            }
            case 61: {
                return "INDIRECT";
            }
            case 62: {
                return "PIECE";
            }
            case 63: {
                return "SUBPIECE";
            }
            case 64: {
                return "CAST";
            }
            case 65: {
                return "PTRADD";
            }
            case 66: {
                return "PTRSUB";
            }
            case 68: {
                return "CPOOLREF";
            }
            case 69: {
                return "NEW";
            }
            case 70: {
                return "INSERT";
            }
            case 71: {
                return "EXTRACT";
            }
            case 72: {
                return "POPCOUNT";
            }
            case 73: {
                return "LZCOUNT";
            }
        }
        return "INVALID_OP";
    }

    public static int getOpcode(String s) throws UnknownInstructionException {
        Integer i;
        if (opcodeTable == null) {
            PcodeOp.generateOpcodeTable();
        }
        if ((i = opcodeTable.get(s)) == null) {
            throw new UnknownInstructionException();
        }
        return i;
    }

    public static boolean isCommutative(int opcode) {
        switch (opcode) {
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 47: 
            case 49: {
                return true;
            }
        }
        return false;
    }
}

